

/*
   Simple program to expose applications that do not mix correctly
   into the audio stream, or depend on fixed-size buffers.
   There is a frightening number of such badly-behaved applications
   out there, including several well-known audio-players, games and
   even the Terminal beep.
   
   If your favourite application fails the "mixtest" test, go harass 
   the author for a newer version.


   Usage:
   WARNING-WARNING-WARNING!!!! USE AT YOUR OWN RISK. IF YOUR SPEAKERS,
   AMPLIFIER, COMPUTER OR ANYTHING ELSE WITHIN A 6000 MILE RADIUS
   BLOWS UP, DO NOT BLAME ME!

   You'll hear a fairly hard popping-noise when mixtest starts, you
   might want to turn down your speaker/amplifier. It's also a bad
   idea to leave it running for a long period, as some amplifiers 
   don't like being fed a signal with a larg DC-offset.

   First start the program you want to test, then start mixtest.
   Mixtest will place itself at the start of the stream, and will
   fill it with the value 24000, thus creating a DC offset in the
   audio signal.
   Mixtest will also change the size of the buffers at regular intervals.

   When run together with mixtest, a program that does not mix correctly
   will produce very loud noises, caused by the sampledata wrapping from
   32767 to -32768 and vice versa.
   A program that mixes correctly will not do this, although because of
   extreme DC-offset and the resulting clipping, the sound will not be
   as good as it is normally.
   A program that depends on fixed-size buffers will appear to stutter
   when run together with mixtest.

*/


class mywin : public BWindow
{
	public:		mywin(BRect r,char *name,window_type type,ulong mode)
					: BWindow(r,name,type,mode)
				{}

	virtual bool	QuitRequested()
					{
						be_app->PostMessage(B_QUIT_REQUESTED);
						return TRUE;
					}
};


bool _process_sound(void *arg, char *buf, ulong count, void *info);

void main(void)
{
	BApplication app("application/x-marcone-mixtest");

	size_t buffersize;
	int32 buffercount;
	bool isrunning;
	int32 subscribercount;

	BSubscriber *audsub=new BSubscriber("mix-test");
	BDACStream *audstream=new BDACStream();
	audsub->Subscribe(audstream);

	audstream->GetStreamParameters(&buffersize,&buffercount,&isrunning,&subscribercount);

	audsub->EnterStream(NULL,true, /* neighbor, after */
					audstream, // void *arg
					_process_sound,
					NULL,
					true /* run as seperate thread */
				 );
	mywin *win=new mywin(BRect(100,100,300,200),"Mix-test",B_TITLED_WINDOW,0);
	BButton *button=new BButton(BRect(0,0,200,100),"","Test running, click to end",new BMessage(B_QUIT_REQUESTED));
	win->AddChild(button);
	
	win->Show();
	app.Run();
	
	audsub->ExitStream(true);                 // wait until subscriber exits
	audstream->SetStreamBuffers(buffersize,buffercount); // restore settings
}

long sizecount=0;

bool _process_sound(void *arg, char *buf, ulong count, void *info)
{
	BDACStream *thisstream=(BDACStream *)arg;

	short *shortbuf=(short*)buf;
	long tmp;
	for(int i=0;i<count/2;i++)
	{
		tmp=shortbuf[i]+24000;
		if(tmp>32767)
			shortbuf[i]=32767;
		else if(tmp<-32768)
			shortbuf[i]=-32768;
		else
			shortbuf[i]=tmp;
	}

	sizecount++;
	if(sizecount==1)
		thisstream->SetStreamBuffers(2048,8);
	else if(sizecount==2)
		thisstream->SetStreamBuffers(3072,8);
	else if(sizecount==3)
		thisstream->SetStreamBuffers(4096,8);
	else
		sizecount=0;
	
	return true; // keep running
}

