/* Error index enum, and extern declaration of the error vector.

   Copyright (C) 1993-1996 Sebastiano Vigna

    This file is part of ne, the nice editor.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */


/* Here we define the table of error messages. These defines are used
whenever a function wants to return a specific error to the caller, and
wants also to specify that an error message has to be printed. The generic
error code which just says "something went wrong" is -1. 0 represents
success. Any positive value is one of these enum items, and can be used to
index the error message table. Whenever this enum is updated, the
corresponding vector in errors.c *must* be updated too. */

#ifdef OK
#undef OK
#endif

#ifdef ERROR
#undef ERROR
#endif

#define ERROR	(-1)
#define OK		(0)

enum error {
	SYNTAX_ERROR = 1,
	NOT_FOUND,
	CANT_SAVE_EXIT_SUSPENDED,
	NOT_ON_A_BRACKET,
	CANT_FIND_BRACKET,
	BOOKMARK_OUT_OF_RANGE,
	CANT_INSERT_0,
	NO_SEARCH_STRING,
	NO_REPLACE_STRING,
	TAB_SIZE_OUT_OF_RANGE,
	MARK_BLOCK_FIRST,
	OUT_OF_MEMORY,
	NOTHING_TO_UNDO,
	NOTHING_TO_REDO,
	NO_SUCH_COMMAND,
	CAN_EXECUTE_ONLY_OPTIONS,
	HAS_NUMERIC_ARGUMENT,
	HAS_NO_ARGUMENT,
	REQUIRES_ARGUMENT,
	WRONG_CHAR_AFTER_BACKSLASH,
	CANT_OPEN_FILE,
	ERROR_WHILE_WRITING,
	HAS_NO_EXTENSION,
	CANT_FIND_PREFS_DIR,
	CLIP_DOESNT_EXIST,
	MARK_OUT_OF_BUFFER,
	CANT_OPEN_MACRO,
	FILE_IS_READ_ONLY,
	STOPPED,
	IO_ERROR,
	STRING_IS_EMPTY,
	EXTERNAL_COMMAND_ERROR,
	ESCAPE_TIME_OUT_OF_RANGE,
	ERROR_COUNT
};

enum info {
	SAVING,
	DONE,
	INFO_COUNT
};

extern char *error_msg[ERROR_COUNT];
extern char *info_msg[INFO_COUNT];
