/*  
	BeOS Front-end of PDF file reader xpdf.
    Copyright (C) 1997 Benoit Triquet
    Copyright (C) 1998-99 Hubert Figuiere
	Copyright (C) 2000 Michael Pfeiffer
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include "PrintingProgressWindow.h"
#include <StringView.h>

PrintingProgressWindow::PrintingProgressWindow(const char *text, BRect aRect, int32 pages) 
	: BWindow(aRect, "PDFViewer Printing", 
		B_MODAL_WINDOW_LOOK,
		B_MODAL_APP_WINDOW_FEEL, 
		B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_NOT_CLOSABLE) {
	mPages = pages; mPrintedPages = 0;
	mState = OK;
	
	BString s("PDFViewer printing document: ");
	s += text;
	// center window
	aRect.OffsetBy(aRect.Width() / 2, aRect.Height() / 2);
	float width = 300, height = 60;
	aRect.SetRightBottom(BPoint(aRect.left + width, aRect.top + height));
	aRect.OffsetBy(-aRect.Width() / 2, -aRect.Height() / 2);
	// view for the background color
	BRect rect(0, 0, width, height);
	BView *view = new BView(rect, "status_view", B_FOLLOW_NONE, 0);
	view->SetViewColor(225, 255, 225, 255);

	BStringView *stringView = new BStringView(BRect(10, 0, width, 20), "label", s.String());

	// stringView->SetViewColor(128, 128, 128, 255);
	// stringView->SetAlignment(B_ALIGN_CENTER);
	view->AddChild(stringView);
	mPageString = new BStringView(BRect(10, 21, 60, 40), "page", "Page:");
	view->AddChild(mPageString);

	// 
	mProgress = new BStatusBar(BRect(7, 31, width - 140, 40), "progress_bar");
	mProgress->SetMaxValue(pages); mProgress->SetBarHeight(8);
	view->AddChild(mProgress);
	mStop = new BButton(BRect(width-130, 31, width-70, 50), "stop", "Stop", new BMessage('STOP'));
	view->AddChild(mStop);
	mAbort = new BButton(BRect(width-60, 31, width-1, 50), "abort", "Abort", new BMessage('ABRT'));
	view->AddChild(mAbort);

	AddChild(view);
	MoveTo(aRect.left, aRect.top);
	ResizeTo(width, height);
	Show();
}

void PrintingProgressWindow::SetPage(int32 page) {
char buffer[10];
	sprintf(buffer, "Page: %d", page);
	Lock();
	mPageString->SetText(buffer);
	mPrintedPages ++;
	mProgress->Update(1);
	Unlock();
}

bool PrintingProgressWindow::Aborted() {
	return mState == ABORTED;
}

bool PrintingProgressWindow::Stopped() {
	return mState == STOPPED;
}

void PrintingProgressWindow::MessageReceived(BMessage *msg) {
	switch (msg->what) {
	case 'ABRT':
		mState = ABORTED;
		mStop->SetEnabled(false); mAbort->SetEnabled(false);
		break;
	case 'STOP':
		mState = STOPPED;
		mStop->SetEnabled(false); mAbort->SetEnabled(false);
		break;
	default:
		BWindow::MessageReceived(msg);
	}
}

