// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierClock.h ------------------------------------------------------------
#pragma once
#include "PierPane.h"

//----------------------------------------------------------------------------
// PierClockOff (offscreen view) class declaration
class PierClockOff : public BView {
public:
	PierClockOff();
	void			DrawX(void);
	virtual void	GetPreferredSize(float* width, float* height);
	void			SetFontSize(float size);
private:
	BPoint	timeLine;
};

//----------------------------------------------------------------------------

#pragma export on
class PierClock : public PierPane {
public:
	// Constructor
	PierClock(uint32 paneFlags =PIER_CLOSER );
   ~PierClock();

	// Hook functions
	virtual void	Draw(BRect updateRect);
	virtual void	GetPreferredSize(float* width, float* height);
	virtual void	Pulse();
	void			SetFontSize(float size);  //Note BView version is not virtual
	
private:
	BBitmap*		offscreen;
	PierClockOff*	offscreenView;
};
#pragma export off

