// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierWindow.h ------------------------------------------------------------
#pragma once

// PierWindowBar ===========================================================
#include <View.h>

class PierWindowBar : public BView {
public:
	//Constructor
	PierWindowBar(BRect frame, const char* name);

	//Hook Functions
	virtual void	Draw(BRect updateRect);
	virtual void	WindowActivated(bool active);

private:
	bool	isActive;
	BMenu*	menu;
};

// PierWindow ==============================================================
#include <Window.h>
#include "PierPaneSet.h"
#include "PierPane.h"

class PierWindow : public BWindow, public PierPaneSet {
public:
	// Ctor/Dtor
	PierWindow(BRect frame, const char* title, 
		window_type  type = B_TITLED_WINDOW, 
		uint32      flags = B_NOT_RESIZABLE | B_NOT_ZOOMABLE, 
    	uint32 workspaces = B_ALL_WORKSPACES); 
	PierWindow(BMessage* archive);
	 
	// Hook Functions
	virtual status_t	Archive(BMessage * archive, bool deep = true) const;
	static  PierWindow*	Instantiate(BMessage* archive);
	virtual void		WorkspaceActivated(int32 workspace, bool active);
	
	// Pane handling functions
	virtual status_t	AddPane(PierPane* pane);
	virtual status_t	RemovePane(PierPane* pane);
	virtual void		PaneResized(PierPane* pane, float dwidth, float dheight);
	virtual BRect		PaneResizeLimits(void);
	
protected:
	float		headerHeight;
	PierPane*	pane;
};

