//
// pnplist, by Jonathan Perret <perret@ufr-info-p7.jussieu.fr>
//
// The code below was for the most part copied straight from the
// Be Book, so I can't take too much credit :)
// Do whatever you like with this code, just don't hold me
// responsible.
//
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#include <drivers/Drivers.h>
#include <device/isapnp.h>
#include <device/config_mgr.h>

int main()
{
   isa_device_config config;
   status_t ret;
   int i, fd;
   
   // open plug and play configuration manager
   fd = open("/pnp/config_mgr", O_RDWR);
   
   for (i=0;;i++) {
      // fetch the configuration of the ith device
      *(uint *)&config = i;

      ret = ioctl(fd, CONFIG_MGR_GET_NTH_ISA_DEVICE_CONFIG,
         &config, sizeof(isa_device_config));
      if (ret == B_OK) {
         printf("Card: %s, Device: %s\n", config.card_name,
            config.logical_device_name);
         int j;
         if(config.num_irqs)
  		 {
	         printf("  IRQ lines :");
	         for(j=0;j<config.num_irqs;j++)
	         	printf(" %d ",config.irqs[j].irq);
	         printf("\n");
	     }
         if(config.num_dma_channels)
  		 {
	         printf("  DMA channels :");
	         for(j=0;j<config.num_dma_channels;j++)
	         	printf(" %d ",config.dma_channels[j].channel);
	         printf("\n");
	     }
         if(config.num_io_port_ranges)
  		 {
			printf("  I/O ports :");
			for(j=0;j<config.num_io_port_ranges;j++)
			{
				printf(" 0x%x",config.io_port_ranges[j].base);
				if(config.io_port_ranges[j].len>1)
					printf("-0x%x",
						config.io_port_ranges[j].base
	        			+ config.io_port_ranges[j].len - 1);
	        } 
			printf("\n");
	     }
         if(config.num_memory_ranges)
  		 {
			printf("  Memory mappings :");
			for(j=0;j<config.num_memory_ranges;j++)
			{
				printf(" 0x%-08x",config.memory_ranges[j].base);
				if(config.memory_ranges[j].len>1)
					printf("-0x%-08x",
						config.memory_ranges[j].base
	        			+ config.memory_ranges[j].len - 1);
	        }
			printf("\n");
	     }
      } else
         break;
   }
   close(fd);
   
   return 0;
}