//	StripThumb.cpp

#include "StripThumb.h"
#include "StripWindow.h"
#include <PictureButton.h>
#include <Screen.h>

const int StripThumb::thumbWidth = 14;
const int StripThumb::zoomMargin = 3;
const int StripThumb::zoomBorder = 3;
const uint32 StripThumb::zoomCmd = 'STzm';
BMessage *StripThumb::zoomMsg = new BMessage(StripThumb::zoomCmd);

StripThumb::StripThumb()
	: BView(BRect(0,0,thumbWidth,0),NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM,B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE)
{
	onPict = new BPicture();
	offPict = new BPicture();
	SetViewColor(StripWindow::titleColors->base);
}

StripThumb::~StripThumb()
{
	delete onPict;
	delete offPict;
}

void StripThumb::AttachedToWindow(void)
{
	int width;
	BPictureButton *button;
	BRect rect, littleRect, bigRect;

	ResizeTo(Bounds().Width(),Window()->Bounds().Height());
	width = Bounds().Width()-2*zoomBorder;
	rect.Set(0,0,width,width);	
	bigRect = rect;
	bigRect.left += (bigRect.right/4 - 1);
	bigRect.top += (bigRect.bottom/4 - 1);
	littleRect = rect;
	(++littleRect.right) /= 2;
	(++littleRect.bottom) /= 2;
	BeginPicture(offPict);
	drawOffBox(bigRect);
	drawOffBox(littleRect);
	EndPicture();
	BeginPicture(onPict);
	drawOnBox(bigRect);
	drawOnBox(littleRect);
	EndPicture();
	rect.OffsetBy(zoomBorder,zoomMargin);
	button = new BPictureButton(rect,NULL,offPict,onPict,zoomMsg);
	button->SetTarget(this);
	AddChild(button);
}

void StripThumb::Draw(BRect clipRect)
{
	BRect rect;

	rect = Bounds();
	SetHighColor(StripWindow::titleColors->shadow);
	StrokeLine(rect.RightTop(),rect.RightBottom());
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	SetHighColor(StripWindow::titleColors->brightHighlight);
	StrokeLine(rect.LeftTop(),rect.RightTop());
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
}

void StripThumb::MessageReceived(BMessage *message)
{
	StripWindow *window;

	switch (message->what)
	{
		case zoomCmd:
			window = cast_as(Window(),StripWindow);
			if (window)
				window->ShowHide();
			break;
	}
}

void StripThumb::drawOffBox(BRect box)
{
	BRect rect;

	rect = box;
	SetHighColor(StripWindow::titleColors->base);
	FillRect(rect);
	SetHighColor(StripWindow::titleColors->deepShadow);
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
	StrokeLine(rect.LeftTop(),rect.RightTop());
	rect.left++;
	rect.top++;
	SetHighColor(StripWindow::titleColors->brightHighlight);
	StrokeRect(rect);
	rect.InsetBy(1,1);
	SetHighColor(StripWindow::titleColors->deepShadow);
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	StrokeLine(rect.RightTop(),rect.RightBottom());
	SetHighColor(StripWindow::titleColors->highlight);
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
	StrokeLine(rect.LeftTop(),rect.RightTop());
	SetHighColor(StripWindow::titleColors->deepShadow);
	StrokeLine(rect.RightTop(),rect.RightBottom());
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	rect.InsetBy(1,1);
	SetHighColor(StripWindow::titleColors->shadow);
	StrokeLine(rect.RightTop(),rect.RightBottom());
	StrokeLine(rect.LeftBottom(),rect.RightBottom());	
}

void StripThumb::drawOnBox(BRect box)
{
	BRect rect;

	rect = box;
	SetHighColor(StripWindow::titleColors->base);
	FillRect(rect);
	SetHighColor(StripWindow::titleColors->deepShadow);
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
	StrokeLine(rect.LeftTop(),rect.RightTop());
	SetHighColor(StripWindow::titleColors->brightHighlight);
	StrokeLine(rect.RightTop(),rect.RightBottom());
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	rect.InsetBy(1,1);
	SetHighColor(StripWindow::titleColors->shadow);
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
	StrokeLine(rect.LeftTop(),rect.RightTop());
	SetHighColor(StripWindow::titleColors->highlight);
	StrokeLine(rect.RightTop(),rect.RightBottom());
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
}