//	StripWindow.cpp

#include "StripWindow.h"
#include "StripThumb.h"
#include <Application.h>
#include <Screen.h>

typedef struct
{
	int width;
	int height;
}
recalc_struct;

const int StripWindow::defaultWidth = 20;
const rgb_color StripWindow::baseColor = { 0xD8, 0xD8, 0xD8, 0xFF };
const rgb_color StripWindow::titleColor = { 0xFF, 0xCC, 0x00, 0xFF };
const StripColors *StripWindow::colors = new StripColors(baseColor);
const StripColors *StripWindow::titleColors = new StripColors(titleColor);

StripWindow::StripWindow()
	: BWindow(BRect(0,0,StripThumb::thumbWidth,defaultWidth),NULL,B_BORDERED_WINDOW,B_WILL_ACCEPT_FIRST_CLICK)
{
	BScreen screen;
	BRect frame, bounds;

	rolledUp = false;
	bounds = screen.Frame();
	MoveTo(bounds.right-StripThumb::thumbWidth,bounds.bottom-defaultWidth);
	AddChild(new StripThumb());
}

void StripWindow::ScreenChanged(BRect frame, color_space mode)
{
	adjust();
}

bool StripWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void StripWindow::AddModule(ModuleView *view)
{
	moduleList.AddItem(view);
	AddChild(view);
	Recalc();
}

void StripWindow::Recalc(void)
{
	recalc_struct data;

	Lock();
	data.width = StripThumb::thumbWidth;
	data.height = 0;
	moduleList.DoForEach(recalcProc,&data);
	data.height += (2*ModuleView::moduleBorder);
	moduleList.DoForEach(resizeProc,&data.height);
	ResizeTo(data.width,data.height);
	adjust();
	Unlock();
}

void StripWindow::ShowHide(void)
{
	rolledUp = !rolledUp;
	adjust();
}

void StripWindow::adjust(void)
{
	BScreen screen;
	BRect bounds;

	bounds = screen.Frame();
	if (rolledUp)
		MoveTo(bounds.right-StripThumb::thumbWidth,bounds.bottom-Bounds().Height());
	else
		MoveTo(bounds.right-Bounds().Width(),bounds.bottom-Bounds().Height());
}

bool StripWindow::recalcProc(void *item, void *arg)
{
	ModuleView *view;
	recalc_struct *data;
	BRect bounds;

	view = (ModuleView *)item;
	data = (recalc_struct *)arg;
	bounds = view->module->Bounds();
	data->width++;
	view->MoveTo(data->width,0);
	data->width += (bounds.Width() + 2*ModuleView::moduleBorder);
	if (data->height < bounds.Height())
		data->height = bounds.Height();
	return false;
}

bool StripWindow::resizeProc(void *item, void *arg)
{
	ModuleView *view;
	int *height;

	view = (ModuleView *)item;
	height = (int *)arg;
	view->ResizeTo(view->module->Bounds().Width() + 2*ModuleView::moduleBorder,*height);
	return false;
}
