//	ClockModule.h

#pragma once

#include "StripModule.h"
#include <PopUpMenu.h>

class ClockModule : public StripModule
{
	private:

		BFont font;
		font_height fontHeight;
		BPopUpMenu *menu;

		const static uint32 fontCmd;
		const static uint32 sizeCmd;
		const static char *fontMsg_family;

		const static char *fontMenuName;
		const static char *sizeMenuName;
		const static char *sizeChoices[];

		BMenu *makeFontMenu(void);
		BMenu *makeSizeMenu(void);
		void changeFont(void);
		void setMenuTargets(BMenu *);

	public:

		ClockModule(const char *, BEntry *);
		~ClockModule();
		void AttachedToWindow(void);
		void Draw(BRect);
		void MessageReceived(BMessage *);
		void MouseDown(BPoint);
		void Pulse(void);

		const static char *moduleName;
};
