/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#ifndef _T2S_VIEW_H
#define _T2S_VIEW_H

#include <Be.h> 
#include <FilePanel.h>
#include "convert.h"

enum {
	MSG_OPEN_PRESSED = 1000,
	MSG_SAVE_PRESSED,
	MSG_EXEC_PRESSED,
	MSG_QUIT_PRESSED,

	MSG_INTEXT_KEYIN,
	MSG_OUTEXT_KEYIN,
	
	MSG_TABSTOP_SLID
} ;

class T2SView : public BView 
{ 
    private: 
           BStringView *string ;
           rgb_color    color ;
           
           convert     *conv ;
           
           entry_ref    openref ;
           entry_ref    saveref ;
           char        *savename ;
           short        tabstop_num ;
           char         tabstopchar[ 32 ] ;
           char        *retmsg ;
           
           BView        *base ;

           BSlider *tabstop;  
   
           BButton *inputButton ; 
           BButton *outputButton ; 
           BButton *exeButton ; 
           BButton *dismisButton ; 
           
           BStringView *inputtext ; 
           BStringView *outputtext ; 

           BBox *box0 ; 
           BBox *box10 ;
           BBox *box20 ;
            
           BFilePanel  *openPanel ;
           BFilePanel  *savePanel ;

        void   AttachedToWindow  (); 
        void   _initWindow       ( BRect frame ) ;
        void   _deleteWindow     () ;
        void   _setEnableButtons ( bool flg ) ;
        void   _BAlert           ( alert_type type, char *msg ) ;
               
    public: 
               T2SView       ( BRect frame ) ; 
              ~T2SView       () ;
        void   openpanel     () ;
        void   savepanel     () ;
        void   getOpenfname  ( BMessage* msg ) ;
        void   getSavefname  ( BMessage* msg ) ;
        void   tabstopSlid   ( BMessage *msg ) ;
        void   resetSaveFname() ;
        void   convertTab    () ;
        short  retTabstop    () ;
        void   setTabstop    ( short tb_num ) ;
} ; 

#endif
