/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "fileUtil.h"

fileUtil::fileUtil()
{
    oref      = NULL ;
    sref      = NULL ;
    svname    = NULL ;
    srcTxt    = NULL ;
    retsrcTxt = NULL ;
}


fileUtil::fileUtil( entry_ref *openref, entry_ref *saveref, char *savename )
{
    oref      = openref ;
    sref      = saveref ;
    svname    = savename ;
    srcTxt    = NULL ;
    retsrcTxt = NULL ;
}


fileUtil::~fileUtil()
{
    if( retsrcTxt != NULL ) delete retsrcTxt ;
    delete srcTxt ;
}

 
char *fileUtil::openread( entry_ref *openref )
{
    BFile sorce ;
    
    oref = openref ;
    ret  = sorce.SetTo( oref, B_READ_ONLY ) ;
    if( ret != B_OK ){
        return "Error(openread)\nSetTo failed!" ;
    }
    
    sorce.GetSize( &srcLen ) ;
    srcTxt = new char[ srcLen ] ;
    if( srcTxt == NULL ){
        return "Error(openread)\nMemory allocate failed!" ;
    } 
    ret = sorce.Read( srcTxt, srcLen ) ;
    if( ret < B_OK ){ 
        delete srcTxt ;
        return "Error(openread)\nFile reading failed!" ;
    }      
    
    return NULL ;
}


char *fileUtil::openread()
{
    BFile sorce ;
    
    ret  = sorce.SetTo( oref, B_READ_ONLY ) ;
    if( ret != B_OK ){
        return "Error(openread)\nOpen SetTo failed!" ;
    }
    
    sorce.GetSize( &srcLen ) ;
    srcTxt = new char[ srcLen ] ;
    if( srcTxt == NULL ){
        return "Error(openread)\nMemory allocate failed!" ;
    } 
    ret = sorce.Read( srcTxt, srcLen ) ;
    if( ret < B_OK ){ 
        delete srcTxt ;
        return "Error(openread)\nFile reading failed!" ;
    }      
    
    return NULL ;
}


char *fileUtil::savecreate( entry_ref *saveref, char *savename )
{
    sref    = saveref ;
    svname  = savename ;
    
    ret = entry.SetTo( sref ) ;
    if( ret != B_OK ){
        delete srcTxt ;
        return "Error(savecreate)\nSave SetTo failed!" ;
    }
    entry.GetPath( &path ) ;
    path.Append( svname ) ;
    
    svfp = fopen( path.Path(), "w" ) ;             
    if( svfp == NULL ){
        delete srcTxt ;
        return "Error(savecreate)\nSave File opening failed!" ;
    }
    return NULL ;    
}


char *fileUtil::savecreate()
{
    ret = entry.SetTo( sref ) ;
    if( ret != B_OK ){
        delete srcTxt ;
        return "Error(savecreate)\nSetTo failed!" ;
    }
    entry.GetPath( &path ) ;
    path.Append( svname ) ;
    
    svfp = fopen( path.Path(), "w" ) ;             
    if( svfp == NULL ){
        delete srcTxt ;
        return "Error(savecreate)\nSave File opening failed!" ;
    }
    return NULL ;    
}


char *fileUtil::saveopen()
{
    ret = entry.SetTo( sref ) ;
    if( ret != B_OK ){
        return "Error...\nSetTo failed!" ;
    }
    entry.GetPath( &path ) ;
    path.Append( svname ) ;
    
    svfp = fopen( path.Path(), "wb" ) ;             
    if( svfp == NULL ){
        return "Error(saveopen)\nSave File opening failed!" ;
    }
    return NULL ;
}


char *fileUtil::savewrite( char *text, int textlen )
{   
    ret = fwrite( text, 1, textlen, svfp ) ;
    if( ret < B_OK ){
        return "Error(saveopen)\nFile writing failed!" ;
    }

    return NULL ;
}


void fileUtil::savewrite( char *text )
{
    fprintf( svfp, "%s", text ) ;
}


char *fileUtil::saveclose()
{
    fclose( svfp ) ;   
    return NULL ;
}

FILE *fileUtil::retsavefilep()
{
    return svfp ;
}


char *fileUtil::filebuff( int *len )
{
    if( retsrcTxt != NULL ) delete retsrcTxt ;
    
    retsrcTxt = new char[ srcLen ] ;
    memcpy( retsrcTxt, srcTxt, srcLen ) ;
    *len = srcLen ;
    return retsrcTxt ;
}
/*
 * End.
 */