#include "const.h"
#include "lochead.eng"
#include "loctoup.eng"

#include "global.c"
#include "os.c"
#include "rdwrfn.c"
#include "others.c"
#include "smallfn.c"
#include "block.c"
#include "getargs.c"
#include "comment.c"
#include "getopt.c"
#include "extract.c"
#include "somefn.c"
#include "list.c"
#include "compr.c"


int main(int Argc, char *Argv[])
{
  setbuf(stdout,NULL);
  InitCRC();
  InitSomeVars();
#ifdef _UNIX
  Umask = umask(0);
  umask(Umask);
  Umask &= 0777;
#else
  Umask = 0;	/* not used */
#endif
  if (signal(SIGINT,SIG_IGN)!=SIG_IGN)
    signal(SIGINT,ProcessSignal);
  if (signal(SIGTERM,SIG_IGN)!=SIG_IGN)
    signal(SIGTERM,ProcessSignal);
#ifdef SIGBREAK
  if (signal(SIGBREAK,SIG_IGN)!=SIG_IGN)
    signal(SIGBREAK,ProcessSignal);
#endif

  SplitCommandLine(Argc,Argv);
  ExecuteCommand();
  ShutDown(SD_MEMORY);
  return ExitCode;
}


int CmpName(char *Wildcard,char *Name,int CmpPath)
{
  int Wildcards;
  char Path1[NM],Name1[NM],*NamePtr1;
  char Path2[NM],Name2[NM],*NamePtr2;
  Wildcards=SplitPath(Wildcard,Path1,Name1,1);
  SplitPath(Name,Path2,Name2,1);
  if (CmpPath==1 && stricomp(Path1,Path2)!=0)
    return(0);
  if (CmpPath==2)
    if (Wildcards || Opt.Recurse)
    {
      if (strnicomp(Path1,Path2,strlen(Path1))!=0)
        return(0);
    }
    else
      if (stricomp(Path1,Path2)!=0)
        return(0);

  NamePtr1=Name1;
  NamePtr2=Name2;

  while (*NamePtr1)
  {
    if (*NamePtr1=='*')
    {
      if ((NamePtr1=strchr(NamePtr1,'.'))!=NULL)
        NamePtr1++;
      else
        break;

      if ((NamePtr2=strchr(NamePtr2,'.'))!=NULL)
      {
        NamePtr2++;
        if (*NamePtr1==0 && *NamePtr2)
          return(0);
      }
      else
        return(*NamePtr1==0 || *NamePtr1=='*');
      continue;
    }
    if (*NamePtr1=='?')
    {
      NamePtr1++;
      if (NamePtr2!=NULL && *NamePtr2)
        NamePtr2++;
      continue;
    }

    if (NamePtr2!=NULL && toupper(*NamePtr1)==toupper(*NamePtr2))
    {
      NamePtr1++;
      NamePtr2++;
    }
    else
      return(0);
  }
  if (NamePtr1!=NULL && *NamePtr1==0 && *NamePtr2)
    return(0);
  return(1);
}


void ErrExit(int ErrCode,int Code)
{
  char ErrMsg[200];
  switch(ErrCode)
  {
    case EEMPTY:
      strcpy(ErrMsg,"");
      break;
    case EWRITE:
      strcpy(ErrMsg,MErrWrite);
      break;
    case EREAD:
      strcpy(ErrMsg,MErrRead);
      break;
    case ESEEK:
      strcpy(ErrMsg,MErrSeek);
      break;
    case EOPEN:
      strcpy(ErrMsg,MErrFOpen);
      break;
    case ECREAT:
      strcpy(ErrMsg,MErrFCreat);
      break;
    case ECLOSE:
      strcpy(ErrMsg,MErrFClose);
      break;
    case EMEMORY:
      strcpy(ErrMsg,MErrOutMem);
      break;
    case EARCH:
      strcpy(ErrMsg,MErrBrokenArc);
      break;
  }
  if (ErrCode!=EEMPTY)
    mprintf("\n%s\n%s\n",ErrMsg,MProgAborted);
  ShutDown(SD_FILES | SD_MEMORY);
  exit(Code);
}


void ProcessSignal(int SigType)
{
  if (SigType!=SIGTERM)
    mprintf(MBreak);
  ShutDown(SD_FILES | SD_MEMORY);
  exit(USER_BREAK);
}


void CreatePath(char *fpath)
{
  char *ChPtr;
  UDWORD Attr;
  Attr = Unix2Attr(0x4000|0777);
  ChPtr=fpath;
  while(*ChPtr!=0)
  {
    if (IsPathDiv(*ChPtr))
    {
      *ChPtr=0;
      if (MakeDir(fpath,Attr)==0)
        mprintf(MCreatDir,fpath);
      *ChPtr=CPATHDIVIDER;
    }
    ChPtr++;
  }
}


void NextVolumeName(void)
{
  char *ChPtr;
  if ((ChPtr=strrchr(ArcName,'.'))==NULL)
  {
    strcat(ArcName,".rar");
    ChPtr=strrchr(ArcName,'.');
  }
  else
    if (ChPtr[1]==0 || stricomp(ChPtr+1,"exe")==0)
      strcpy(ChPtr+1,"rar");
  if (!isdigit(*(ChPtr+2)) || !isdigit(*(ChPtr+3)))
    strcpy(ChPtr+2,"00");
  else
  {
    ChPtr+=3;
    while ((++(*ChPtr))=='9'+1)
    {
      if (*(ChPtr-1)=='.')
      {
        *ChPtr='A';
        break;
      }
      else
      {
        *ChPtr='0';
        ChPtr--;
      }
    }
  }
}


int MergeArchive(int ShowFileName)
{
  tclose(ArcPtr);
  NextVolumeName();
  while ((ArcPtr=fopen(ArcName,READBINARY))==NULL)
  {
    if (NumArcDrive==-1 || !IsRemovable(NumArcDrive))
    {
      mprintf(MAbsNextVol,ArcName);
      return(0);
    }
    AskNextVol();
  }
  if (!IsArchive())
  {
    mprintf(MBadArc,ArcName);
    return(0);
  }
  if (MainCommand[0]=='T')
    mprintf(MTestVol,ArcName);
  else
    if (MainCommand[0]=='X' || MainCommand[0]=='E')
      mprintf(MExtrVol,ArcName);
  tseek(ArcPtr,NewMhd.HeadSize-MainHeadSize,SEEK_CUR);
  ReadBlock(FILE_HEAD);
  if (ShowFileName)
    mprintf(MExtrPoints,ArcFileName);
  UnpVolume=(NewLhd.Flags & LHD_SPLIT_AFTER);
  tseek(ArcPtr,NextBlockPos-NewLhd.PackSize,SEEK_SET);
  UnpPackedSize=NewLhd.PackSize;
  RdUnpPtr=ArcPtr;
  return(1);
}


void UnstoreFile(void)
{
  int Code;
  while (1)
  {
    if ((Code=UnpRead(UnpMemory,0x7f00))==-1)
      ErrExit(EREAD,FATAL_ERROR);
    if (Code==0)
      break;
    Code=(int)Min((long)Code,DestUnpSize);
    if (UnpWrite(UnpMemory,Code)==-1U)
      ErrExit(EWRITE,WRITE_ERROR);
    if (DestUnpSize>=0)
      DestUnpSize-=Code;
  }
}


void ConvertPath(char *OutPath, char *InPath)
{
  char TmpStr[NM],*OutPathPtr;
  if (InPath[0] && IsDriveDiv(InPath[1]))
    OutPathPtr=&InPath[2];
  else
    OutPathPtr=InPath;
  if (OutPathPtr[0]=='.' && OutPathPtr[1]==CPATHDIVIDER)
    OutPathPtr++;
  if (OutPathPtr[0]=='.' && OutPathPtr[1]=='.' && OutPathPtr[2]==CPATHDIVIDER)
    OutPathPtr+=2;
  if (*OutPathPtr==CPATHDIVIDER)
    OutPathPtr++;
  strcpy(TmpStr,OutPathPtr);
  strcpy(OutPath,TmpStr);
}


void AskNextVol(void)
{
  mprintf(MAskNextVol,ArcName);
  Ask(MContinueQuit);
  if (Choice==2)
    ErrExit(EEMPTY,USER_BREAK);
}

