/**********************************************************

			=== xicon ===
	
	-- Script execution via icon --
	
	version 1.2 -- 1998 Nov 7
	
	Original code sections Copyright 1997-8 Pete Goodeve
	
	Source may be freely redistributed and modified provided
	that credit is given.
	
	Oct 97: version 1 released
	May 98:	changes to shell argument passing to allow non-bash
			scripts.
			mime-types adjusted to agree with suggested standard
	Nov 98	Changes to comply with R4 conventions (still OK under R3).
			Specific required headers added to eliminate BeHeaders
			and allow compilation under gcc.
			(This source is suitable for both PPC and Intel)

**********************************************************/

//#include <stdio.h>


#include <string.h>

#include <Application.h>
#include <Path.h>

// Just in case... (should at least be defined by string.h):
#ifndef NULL
#define NULL 0
#endif


#ifdef DEBUGW
/// Please ignore this inactivated debug code.  I haven't
/// supplied the relevant header & object, but I don't want
/// to have two separate versions of the source to maintain...
	#include "debWindow.h"
	DebWindow * dW;	// GLOBAL!
	#define DPRINTF(str) dW->printf str
#else
	#define DPRINTF(str) 
#endif	//DEBUGW

#define OLD_SCRIPT_BGND_TYPE "text/x-sh-script"
#define SCRIPT_BGND_TYPE "text/x-script.xicon-bg"
#define SCRIPT_BASH_TYPE "text/x-script.xicon-sh"
// normal script with Terminal window should  normally be
//	simply 'text/x-script.xicon' (determined by 'Supported Types' attribute)
#define DIR_ENV "FOLDER_PATH="
#define TERMINAL_APP "/boot/beos/apps/Terminal"
#define SHELL_APP "/boot/beos/bin/sh"

// We allocate a fixed size array for the command line:
#define MAX_COMMAND_LENGTH 512


// The following section and 'LaunchTerminal' are borrowed
// liberally (if not quite verbatim) from Pierre Brua's
// 'TermHire' code.

char **new_environ(char **orig, char *new_var);

extern char **environ; // this is the global context of the shell

// this function creates the new environment
// which is a copy of the "orig" environment, 
// plus the environment variable defined in "new_var"
// I've simplified it from Pierre's version, because the
// added string stays around long enough (so I don't copy it).

char **new_environ(char **orig, char *new_var)
{
	int nb_lines=0;
	char **dest;
	
	while(orig[nb_lines]!=NULL) nb_lines++;
	dest = new char*[nb_lines+2];
	
	// we just need to copy the pointers, since there will be another copy
	// when the app will be launched...
	for(int i=0;i<nb_lines;i++)
		dest[i]=orig[i];
		
	// now the new one gets a pointer too	
	dest[nb_lines]=new_var;
	dest[nb_lines+1]=NULL;
	
	return dest;
}


//////////////////////////////////////////////////////////////

class ScriptApplication : public BApplication {
public:
	entry_ref scriptref;
	entry_ref argref;
	BPath * args;
	int32 nargs;
	ScriptApplication();
	~ScriptApplication();
	void RefsReceived(BMessage *msg);
	void ReadyToRun();
	void LaunchTerminal();
};


ScriptApplication::ScriptApplication()
		  		  : BApplication("application/x-xicon")
{
	args = NULL;
	nargs = 0;

	#ifdef DEBUGW
	// For debugging:	
	BRect aRect(20, 20, 500, 300);
	dW = new DebWindow(aRect, TRUE);
	dW->Show();
	#endif	//DEBUGW
}

ScriptApplication::~ScriptApplication()
{
	delete [] args;
}

void ScriptApplication::ReadyToRun()
{
	LaunchTerminal();
	Quit();	// Heh -- we did it all already... (:-))
}

/// A double-click, or drag&drop, on a script icon invokes the
/// app, and supplies a refs-received message to this function.
/// This has to handle some quirks of startup from the (R4)
/// tracker:
///
///		Under drag&drop, *two* RefsReceived messages will arrive.
///		The first contains the dropped arguments; the second has
///		the ref for the script itself.  (The 'item_to_launch' entry
///		of earlier Trackers no longer exists.)  If the script is
///		just double-clicked on, it is presented as (the only) 'refs'
///		item.
///
///		It is impossible to avoid traversing a link (if
///		this is what any of the icons concerned are): whether
///		the 'traverse' argument to SetTo is TRUE or FALSE, the
///		resulting BEntry always refers to the resolved path,
///		because the Tracker resolves the link before it is
///		passed on. (An enhanced API may be provided in a later
///		rev of the OS.)


void ScriptApplication::RefsReceived(BMessage *msg)
{
	DPRINTF(("Got Ref Mesg: %.4s\n",	&msg->what);)
	uint32 enttype;
	BEntry ent;
	BPath path;
	int32 refcount;
	msg->GetInfo("refs", &enttype, &refcount);
	if (!args)	// first refsreceived has args 	
	 args = new BPath[refcount];
	for (int i=0; i < refcount &&
		msg->FindRef("refs", i, &scriptref) == B_OK; i++) {
		if (ent.SetTo(&argref) == B_OK)
			ent.GetPath(&args[nargs++]);
			argref = scriptref;	// all except the last are used
		DPRINTF(("   argument name: %s\n", args[j-1].Path());)
	}
}


/// Start up a Terminal (or a windowless shell -- according to
/// the script type)
///
///	Be aware that a Terminal will close anyway immediately a
/// script finishes  If you want the output to remain visible,
/// you must end the script with something that demands
/// interaction (a 'read' statement is the simplest).
///
/// Also, although 'FOLDER_PATH' is set as in TermHire, the invoked
/// shell does not execute '.profile' (as it isn't "login" -- I didn't
/// want the welcome message).  If you want to execute the script in
/// its own directory, do "cd $FOLDER_PATH" within it.

void ScriptApplication::LaunchTerminal()
{
	char **environ2, path2[MAXPATHLEN + 13];
	char ** argv = NULL;
	BPath path;

	BEntry curdir, scriptent(&scriptref);
	if (scriptent.InitCheck() != B_OK) return;	// in case invoked directly
	scriptent.GetParent(&curdir);
	curdir.GetPath(&path);
	BNode scriptnode(&scriptref);
	;
	char script_type[32] = "";
	scriptnode.ReadAttr("BEOS:TYPE", 0, 0, script_type, 32);
	// useterm set TRUE if anything but the following:
	int useterm = strcmp(SCRIPT_BGND_TYPE, script_type)
					& strcmp(OLD_SCRIPT_BGND_TYPE, script_type);
	
	// now, it formats the new environment context,
	// containing the variable FOLDER_PATH
	strcpy(path2, DIR_ENV);
	strcat(path2, path.Path());
	// the "environ" variable is a string array that ends with a NULL
	// pointer and contains all the variables defined at boot time
	// in the environment
	environ2=new_environ(environ,path2);

	//// Build the array of arguments:
	char ** argp = argv = new char *[nargs + 8];
				// this is more than needed. ^^ in case we want to play
	//First comes the path to Terminal (unless we don't want it)
	if (useterm)
		*argp++ = TERMINAL_APP;
		
	// Now the path to the shell:
	*argp++ = SHELL_APP;
	DPRINTF(("argv[0] set to %s\n", argv[0]);)
	
	if (strcmp(SCRIPT_BASH_TYPE, script_type))	// all except bash-only
		*argp++ = "-c";	// needed to allow non-bash scripts
	char ** varstr = argp;	// convenient pointer for cleanup
	
	scriptent.GetPath(&path);
	DPRINTF(("script path is %s\n", path.Path());)
	
	// This version has two alernative mechanisms for passing
	// the script and its arguments to the shell:
	// The first passes the script and each arg as separate
	// items in the argv array; the second uses the "-c" option
	// of the shell, but then has to pass the whole command line
	// (script + args) as a single string, and use quotes to
	// enclose each arg...
	if (strcmp(SCRIPT_BASH_TYPE, script_type) == 0) {
	// This method doesn't allow non-shell scripts (e.g. Python)
		// The first argument to the shell is the script itself:
		*argp = new char[strlen(path.Path()) + 1];
		strcpy(*argp++, path.Path());
		DPRINTF(("base args set, adding %d script args\n", nargs);)

		// Then the arguments (if any) to the script:
		for (int i=0; i < nargs; i++) {
			DPRINTF(("setting arg '%s'\n", args[i].Path());)
			*argp = new char[strlen(args[i].Path()) + 1];
			strcpy(*argp++, args[i].Path());
		}
	}
	else {
	  	// This approach works with all scripts using "#!..."
  		// but can't have quotes in a filename! (and has length limit)
  		// [I mean quote-characters as a *part* of the name -- not enclosing quotes!]
		char * argmrk = new char[MAX_COMMAND_LENGTH+1];
		*argp++ = argmrk;
		// The first argument in the string is the script itself:
		strcpy(argmrk, "\"");
		strcat(argmrk, path.Path());
		strcat(argmrk, "\"");
		DPRINTF(("base args set, adding %d script args\n", nargs);)
		int remaining = MAX_COMMAND_LENGTH - strlen(argmrk) - 4;
									// allows space for quotes ^^
		for (int i=0; i < nargs; i++) {
			if (strlen(args[i].Path()) > remaining) break;
			strcat(argmrk, " \"");
			DPRINTF(("setting arg '%s'\n", args[i].Path());)
			strcat(argmrk, args[i].Path());
			strcat(argmrk, "\"");
			remaining = MAX_COMMAND_LENGTH - strlen(argmrk) - 4;
		}
	}

	*argp = NULL;
	int argc = argp - argv;	
	
	#ifdef DEBUGW
	for (argp = argv; *argp; argp++)
		DPRINTF((" ARG %s\n", *argp);)
	#endif
	
	// we launch the new Terminal/shell in a separate thread
	DPRINTF(("launching Terminal with argc = %d\n", argc);)
	thread_id tid = load_image(argc, argv, environ2);
	if (tid > 0)
	{
		// the launch was successful, now run the thread
		resume_thread(tid);
	}
	
	DPRINTF(("deleting arg list\n");)
	while (*varstr) {
		delete [] *varstr++;
	}
	delete [] argv;
	delete [] environ2;	// (we don't delete the members here
}


////////////////////////////////////////////////////////

main()
{	
	ScriptApplication *myApplication;

	myApplication = new ScriptApplication();
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

