//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “Yate.h”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	This file houses the high-level BApplication class.
	Also contains several glue functions and manages
	the YateWindows to prevent DeadLocks.
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef YATE_H
	#define YATE_H

	#define Y_CLOSE_WIN_REQ     0x14704

	#define Y_CHANGE_BUFF       0x15f90
	#define Y_CHANGE_CURSOR     0x15f92
	#define Y_CREATOR           0x15f97
	#define Y_NAME_CHANGE  0x15f9b
	#define Y_CHECK_TITLE   0x15f9c
	#define Y_QUIT_NOW      0x15f9d

	#define REDRAW              0x17f90
	#define SAVE_FILE           0x17f91
	#define SAVE_AS_FILE        0x17f92
	#define MY_SAVE_FILE        0x17f93

	#define Y_GOTO_LINE         0x22113
	#define S_GOTO_LINEX        0x22115
	#define S_GOTO_LINEY        0x22116
	#define S_GOTO_PLACE        0x22117
	#define S_FIND_STRING        0x22118
	#define S_RESET_FOCUS     0x22119

	#define Y_SMOOTH_SCROLL     0x25100
	#define Y_SYNTAX_STYLING    0x25101
	#define Y_UTF8              0x25102
	#define Y_TERM              0x25103

	/*Icky!!*/
	#define Y_CHANGE_BACKSTYLE    0x26100
	#define Y_CHANGE_DIR        0x26110
	#define Y_CHANGE_VIEW        0x26114
	#define Y_CHANGE_ENCODING       0x26115

	#define Y_DEBUG             0x26111

	#define Y_HSCROLL_ON        0x26220
	#define Y_VSCROLL_ON        0x26221
	#define Y_MESSAGES_ON        0x26222
	#define Y_SYSFONT_CHANGE 0x26223

	class BFont;
	extern BFont *be_plain_font2;
	extern BFont *be_bold_font2;
	extern BFont *be_fixed_font2;

	extern void DoMsg(class YateWindow*,const char *message,int32 value=0);

	#if DEBBUILD
		#define DEBUG 1
	#endif
	#include <Debug.h>

	#define Own (ASSERT(LockingThread()==find_thread(NULL)))


#endif // YATE_H

