//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “Yate.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	The fabled YateWindow class in all its Glory.
*/
//====//====//====//====//====//====//====//====//====//====//

//#define NEXTPREV_IN_WINDOW_MENU

#include <Menu.h>

#include "Utils.h"
#include "Yate.h"
#include "UBuffer.h"
#include "BMapView.h"
#include "YateWindow.h"
#include "Hash.h"
#include "Schemes.h"
#include "BSBar.h"
#include "ViewBase.h" //grrrrrrr
#include "FFont.h" //thanks Diane!
#include "BufList.h"

#include <MenuBar.h>
#include <MenuItem.h>
#include <Application.h>
#include <Screen.h>
#include <Beep.h>
#include <Directory.h>

#include <stdio.h>
#include <stdlib.h>  //atol for gotoline
#include <string.h>
#include <malloc.h>
#include <Autolock.h>
#include <time.h>

struct MenIt{
	char *name;
	int32 msg;
};

long MyDraw(void*);//thread callable;
long MyDraw(void *dummy){
	BMapView *vv=(BMapView *)dummy;
	return vv->DrawThread();
}

YateWindow::YateWindow(BRect frame,Buff *bb):
BWindow(frame,"Yate",B_DOCUMENT_WINDOW,B_NAVIGABLE)
{
	SetPulseRate(0.0);
	static int32 cnt=1;wincnt=atomic_add(&cnt,1);

	IsHScroll=FALSE;
	IsMsg=TRUE;

	cb=NULL;
	fname=fstyle=fsize=NULL;
	mback=mdir=mwin=NULL;
	mdoc=medit1=medit2=mdoclist=NULL;
	mmime=mcurs=NULL;
	iback=icurs=ifname=ifstyle=ifsize=idir=imime=NULL;

	char tempname[128];
	sprintf(tempname,"#%d DrawPort",wincnt);
	drprt=create_port(32,tempname);

	mnxt=mprv=NULL;

	topmenu=new BMenuBar(BRect(0,0,frame.Width(),14),"TopMenu",
		B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,B_ITEMS_IN_ROW,TRUE);

	CreateMenus(topmenu);
	AddChild(topmenu);

	MyMetrics();
	scbv=new BSBar(rsbv,"ScrV",drprt,0,100,B_VERTICAL);
	scbh=new BSBar(rsbh,"ScrH",drprt,0,600,B_HORIZONTAL);

	myview = new BMapView(this,bb,rmyview,"YATE:BMView",scbv,scbh,drprt);
	mycurs=((wincnt-1)&3)*4+140;
	myview->ChangeCursor(mycurs);

	sview=new StatusView(rssv,"StView",drprt);
	sview->SetSearch("Search String");
	sview->SetReplace("Replace String");

	ChangeBuff(bb);

	AddChild(myview);
	AddChild(sview);
	AddChild(scbv);

	FixDisp();
	myview->MakeFocus();

	sprintf(tempname,"#%d Renderer",wincnt);
	drth=spawn_thread(MyDraw,tempname,B_DISPLAY_PRIORITY,myview);
	if (drth>0){resume_thread(drth);}else{drth=0;}
	SetPulseRate(500000.0);
}

YateWindow::~YateWindow(){
	if (drprt){
		delete_port(drprt);
		drprt=0;
	}
	if (drth){
		long    temp;
		wait_for_thread(drth,&temp);
		drth=0;
	}
}

void YateWindow::MyMetrics(){
	font_height temp;
	be_plain_font2->GetHeight(&temp);
	float   sh=ceil(temp.ascent+9.0);

	float mbh=topmenu->Bounds().Height();

	BRect frame=Bounds();

	float bx=frame.Width()-B_V_SCROLL_BAR_WIDTH;
	float by=frame.Height();
	if (IsHScroll){
		by-=B_H_SCROLL_BAR_HEIGHT;
	}
	if (IsMsg){
		sh*=2.0;
	}

	rmyview=BRect(0.0,mbh+1.0,bx,by-sh);
	rsbv=BRect(bx+1.0,mbh+1.0,frame.Width()+1.0,frame.Height()-B_H_SCROLL_BAR_HEIGHT);
	rsbh=BRect(0,by+1.0,bx,frame.Height()+1.0);
	rssv=BRect(0,by+1.0-sh,bx,by);

	SetSizeLimits(240,30000,mbh*2.0+2.0*sh,30000);
}

void YateWindow::Shove(BView *src,BRect dest){
	src->MoveTo(dest.left,dest.top);
	src->ResizeTo(dest.Width(),dest.Height());
}

void YateWindow::FixDisp(){
	Shove(myview,rmyview);
	Shove(scbh,rsbh);
	sview->RemoveChild(sview->mrv);
	Shove(sview,rssv);
	if (IsMsg)sview->AddChild(sview->mrv);
	RemoveChild(scbh);
	if (IsHScroll)AddChild(scbh);
}

#define LEFT_ARROW "\034"
#define RIGHT_ARROW "\035"
#define TAB "\011"

	MenIt DocumentMenu[]={"Document",0,
								"\0New Doc",A_NEW_BUFFER,
								"O\342\200\234Open\342\200\235 FilePanel\342\200\246",A_OPEN_PANEL,
								".Open ‘Suffix’",A_OPEN_SUFFIX,
								"IOpen Selection",A_OPEN_SELECTION,
								"\1\1",0,
								"\0Save Changed Docs",A_SAVE_CHANGED,
								"\0Save All Docs",A_SAVE_ALL,
								"SSave Current",SAVE_FILE,
								"S\2Save Current As…",SAVE_AS_FILE,
								"\1\1",0,
								"R\2Revert Current",A_REVERT_BUFFER,
								"D\2Discard Current",A_DISCARD_BUFFER,
								"\1\1",0,
								"\6MIME Type",0,
								"\0Shell Mode",Y_TERM,
//                              "\0UTF-8 Encoding",Y_UTF8,
								"\1\1",0,
								"B\2Browse…",A_BROWSE,
								"L\2Launch…",A_LAUNCH,
								"T\2TermHire…",A_TERMHERE,
								"\1\1",0,
								"\0About YATE…",B_ABOUT_REQUESTED,
#if DEBBUILD
//                                "\0Debug (will crash!)",Y_DEBUG,
#endif
								"\0\0",0};

	MenIt   MimeMenu[]={"Mime Type",0,
								"\0None",Y_CREATOR,
								"\0YateText",Y_CREATOR,
								"\0Text File",Y_CREATOR,
								"\0HTML",Y_CREATOR,
								"\0EMail (!)",Y_CREATOR,
								"\0Source Code",Y_CREATOR,
								"\0\0",0};

	MenIt DirMenu[]={"Direction",0,
								RIGHT_ARROW"\2Normal",Y_CHANGE_DIR,
								"\037\2Down",Y_CHANGE_DIR,
								"\036\2Up",Y_CHANGE_DIR,
								"\0Left",Y_CHANGE_DIR,
								LEFT_ARROW"\2None",Y_CHANGE_DIR,
								"\0\0",0};

	MenIt ViewMenu[]={"View As",0,
								"\0Hex Dump",Y_CHANGE_VIEW,
								"\0Vanilla ASCII",Y_CHANGE_VIEW,
								"\0C++ Text",Y_CHANGE_VIEW,
								"\0HTML",Y_CHANGE_VIEW,
								"\0\0",0};

	MenIt EncMenu[]={"Encoding",0,
								"\0Hex",Y_CHANGE_ENCODING,
								"\0BeOS/Unix" ,Y_CHANGE_ENCODING,
								"\0Dos/Windows",Y_CHANGE_ENCODING,
								"\0\0",0};


	MenIt MoreEditMenu[]={"More",0,
								"FFind Dialog",A_FIND_DIALOG,
								"DFind Forward (F3)",A_FIND_FORWARD,
								"D\1Find Backward",A_FIND_BACK,
								"HFind Selection",A_ENTER_FIND_STRING,
								"JReplace This",A_REPLACE_THIS,
								",Goto Line",Y_GOTO_LINE,
								"\1\1",0,
								"\0Next Error (F4)",A_NEXT_ERROR,
								"\0Reset Error List",A_RESET_ERROR,
								"\1\1",0,
//                              "\0Word-Wrap Now",A_WORDWRAP_NOW,
								//"\1\1",0,
								"MMake",A_MAKE,
								"RMake Run",A_MAKE_RUN,
								"\1\1",0,
								"\5Dir",0,
								"\0\0",0
								};

	MenIt EditMenu[]={"Edit",0,
								"ZUndo",A_UNDO,
//                              "Z\1Redo",A_REDO,
								"XCut",B_CUT,
								"CCopy",B_COPY,
								"VPaste",B_PASTE,
								"KKill",A_KILL_SELECTION,
								"\1\1",0,
								"ASelect All",B_SELECT_ALL,
								"A\1Deselect All",A_SELECT_NONE,
								"\1\1",0,
								"]Indent",A_INDENT,
								"[Undent",A_UNDENT,
								"]\1Quote",A_QUOTE,
								"[\1Unquote",A_UNQUOTE,
								"\0\0",0};

	MenIt CursorMenu[]={"Colored Cursor",0,
								"\0Black",Y_CHANGE_CURSOR,
								"\0Red",Y_CHANGE_CURSOR,
								"\0Green",Y_CHANGE_CURSOR,
								"\0Blue",Y_CHANGE_CURSOR,
								"\0\0",0};

	MenIt BackMenu[]={"Background",0,
								"\0Dark",Y_CHANGE_BACKSTYLE,
								"\0Light",Y_CHANGE_BACKSTYLE,
								"\0Dull",Y_CHANGE_BACKSTYLE,
								"\0\0",0};


	MenIt WinMenu[]={"Window",0,
								"\10Font Name",0,
								"\11Font Style",0,
								"\12Font Size",0,
								"\4Colors",0,
								"\7Cursors..",0,
								"\13View As..",0,
								"\14Encoding..",0,
								"\1\1",0,
/*
								"YFold All",A_FOLD_ALL,
								"UUnFold All",A_UNFOLD_ALL,
								RIGHT_ARROW"Fold",A_UNFOLD,
								LEFT_ARROW"Un-Fold",A_FOLD,
								"\1\1",0,
*/
								"\0Smooth Scrolling",Y_SMOOTH_SCROLL,
								"\0Messages",Y_MESSAGES_ON,
								"\0Scroll Bar",Y_HSCROLL_ON,
//                                "\0Experimental",A_EXPERIMENTAL,
								"\1\1",0,
								"GSwitch Window…",A_NEXT_WINDOW,
								"NNew Window…",A_NEW_WINDOW,
								"WClose Window",B_QUIT_REQUESTED,
								"\0\0",0};

void YateWindow::Fumble(BMenu *top,BMenuItem **mi,BMenu **mn,MenIt *mit){
	if (mit){
		*mn=MenuFrom(mit);
	}else{
		*mn=new BMenu("HAHA :-)",B_ITEMS_IN_COLUMN);
	}

	*mi=new BMenuItem(*mn);
	top->AddItem(*mi);

}

BMenu *YateWindow::MenuFrom(MenIt *mi){
	int cc=0;

	BMenu *mtm=new BMenu(mi->name,B_ITEMS_IN_COLUMN);
	mi++;
	while (1){
		BMenu   *sub=NULL;
		char *ct=mi->name;
		if (ct==NULL || ct[1]==0) break;
		switch(ct[0]){
			case 1:
				mtm->AddSeparatorItem();
				break;
			case 4:Fumble(mtm,&iback,&mback,BackMenu);break;
			case 5:Fumble(mtm,&idir,&mdir,DirMenu);break;
			case 6:Fumble(mtm,&imime,&mmime,MimeMenu);break;
			case 7:Fumble(mtm,&icurs,&mcurs,CursorMenu);break;
			case 8:Fumble(mtm,&ifname,&fname,NULL);break;
			case 9:Fumble(mtm,&ifstyle,&fstyle,NULL);break;
			case 10:Fumble(mtm,&ifsize,&fsize,NULL);break;
			case 11:Fumble(mtm,&iview,&mview,ViewMenu);break;
			case 12:Fumble(mtm,&iview,&menc,EncMenu);break;
			default:
				{
					BMessage *mg=new BMessage(mi->msg);
					mg->AddInt32("Option",cc++);
					int vv=ct[0],mod=0;
					char *dst=ct+1;
					if  (ct[1]==1){mod=B_SHIFT_KEY;dst++;}
					if  (ct[1]==2){mod=B_OPTION_KEY;dst++;}
					BMenuItem *mm=new BMenuItem(dst,mg,vv,mod);
					mtm->AddItem(mm);
				}
				break;
		}
		if (sub){
			mtm->AddItem(sub);
		}
		mi++;
	}
	return mtm;
}

void YateWindow::CreateMenus(BMenu *mbar){

	mbar->AddItem(mdoc=MenuFrom(DocumentMenu));
	mbar->AddItem(medit1=MenuFrom(EditMenu));
	mbar->AddItem(medit2=MenuFrom(MoreEditMenu));
	mbar->AddItem(mdoclist=new BMenu("Doc List",B_ITEMS_IN_COLUMN));
	mbar->AddItem(mwin=MenuFrom(WinMenu));

	mnxt=new BMenuItem("Next Document",new BMessage(A_NEXT_BUFF),'=',0);
	mprv=new BMenuItem("Previous Document",new BMessage(A_PREV_BUFF),'-',0);

	#if NEXTPREV_IN_WINDOW_MENU
		mwin->AddSeparatorItem();
		mwin->AddItem(mnxt);mnxt=NULL;
		mwin->AddItem(mprv);mprv=NULL;
	#endif
}

void YateWindow::MoveCurs(int cx,int cy){
//    if (cb->utf8){
//        char *nu=cb->GetLine(cy);
//        cx=UTFWidth(nu,cx);
//    }
	sview->SetPos(cx,cy);
}


long YateWindow::KeyDown(BMessage *msg){//dont' forget shift-insert, shift-del
	int32   mod,raw,key;
	char    *str;
	msg->FindInt32("modifiers",&mod);
	msg->FindInt32("key",&key);
	msg->FindInt32("raw_char",&raw);
	msg->FindString("bytes",(const char**)&str);

	if (raw>255){
		int32   event=0;
		switch(raw){
			case 260:event=B_CUT;break;
			case 261:event=B_COPY;break;
			case 262:event=B_PASTE;break;
			case 263:event=A_KILL_SELECTION;break;
			case 271:event=A_FIND_FORWARD;break;
			case 272:event=A_ENTER_FIND_STRING;break;
			case 280:event=SAVE_FILE;break;
			case 282:event=A_PREV_BUFF;break;
			case 283:event=A_NEXT_BUFF;break;
			case 284:event=A_WINDOW_TO_FRONT;break;
			case 285:event=A_MAKE;break;
			case 286:event=A_MAKE_RUN;break;
		}
		if (event){
			if (event!=1)PostMessage(event);
			return 0;
		}
	}

	myview->KeyDown(str,strlen(str));    // for yak..
	return 0;
}


void YateWindow::GotoLine(BMessage *msg){
	char *ss=NULL;
	status_t rr=msg->FindString("Data",(const char**)&ss);
	if (rr!=B_NO_ERROR)return;

	long ll=atol(ss);
	if (ll>=0){
		if (msg->what!=S_GOTO_LINEX){
			if (ll){
				BMessage ms(A_GOTO_LINEY);
				ms.AddInt32("Pos",ll);
				ms.AddPointer("YWin",this);

				cb->PostMessage(&ms);
//                cb->MoveTo(mycurs,cx,ll-1);
//              myview->MyScrollTo(0,((2*ll-1)*myview->fh-myview->Bounds().Height())/2);
			}
		}else{
/*
			if (cb->utf8){
				char *nu=cb->GetLine(cy);
				ll=WidthUTF(nu,ll);
			}
*/
//            cb->MoveTo(mycurs,ll,cy);
		}
		myview->MakeFocus();
	}
}




void YateWindow::ChangeBuff(Buff *bb){
	if (!bb) return;
	Own;

	if (cb){
		cb->DeRegister(myview->ws);
		cb=NULL;
	}

	cb=bb;
//    CheckTitle();
	int32 tn=cb->Register(myview->ws);
	if (myview){
		myview->ChangeBuff(bb);
		myview->targetnum=tn;
	}

	if (drprt) write_port(drprt,SCROLL,&bb,0);
}



	/*
	void YateWindow::ChangeFont(BMessage *msg){
		printf("Bad biscuit\n");
		status_t    rr;
		font_family     *fam1=NULL,fam2;
		font_style  mystyle,sty2,*sty1=NULL;

		float   oldh,oldv;
		oldh=myview->scbh->Value();
		oldv=myview->scbv->Value()/myview->fh;

		myview->myfont.GetFamilyAndStyle(&fam2,&sty2);

		rr=msg->FindString("FamilyName",(char**)&fam1);
		rr=msg->FindString("StyleName",(char**)&sty1);

		//    printf("stylie %x(%s,%s,%s,%s)\n",sty1,fam1,fam2,sty1,sty2);
		if (!fam1)fam1=&fam2;

		if (!sty1){
			sty1=&sty2;
			int mx=count_font_styles(*fam1);
			uint32   flags;
			int i=mx-1;
			while (i>=0){
				get_font_style(*fam1,i,&mystyle,&flags);
				if (strcmp(mystyle,*sty1)==0)break;
				i--;
			}
			if (i<0){sty1=&mystyle;}
		}
		myview->myfont.SetFamilyAndStyle(*fam1,*sty1);

		float myf=msg->FindFloat("Size");
		if (myf&&myf>2&&myf<=100.0){
			myview->myfont.SetSize(myf);
		}

		myview->FrameResized(0,0);
		myview->FlickTo(oldh,oldv*myview->fh);
		myview->FollowCursor();
		myview->Invalidate(myview->Bounds());
		DoMenuFontName();
		DoMenuFontSize();
	}
	*/


void YateWindow::HandleFontDrop(BMessage *msg){
//    msg->PrintToStream();
	BFont nufont=myview->myfont;
	FindMessageFont(msg,"font",0,&nufont);
	if (nufont==myview->myfont) return;

	double   oldh,oldv;
	oldh=myview->scbh->Value();
	oldv=myview->scbv->Value()/myview->fh;
	myview->myfont=nufont;
	myview->FrameResized(0,0);
	myview->FlickTo(oldh,oldv*myview->fh);
	myview->Invalidate(myview->Bounds());
	DoMenuFontName();
	DoMenuFontSize();
}


void YateWindow::MessageReceived(BMessage *msg){
	long            tt;
	void            *vv=NULL;
	Buff            *bb=NULL;

	YAction res=A_NOTHING;

	switch (msg->what){
		case B_SIMPLE_DATA:
		case A_PREV_WINDOW:
		case A_NEXT_WINDOW:
		case A_NEW_WINDOW:
		case A_OPEN_PANEL:
			msg->AddPointer("YWin",this);
			msg->AddPointer("Buff",cb);
			be_app->PostMessage(msg);
			break;
		case B_ABOUT_REQUESTED:
			sview->ShowMsg("About YATE");
			be_app->PostMessage(msg);
			break;
		case A_MAKE:
			sview->ShowMsg("Making…");
			msg->AddPointer("YWin",this);
			msg->AddPointer("Buff",cb);
			be_app->PostMessage(msg);
			break;
		case A_MAKE_RUN:
			sview->ShowMsg("Running…");
			msg->AddPointer("YWin",this);
			msg->AddPointer("Buff",cb);
			be_app->PostMessage(msg);
			break;
		case A_DISCARD_BUFFER:
		case A_SAVE_CHANGED:
		case A_SAVE_ALL:
		case A_NEXT_BUFF:
		case A_PREV_BUFF:
		case A_NEW_BUFFER:
		case A_OPEN_SUFFIX:
		case A_NEXT_ERROR:
		case A_RESET_ERROR:
		case A_OPEN_SELECTION:
		case Y_CHANGE_BUFF:
			msg->AddPointer("Buff",cb);
			msg->AddPointer("YWin",this);
			be_app->PostMessage(msg);
			break;
		case Y_SMOOTH_SCROLL:myview->sscroll=!myview->sscroll;break;
		case A_WINDOW_TO_FRONT:Activate(TRUE);break;
		case A_WINDOW_TO_BACK:Activate(FALSE);break;
		case A_WINDOW_ZOOM:Zoom();break;
		case Y_CHANGE_DIR:
			msg->FindInt32("Option",&tt);
			myview->ws->typedir=tt;
			ChangeBuff(cb);
			break;
		case Y_CHANGE_VIEW:
			msg->FindInt32("Option",&tt);
			myview->ws->vmode=tt;
			myview->vb->vmode=tt;
			myview->FrameResized(0,0);
			ChangeBuff(cb);
			myview->Invalidate(myview->Bounds());
			break;
		case Y_CHANGE_ENCODING:
			msg->FindInt32("Option",&tt);
			cb->encoding=tt;
/*
			myview->ws->vmode=tt;
			myview->vb->vmode=tt;
*/
			myview->FrameResized(0,0);
			ChangeBuff(cb);
			myview->Invalidate(myview->Bounds());

			break;
	  case A_FIND_DIALOG:
			sview->srv->MakeFocus();
			sview->srv->SelectAll();
			break;

		case B_KEY_DOWN+1:KeyDown(msg);break;//from Yak
		case Y_GOTO_LINE:
			sview->yrv->MakeFocus();
			sview->yrv->SelectAll();
			break;
		case Y_MESSAGES_ON:
			IsMsg=!IsMsg;
			MyMetrics();
			FixDisp();
			break;
		case Y_HSCROLL_ON:
			IsHScroll=!IsHScroll;
			MyMetrics();
			FixDisp();
			if (IsHScroll){
				sview->ShowMsg("ScrollBar Enabled");
			}else{
				sview->ShowMsg("ScrollBar Disabled");
			}
			break;
		case Y_SYSFONT_CHANGE:
			sview->xrv->SetFontAndColor(be_plain_font2);
			sview->yrv->SetFontAndColor(be_plain_font2);
			sview->srv->SetFontAndColor(be_plain_font2);
			sview->rrv->SetFontAndColor(be_plain_font2);
			MyMetrics();
			FixDisp();
			sview->ShowMsg("System Fonts Changed");
			break;
		case A_SHOW_MSG:
			{
				char *t=NULL;
				msg->FindString("Text",(const char **)&t);
				sview->ShowMsg(t);
				break;
			}
		case S_FIND_STRING:
			{
				char *t=NULL;
				msg->FindString("Text",(const char**)&t);
				if (t) sview->SetSearch(t);
				break;
			}
		case S_RESET_FOCUS:
			myview->MakeFocus();
			{
				int32 ll=-1;
				msg->FindInt32("Pos",&ll);
				if (ll>-1){
					myview->CleanScrollers();
					myview->MyScrollTo(ll);
				}
			}
			break;
		case S_GOTO_LINEX:
		case S_GOTO_LINEY:
			GotoLine(msg);
			break;
		case S_GOTO_PLACE:
			{
				Buff *nb=NULL;
				msg->FindPointer("Buff",(void**)&nb);
	//                printf("goto %x\n",nb);
				if (nb){ChangeBuff(nb);}
			}
			GotoLine(msg);
			break;

		case Y_CHANGE_CURSOR:
			msg->FindInt32("Option",&tt);
			tt=BND(tt,0,3);
			mycurs=tt*4+140;
			{
				BAutolock l1(cb);
				myview->ChangeCursor(tt);
				cb->Register(myview->ws);
			}
			{
				char sha[256],*spa=sha;
				switch(tt){
					case 0:spa+=sprintf(spa,"Black");break;
					case 1:spa+=sprintf(spa,"Red");break;
					case 2:spa+=sprintf(spa,"Green");break;
					case 3:spa+=sprintf(spa,"Blue");break;
				}
				sprintf(spa," Cursor");
				sview->ShowMsg(spa);
			}
			break;
		case Y_CHANGE_BACKSTYLE:
			tt=msg->FindInt32("Option");
			if (tt<0)tt=0;
			if (tt>2)tt=2;
			myview->vb->csh=schemetab[tt];
			myview->Invalidate(myview->Bounds());
			break;
		case '!FNT':
			HandleFontDrop(msg);
			break;
/*
		case A_SCROLL_TOP:myview->MyScrollTo(myview->tax,0);break;
		case A_SCROLL_BOTTOM:MyScrollTo(tax,1e30);break;
		case A_SCROLL_UP:MyScrollTo(tax,tay-ws->pgdn*fh);break;
		case A_SCROLL_DOWN:MyScrollTo(tax,tay+ws->pgdn*fh);break;
*/


		case A_REPLACE_THIS:
			msg->AddPointer("YWin",this);
			msg->AddString("Text",sview->rrv->Text());
			cb->PostMessage(msg);
			break;
		case A_FIND_BACK:
		case A_FIND_FORWARD:
			if (!sview->srv->Text()[0]){
				myview->MakeFocus();
				sview->ShowMsg("Find Cancelled");
			}else{
				msg->AddPointer("YWin",this);
				msg->AddString("Text",sview->srv->Text());
				cb->PostMessage(msg);
			}
			break;
		case B_MODIFIERS_CHANGED:break;
		case B_CUT:
		case B_COPY:
		case B_PASTE:
			{
				BView *tg=CurrentFocus();
				if (tg==myview){
					msg->AddPointer("YWin",this);
					cb->PostMessage(msg);
				}else{
					BTextView *tgt=(BTextView*)tg;
					BClipboard *cl=be_clipboard;
					if (msg->what==B_CUT)tgt->Cut(cl);
					if (msg->what==B_COPY)tgt->Copy(cl);
					if (msg->what==B_PASTE)tgt->Paste(cl);
				}
			}
			break;

		case Y_TERM:
		case A_UNDO:
		case A_REDO:
		case A_KILL_SELECTION:
		case B_SELECT_ALL:
		case A_SELECT_NONE:
		case A_BROWSE:
		case A_LAUNCH:
		case A_TERMHERE:
		case Y_CREATOR:
		case A_INDENT:
		case A_UNDENT:
		case A_QUOTE:
		case A_UNQUOTE:
		case A_ENTER_FIND_STRING:
		case A_REVERT_BUFFER:
		case SAVE_FILE:
		case SAVE_AS_FILE:
			msg->AddPointer("YWin",this);
			cb->PostMessage(msg);
			break;

		case B_UNMAPPED_KEY_UP:
		case B_UNMAPPED_KEY_DOWN:
			BWindow::MessageReceived(msg);
			break;

		default:
//          msg->AddPointer("YWin",this);
//          cb->PostMessage(msg);
			#if defined(_DebugObj)
				printf("unknown message in YateWindow:\n");
				msg->PrintToStream();
			#endif
			BWindow::MessageReceived(msg);
			break;
	}
}


bool YateWindow::QuitRequested()
{
	BMessage    msg(Y_CLOSE_WIN_REQ);
	msg.AddPointer("YWin",this);
	be_app->PostMessage(&msg);
	return FALSE;
}


void ProcTitle(char *src,BMenuItem *hit,BMenuItem *top,bool set);
void ProcTitle(char *src,BMenuItem *hit,BMenuItem *top,bool set){
	if (hit){
		hit->SetMarked(set);
		if (top && set){
			char sometext[128];
			sprintf(sometext,src,hit->Label());
			top->SetLabel(sometext);
		}
	}
}


void YateWindow::DoMenuFontName(){
	if (!fname || !fstyle) return;
	int32 idx,nft;
	uint32  flags;

	BFont nufont=myview->myfont;

	font_family curfam;
	font_style cursty;
	nufont.GetFamilyAndStyle(&curfam,&cursty);
	nft=count_font_families();
	for (idx=0;idx<nft;idx++){

		font_family myfam;
		font_style mysty,*deststy=&mysty;
		get_font_family(idx,&myfam,&flags);
		int mx=count_font_styles(myfam);
		while (--mx>=0){
			get_font_style(myfam,mx,&mysty,&flags);
			if (strcmp(mysty,cursty)==0)  break;
		}

		BMenuItem *it=(BMenuItem*)fnl.ItemAt(idx);
		if (!it){
			it=new BMenuItem("",new BMessage('!FNT'),0);
			fnl.AddItem(it);
			fname->AddItem(it);
		}
		it->SetLabel(myfam);
		BMessage *msg=it->Message();
		msg->MakeEmpty();
		nufont.SetFamilyAndStyle(myfam,mysty);
		FFont ff(nufont);
		ff.SetMask(B_FONT_FAMILY_AND_STYLE);
		AddMessageFont(msg,"font",&ff);
		ProcTitle("%s Font",it,ifname,strcmp(curfam,myfam)==0);
	}

	nft=count_font_styles(curfam);
	for (idx=0;idx<nft;idx++){
		font_style    mysty;
		get_font_style(curfam,idx,&mysty,&flags);
		BMenuItem *it=(BMenuItem*)fsl.ItemAt(idx);
		if (!it){
			it=new BMenuItem("",new BMessage('!FNT'),0);
			fsl.AddItem(it);
		}
		it->SetLabel(mysty);
		if (fstyle->IndexOf(it)<0){fstyle->AddItem(it);}
		BMessage *msg=it->Message();
		msg->MakeEmpty();
		nufont.SetFamilyAndStyle(curfam,mysty);
		FFont ff(nufont);
		ff.SetMask(B_FONT_FAMILY_AND_STYLE);
		AddMessageFont(msg,"font",&ff);
		ProcTitle("%s Style",it,ifstyle,strcmp(cursty,mysty)==0);
	}

	while (1){
		BMenuItem *it=(BMenuItem*)fsl.ItemAt(idx);
		if (!it)break;
		fstyle->RemoveItem(it);
		idx++;
	}
}

void YateWindow::DoMenuFontSize(){
	if (!fsize) return;
	float myf=myview->myfont.Size();
	float fss[50],temp;
	float dff[]={6,8,10,12,15,20,24,30,50,0};
	int idx;

	if (ifsize){
		char sometext[32];
		sprintf(sometext,"%1.1f Size",myf);
		ifsize->SetLabel(sometext);
	}

	idx=-1;
	while (dff[++idx]!=0){
		fss[idx]=dff[idx];
	}
	for (int diff=-4;diff<=4;diff++){
		fss[idx++]=myf+diff;
	}
	fss[idx++]=myf*2;
	fss[idx++]=myf/2;
	fss[idx++]=myf*3;
	fss[idx++]=myf/3;
	fss[idx++]=myf+10;
	fss[idx++]=myf-10;
	int max=idx;

	int safe=TRUE;
	while (safe){
		safe=FALSE;
		idx=0;
		for (int i=0;i<max-1;i++){
			fss[i]=floor(fss[i]+0.5);
			if (fss[i]<4.0)fss[i]=4.0;
			if (fss[i]>100.0)fss[i]=100.0;
			if (fss[i]==fss[i+1]){
				fss[i]=fss[max-1];
				max--;
			}
			if (fss[i]>fss[i+1]){
				temp=fss[i+1];
				fss[i+1]=fss[i];
				fss[i]=temp;
				safe=TRUE;
			}
		}
	}
	fss[max]=0.0;

	BFont nufont=myview->myfont;
	for (idx=0;idx<max;idx++){
		BMenuItem *it=fsize->ItemAt(idx);
		if (!it){
			fsize->AddItem(it=new BMenuItem("",new BMessage('!FNT'),0,0));
		}
		{
			char    mystr[8];
			sprintf(mystr,"%d",(int)fss[idx]);
			it->SetLabel(mystr);
		}

		BMessage *msg=it->Message();
		msg->MakeEmpty();
		nufont.SetSize(fss[idx]);
		FFont ff(nufont);
		ff.SetMask(B_FONT_SIZE);
		AddMessageFont(msg,"font",&ff);
		it->SetMarked(fss[idx]==myf);
	}
	while (fsize->ItemAt(idx)){
		fsize->RemoveItem(idx);
	}
}

extern char *doctxt;

void YateWindow::DoDocList(){
	while (mdoclist->RemoveItem(0L)){};
//	return;
	BAutolock l1(gb);
	for (int32 idx=0;idx<gb->Count();idx++){
		BMenuItem   *it=mdoclist->ItemAt(idx);
		if (it==NULL){
			it=new BMenuItem("",NULL,0);
			bmen.AddItem(it);
			it->SetMessage(new BMessage(Y_CHANGE_BUFF));
			if (idx<10){
				it->SetShortcut(idx+'0',0);
			}
		}
		it->SetLabel(gb->NameAt(idx));

		Buff *tp=gb->BuffAt(idx);
		BMessage *msg=it->Message();
		msg->MakeEmpty();
		msg->AddData("Buff",B_POINTER_TYPE,&tp,sizeof(Buff*));
		it->SetMarked(cb==tp);
		if (it->Menu()==NULL)mdoclist->AddItem(it);
	}

	if (mnxt){
		mdoclist->AddSeparatorItem();
		mdoclist->AddItem(mprv);
		mdoclist->AddItem(mnxt);
	}

}


void YateWindow::MenusBeginning(){
	DoMenuFontSize();
	DoMenuFontName();
	BMenuItem *it;

	if (mcurs){
		for (int idx=0;idx<4;idx++){
			ProcTitle("%s Cursor",mcurs->ItemAt(idx),icurs,(idx*4 + 140)==mycurs);
		}
	}

	if (mback){
		for (int idx=0;idx<3;idx++){
			ProcTitle("%s BackGround",mback->ItemAt(idx),iback,schemetab[idx]==myview->vb->csh);
		}
	}

	if (mdir){
		for (int idx=0;idx<4;idx++){
			ProcTitle("%s Direction",mdir->ItemAt(idx),idir,myview->ws->typedir==idx);
		}
	}
	if (mview){
		for (int idx=0;idx<4;idx++){
			ProcTitle("View As",mview->ItemAt(idx),iview,myview->ws->vmode==idx);
		}
	}
	if (menc){
		for (int idx=0;idx<3;idx++){
			ProcTitle("Encoding",menc->ItemAt(idx),iview,cb->encoding==idx);
		}
	}

	if (mmime){
		int mist=TRUE;
		int mx=mmime->CountItems();
		for (int idx=0;idx<mx;idx++){
			bool va=strcmp(MyMimeType(idx),cb->cmime)==0;
			if (va)mist=FALSE;
			ProcTitle("%s MimeType",mmime->ItemAt(idx),imime,va);
			if (va && idx==0){
				imime->SetLabel("No MimeType");
			}
		}
		if (mist){
			char txt[1024];
			sprintf(txt,"‘%s’ MimeType",cb->cmime);
			imime->SetLabel(txt);
		}
	}

	if (mwin){
		it=mwin->ItemAt(8); if (it) it->SetMarked(myview->sscroll);
		it=mwin->ItemAt(9); if (it) it->SetMarked(IsMsg);
		it=mwin->ItemAt(10); if (it) it->SetMarked(IsHScroll);
	}

	if (mdoc){
		it=mdoc->ItemAt(14); if (it) it->SetMarked(cb->term);
//      it=mdoc->ItemAt(15); if (it) it->SetMarked(cb->utf8);
	}

	if (mdoclist)  DoDocList();

}

void YateWindow::ScreenChanged(BRect, color_space depth){
	//    printf("cspace was %x, now %x\n",myview->cspace,depth);
	myview->cspace=depth;
}


//========================

#define BRITE 255
#define NORM 219
#define DARK 152

StatusView::StatusView(BRect rect, char *name,port_id pp)
	   : BView(rect, name,
	B_FOLLOW_BOTTOM|B_FOLLOW_LEFT_RIGHT
	, B_WILL_DRAW|B_NAVIGABLE|B_FULL_UPDATE_ON_RESIZE)
{
	pp=pp;
	cvx=cvy=-1;
	float   hh=rect.Height()*0.5;
	float   xx=0,ww,mx,fx;

	ww=30;xpos.Set(xx,0,xx+ww,hh);xx+=ww+2;
	ww=49;ypos.Set(xx,0,xx+ww,hh);xx+=ww+2;

	fx=rect.Width();
	mx=(fx+xx)/2.0;
	spos.Set(xx,0,mx-1.0,hh);
	rpos.Set(mx+1.0,0,fx,hh);
	mpos.Set(0,hh+1.0,fx,hh*2.0);

//    int32 mm=B_FOLLOW_BOTTOM;
	int32 mm=B_FOLLOW_TOP;
	xrv=new STextView(xpos,"XPos",mm|B_FOLLOW_LEFT,S_GOTO_LINEX);
	yrv=new STextView(ypos,"YPos",mm|B_FOLLOW_LEFT,S_GOTO_LINEY);
	srv=new STextView(spos,"Search",mm|B_FOLLOW_LEFT_RIGHT,A_FIND_FORWARD);
	rrv=new STextView(rpos,"Replace",mm|B_FOLLOW_RIGHT,A_REPLACE_THIS);
	mm=B_FOLLOW_BOTTOM;
	mrv=new STextView(mpos,"Message",mm|B_FOLLOW_LEFT_RIGHT,0);


	time_t ff;
	time(&ff);
	char *spa=ctime(&ff);
	spa[strlen(spa)]=0;
	ShowMsg(spa);


	AddChild(xrv);
	AddChild(yrv);
	AddChild(srv);
	AddChild(rrv);
	AddChild(mrv);
	SetPos(0,0);
	SetViewColor(DARK,DARK,DARK);//0,255,0);
//  SetViewColor(0,255,0);
}

StatusView::~StatusView(){
}

void StatusView::Draw(BRect ){
	BRect fr=Bounds();
	SetHighColor(DARK,DARK,DARK);//0,255,0);
	FillRect(fr);

	/*
		SetHighColor(128,128,128);//brite,brite,brite);
		StrokeLine(BPoint(fr.left,fr.top),BPoint(fr.left,fr.bottom));
		StrokeLine(BPoint(fr.left,fr.top),BPoint(fr.right,fr.top));
	//    SetHighColor(32,32,32);
		StrokeLine(BPoint(fr.right,fr.top),BPoint(fr.right,fr.bottom));
		StrokeLine(BPoint(fr.left,fr.bottom),BPoint(fr.right,fr.bottom));
	*/
}


void StatusView::SetPos(int xx,int yy){
	char    temp[16];
	if (xx!=cvx){
		cvx=xx;sprintf(temp,"%d",xx);
		xrv->SetText(temp);
	}
	if (yy!=cvy){
		cvy=yy;sprintf(temp,"%d",yy+1);
		yrv->SetText(temp);
	}
}


void StatusView::SetSearch(const char *src){if (src)srv->SetText(src);}
void StatusView::SetReplace(const char *src){if (src)rrv->SetText(src);}
void StatusView::ShowMsg(const char *src){if (src)mrv->SetText(src);}

void StatusView::MyNav(STextView *src,int dir){
	if (src==NULL){
		((YateWindow*)Window())->myview->MakeFocus();
		return;
	}
	dir=(dir>0)?1:-1;

	STextView *dest=xrv;
	int ss=0;
	if (src==xrv)ss=0;
	if (src==yrv)ss=1;
	if (src==srv)ss=2;
	if (src==rrv)ss=3;
	ss=(ss+dir)&3;
	switch (ss){
		default:dest=xrv;break;
		case 1:dest=yrv;break;
		case 2:dest=srv;break;
		case 3:dest=rrv;break;
	}

	dest->MakeFocus();
	dest->SelectAll();
}


STextView::STextView(BRect frame,
  const char *name,uint32  resizeMask,int32 msg):
	BTextView(frame,name,frame,resizeMask,B_WILL_DRAW|B_NAVIGABLE){
	mymsg=msg;
	BRect in=Bounds();
	in.top+=3.0;
	in.bottom-=2.0;
	in.left+=2.0;
	in.right-=3.0;
	SetFontAndColor(be_plain_font2);
	SetViewColor(NORM,NORM,NORM);
	SetTextRect(in);
}

void STextView::Draw(BRect ){
	BRect fr=Bounds();

	SetHighColor(DARK,DARK,DARK);
	StrokeLine(BPoint(fr.left,fr.top),BPoint(fr.right,fr.top));
	//    StrokeLine(BPoint(fr.right,fr.top+1.0),BPoint(fr.right,fr.bottom));
	if (IsFocus()){
		fr.top+=1.0;
		SetLowColor(255,255,255);
		FillRect(fr,B_SOLID_LOW);
		SetHighColor(0,0,229);
		StrokeRect(fr,B_SOLID_HIGH);
	}else{
		SetLowColor(DARK,DARK,DARK);
		SetHighColor(BRITE,BRITE,BRITE);
		StrokeLine(BPoint(fr.left,fr.top+1.0),BPoint(fr.right,fr.top+1.0));
		StrokeLine(BPoint(fr.left,fr.top+2.0),BPoint(fr.left,fr.bottom));
	//        StrokeLine(BPoint(fr.right-1.0,fr.top+1.0),BPoint(fr.right-1.0,fr.bottom));
	//        StrokeLine(BPoint(fr.left,fr.bottom),BPoint(fr.right-2.0,fr.bottom));
	}
	//    StrokeRect(fr);
	/*
		SetHighColor(0,0,255);
		SetHighColor(brite,brite,brite);
		if (IsFocus())  SetHighColor(0,0,240);
		StrokeLine(BPoint(fr.left+1.0,fr.bottom),BPoint(fr.right,fr.bottom));
	*/

	BTextView::Draw(fr);
}

void STextView::KeyDown(const char *bytes, int32 numBytes){
	switch (bytes[0]){
		case    9:  //tab
			{
				BMessage *ms=(Window())->CurrentMessage();
				int32 mod=0;
				ms->FindInt32("modifiers",&mod);

				((StatusView*)Parent())->MyNav(this,!(mod&B_SHIFT_KEY));
			}
			break;
		case 10:    //cr
			if (mymsg){
				BMessage    ms(mymsg);
				ms.AddString("Data",Text());
				Window()->PostMessage(&ms);
			}
			break;
		case B_FUNCTION_KEY:
			{
	//                printf("function key\n");
				int32 key;
				Window()->CurrentMessage()->FindInt32("key",&key);
				if (key==B_F3_KEY){
					Window()->PostMessage(A_FIND_FORWARD);
				}
			}
			break;
		case 27:    //esc
			((StatusView*)Parent())->MyNav(NULL,0);
			break;
		default:
			BTextView::KeyDown(bytes,numBytes);
			break;
	}
}

void STextView::MakeFocus(bool vv){
	if (vv){
		SetViewColor(255,255,255);
	}else{
		SetViewColor(NORM,NORM,NORM);
	}
	BTextView::MakeFocus(vv);
	Invalidate(Bounds());
}

void DoMsg(YateWindow*yw,const char *m,int32 v){
	if (!yw) return;
	char sha[512];
	sprintf(sha,m,v);
	BMessage ms(A_SHOW_MSG);
	ms.AddString("Text",sha);
	((BLooper*)yw)->PostMessage(&ms);
}
