{$IFC UNDEFINED doFix1}
	{$SETC doFix1 := 0}
{$ENDC}

{$IFC UNDEFINED doFix2}
	{$SETC doFix2 := 0}
{$ENDC}



PROGRAM NameRegistryFixer;

USES
	Types, QuickDraw, Events, GestaltEqu, TextUtils, Sound, NameRegistry, Script, Traps, MixedMode;

CONST
	kIndent = 4;
	kPropertyColumnWidth = 33;
	kTabColumn = kPropertyColumnWidth + kIndent;
	kMaxBytesPerLine = 32;


PROCEDURE memset(dst:Ptr; val:INTEGER; len:LongInt); C; EXTERNAL; { :Ptr }


PROCEDURE ConvertToPString( VAR s : Str255 );
{ sets the length byte by looking for the c strings terminating null }
VAR
	i	:	Integer;
BEGIN
	s[0] := CHR(255);
	FOR i := 1 TO 255 DO
		IF s[i] = CHR(0) THEN
			BEGIN
				s[0] := CHR(i - 1);
				Leave;
			END;
END;



{$PRAGMAC MARK -}
CONST
	_ExpansionManager			= $AAF3;

{$DEFINEC SIZE_CODE(size)
	ORD((size) = 4) * kFourByteCode + ORD((size) = 2) * kTwoByteCode + ORD((size) = 1) * kOneByteCode
}

{$DEFINEC RESULT_SIZE(sizeCode)
	BSL(sizeCode, kResultSizePhase)
}

{$DEFINEC STACK_ROUTINE_PARAMETER(whichParam, sizeCode)
	BSL( sizeCode, kStackParameterPhase + ((whichParam) - 1) * kStackParameterWidth )
}


CONST
	uppReadNVRAMProcInfo = kD0DispatchedPascalStackBased
		 + RESULT_SIZE(SIZE_CODE(sizeof(SignedByte)))
		 + STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Integer)))
		 + STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(LongInt)));


	uppWriteNVRAMProcInfo = kD0DispatchedPascalStackBased
		 + STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Integer)))
		 + STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(LongInt)))
		 + STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(SignedByte)));


	kReadNVRAMSelector			=	$022E;
	kWriteNVRAMSelector 		=	$032F;


FUNCTION ReadNVRAMByte(offset: LongInt): SignedByte;
{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
INLINE $303C, $022E, $AAF3;
{$ELSEC}
BEGIN
	ReadNVRAMByte := CallUniversalProc( GetToolboxTrapAddress( _ExpansionManager ), uppReadNVRAMProcInfo, kReadNVRAMSelector, offset);
END;
{$ENDC}

PROCEDURE WriteNVRAMByte(offset: LongInt; value: SignedByte);
{$IFC TARGET_OS_MAC AND TARGET_CPU_68K AND NOT TARGET_RT_MAC_CFM}
INLINE $303C, $032F, $AAF3;
{$ELSEC}
BEGIN
	IF CallUniversalProc( GetToolboxTrapAddress( _ExpansionManager ), uppWriteNVRAMProcInfo, kWriteNVRAMSelector, offset, value ) = 0 THEN;
END;
{$ENDC}



PROCEDURE ReadNVRAM( start: LongInt; numBytes: LongInt; dest:Ptr );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
		BEGIN
			dest^ := ReadNVRAMByte( i );
			dest := Ptr( ORD4( dest ) + 1 );
		END;
END; { ReadNVRAM }



PROCEDURE WriteNVRAM( start: LongInt; numBytes: LongInt; src:Ptr );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
		BEGIN
			WriteNVRAMByte( i, src^ );
			src := Ptr( ORD4( src ) + 1 );
		END;
END; { WriteNVRAM }



PROCEDURE ClearNVRAM( start: LongInt; numBytes: LongInt );
VAR
	i			:	LongInt;
BEGIN
	FOR i := start TO start + numBytes - 1 DO
		WriteNVRAMByte( i, 0 );
END; { ClearNVRAM }



{$PRAGMAC MARK -}



CONST
	kNVRAMPropertiesPartitionSize = $400;
	kNVRAMPropertiesPartitionStart = $1400;


		
TYPE
	LocationArr		=	ARRAY[0..5] OF SignedByte;
	PropertyRec = RECORD
{0}			Location		:	LocationArr;
{6}			Name			:	String[3];
			Name4			:	SignedByte;
{11}		Value			:	SignedByte;
			Value1			:	ARRAY [0..7] OF SignedByte;
		END;

CONST
	kPropSize = SizeOf( PropertyRec );
	kMaxNumProps = ( kNVRAMPropertiesPartitionSize - 2 ) DIV kPropSize;

TYPE
	NVRAMPropertiesRec = RECORD
		offsetToEnd		:	Integer;
		properties		:	Array[0..kMaxNumProps - 1] OF PropertyRec;
		unknown			:	Integer;
	END;
	


FUNCTION NumVRAMProps( VAR nvramProps: NVRAMPropertiesRec ): Integer;
BEGIN
	WITH nvramProps DO
		NumVRAMProps := ( offsetToEnd - 2 - kNVRAMPropertiesPartitionStart ) DIV kPropSize;
END; { NumVRAMProps }



PROCEDURE SetNumVRAMProps( numPropsNew: Integer; VAR nvramProps: NVRAMPropertiesRec );
BEGIN
	WITH nvramProps DO
		offsetToEnd := numPropsNew * kPropSize + kNVRAMPropertiesPartitionStart + 2;
END; { SetNumVRAMProps }



PROCEDURE FixNVRAMEnd( VAR nvramProps: NVRAMPropertiesRec );
BEGIN
	IF nvramProps.offsetToEnd < kNVRAMPropertiesPartitionStart + 2 THEN
		nvramProps.offsetToEnd := kNVRAMPropertiesPartitionStart + 2;
END; { FixNVRAMEnd }



PROCEDURE FindNVRAMProperty( CONST property : Str255; CONST val: Str255; VAR nvramProps: NVRAMPropertiesRec; VAR index: Integer );
VAR
	i			:	Integer;
	numProps	:	Integer;
BEGIN
	index := -1;
	WITH nvramProps DO
		BEGIN
			numProps := NumVRAMProps( nvramProps );
			FOR i := 0 TO numProps - 1 DO
				WITH properties[i] DO
					IF BAND( location[0], $10 ) <> 0 THEN
						IF name = property THEN
							IF StringPtr( @Value )^ = val THEN
								BEGIN
									index := i;
									Leave;
								END;
		END; { WITH nvramProps }
END; { FindNVRAMProperty }



FUNCTION BadNameChars( CONST name: Str255 ): Boolean;
VAR
	i	:	Integer;
BEGIN
	BadNameChars := FALSE;
	FOR i := 1 TO Length( name ) DO
		IF name[i] IN [ CHR(0)..CHR(31), CHR($7E)..CHR(255) ] THEN
			BEGIN
				BadNameChars := TRUE;
				Leave;
			END;
END; { BadNameChars }



PROCEDURE CompressNVRAM( VAR nvramProps: NVRAMPropertiesRec; treatLongValuesAsValid: Boolean );
VAR
	srcNdx		:	Integer;
	dstNdx		:	Integer;
	numProps	:	Integer;
	numDeleted	:	Integer;
	numSkip		:	Integer;
	fillPtr		:	Ptr;
BEGIN
	dstNdx := 0;
	srcNdx := 0;

	WITH nvramProps DO
		BEGIN
			numProps := NumVRAMProps( nvramProps );
			
			WHILE srcNdx < numProps DO
				WITH properties[srcNdx] DO
					BEGIN
						numSkip := 1;
						IF
							( BAND( location[0], $10 ) <> 0 )
						 	&
						 	( Length( name ) > 0 ) & ( Length( name ) < 5 ) & ( NOT BadNameChars( name ) )
						 	&
						 	( Length( StringPtr( @value )^ ) >= 0 )
						 THEN
						 	IF ( Length( StringPtr( @value )^ ) < 9 ) | treatLongValuesAsValid THEN
								BEGIN
									numSkip := ( kPropSize - 8 + Length( StringPtr( @value )^ ) + kPropSize - 1 ) DIV kPropSize;

									IF srcNdx + numSkip <= numProps THEN
										BEGIN
											fillPtr := @name[Length(name) + 1];
											memset( fillPtr, 0, ORD4( @value ) - ORD4( fillPtr ) );

											fillPtr := @value1[Length( StringPtr( @value )^ )];
											memset( fillPtr, 0, ORD4( @properties[srcNdx + numSkip] ) - ORD4( fillPtr ) );

											IF srcNdx <> dstNdx THEN
												BlockMoveData( @properties[srcNdx], @properties[dstNdx], numSkip * kPropSize );
											dstNdx := dstNdx + numSkip;
										END;
								END;
						srcNdx := srcNdx + numSkip;
					END;
			numDeleted := numProps - dstNdx;
			memset( @properties[dstNdx], 0, numDeleted * kPropSize );
			SetNumVRAMProps( dstNdx, nvramProps );
		END;
END; { CompressNVRAM }



FUNCTION RegistryPropertyFix( VAR entry : RegEntryID;
						VAR property : Str255; val : Ptr; siz : RegPropertyValueSize ): OSErr;
VAR
	err					:	OSErr;
		
	nvramProps			:	NVRAMPropertiesRec;
	numProps			:	Integer;
	numNeeded			:	Integer;
	numPropsNew			:	Integer;
	foundNdx			:	Integer;
	
	mynvramprop			:	String[9];
	
	ignorErr			:	OSErr;
BEGIN
	IF siz > 255 THEN
		err := nrOverrunErr
	ELSE
		BEGIN
			mynvramprop := 'Hello!!!';

			err := RegistryPropertySet( entry, RegPropertyNamePtr(@property[1])^, @mynvramprop[1], Length( mynvramprop ) );
			IF err = noErr THEN
				BEGIN
					ReadNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );

					ignorErr := RegistryPropertySet( entry, RegPropertyNamePtr(@property[1])^, val, siz ); // restore the value and ignore the nrOverrunErr

					FixNVRAMEnd( nvramProps );
					CompressNVRAM( nvramProps, TRUE );
					
					WITH nvramProps DO
						BEGIN
							numProps := NumVRAMProps( nvramProps );
							numNeeded := ( kPropSize - 8 + siz + kPropSize - 1 ) DIV kPropSize - 1; { subtract 1 for the one we just created }
							numPropsNew := numProps + numNeeded;
							
							IF numPropsNew <= kMaxNumProps THEN
								BEGIN
									FindNVRAMProperty( property, mynvramprop, nvramProps, foundNdx );
									IF foundNdx < 0 THEN
										// DoErr( 'FindNVRAMProperty', foundNdx )
									ELSE
										BEGIN
											SetNumVRAMProps( numPropsNew, nvramProps );

											BlockMoveData( @properties[foundNdx + 1], @properties[foundNdx + 1 + numNeeded], ( numProps - foundNdx - 1 ) * kPropSize );
											WITH properties[foundNdx] DO
												BEGIN
													value := siz;
													BlockMoveData( val, @value1, siz );
												END;

											WriteNVRAM( kNVRAMPropertiesPartitionStart, kNVRAMPropertiesPartitionSize, @nvramProps );
										END; { ELSE }
								END; { IF }
						END; { WITH }
				END; { IF err }
		END; { ELSE }
	RegistryPropertyFix := err;
END; { RegistryPropertyFix }


{$PRAGMAC MARK -}


PROCEDURE NameRegistryFix;
VAR
	err					:	OSErr;

	entryOp				:	RegEntryIterationOp;
	entryCookie			:	regEntryIter;
	entryDone			:	Boolean;
	entry				:	RegEntryID;

	propertyCookie		:	RegPropertyIter;
	propertyDone		:	Boolean;
	propertyName		:	Str255;
	propertyModifiers	:	RegPropertyModifiers;
	propertySize		:	RegPropertyValueSize;
	propertyValue		:	Ptr;
BEGIN
	propertyName[33] := CHR(0); // because RegistryPropertyIterate does not add this terminating null if the property name is 32 characters
	entryOp := kRegIterContinue;
	IF RegistryEntryIterateCreate( entryCookie ) = noErr THEN
		REPEAT
			IF ( RegistryEntryIterate( entryCookie, entryOp, entry, entryDone ) = noErr ) & ( entryDone = FALSE ) THEN
				BEGIN
					IF RegistryPropertyIterateCreate( entry, propertyCookie ) = noErr THEN
						BEGIN
							REPEAT
								IF ( RegistryPropertyIterate( propertyCookie, RegPropertyNamePtr(@propertyName[1])^, propertyDone ) = noErr ) & ( propertyDone = FALSE ) THEN
									BEGIN
										ConvertToPString( propertyName );
										IF ( RegistryPropertyGetMod( entry, RegPropertyNamePtr(@propertyName[1])^, propertyModifiers ) = noErr ) & ( BAND( propertyModifiers, kRegPropertyValueIsSavedToNVRAM ) <> 0 ) THEN
											BEGIN
												IF ( RegistryPropertyGetSize( entry, RegPropertyNamePtr(@propertyName[1])^, propertySize ) = noErr ) & ( propertySize > 8 ) THEN
													BEGIN
														propertyValue := NewPtr( propertySize );
														IF propertyValue <> NIL THEN
															BEGIN
																IF RegistryPropertyGet( entry, RegPropertyNamePtr(@propertyName[1])^, propertyValue, propertySize ) = noErr THEN
																	BEGIN
																	
																		{$IFC doFix1}
																			IF RegistryPropertySet( entry, RegPropertyNamePtr(@propertyName[1])^, propertyValue, propertySize ) = nrOverrunErr THEN { can the property be saved to nvram? }
																			IF ( propertySize <= 32 ) | ( RegistryPropertySet( entry, RegPropertyNamePtr(@propertyName[1])^, propertyValue, 32 ) = nrOverrunErr ) THEN { if not then can 32 bytes of the property be saved to NVRAM? }
																			IF RegistryPropertySet( entry, RegPropertyNamePtr(@propertyName[1])^, propertyValue, 8 ) = nrOverrunErr THEN { if not, then try 8 bytes as a last resort }
																				BEGIN
																					{ ? }
																				END;
																		{$ELIFC doFix2}
																			err := RegistryPropertyFix( entry, propertyName, propertyValue, propertySize );
																		{$ENDC}
																		
																	END; { IF RegistryPropertyGet }
																		
																DisposePtr( propertyValue );
															END; { IF propertyValue }
													END; { IF RegistryPropertyGetSize }
											END; { IF RegistryPropertyGetMod }
									END; { IF RegistryPropertyIterate }
							UNTIL propertyDone;
							err := RegistryPropertyIterateDispose( propertyCookie );
						END; { IF RegistryPropertyIterateCreate }
					err := RegistryEntryIDDispose( entry );
				END; { IF RegistryEntryIterate }
		UNTIL entryDone;
	err := RegistryEntryIterateDispose( entryCookie );
END; { NameRegistryDump }


BEGIN { Main }
	NameRegistryFix;
END.
