/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import java.util.ArrayList;
import net.minecraft.util.MathHelper;
import tmt.Coord2D;
import tmt.PositionTransformVertex;
import tmt.Shape3D;
import tmt.TexturedPolygon;
import tmt.Vec3f;

public class Shape2D {
    public ArrayList<Coord2D> coords;

    public Shape2D() {
        this.coords = new ArrayList();
    }

    public Shape2D(Coord2D[] coordArray) {
        this.coords = new ArrayList();
        for (Coord2D coord : coordArray) {
            this.coords.add(coord);
        }
    }

    public Shape2D(ArrayList<Coord2D> coordList) {
        this.coords = coordList;
    }

    public Coord2D[] getCoordArray() {
        return (Coord2D[])this.coords.toArray();
    }

    public Shape3D extrude(float x, float y, float z, float rotX, float rotY, float rotZ, float depth, int u, int v, float textureWidth, float textureHeight, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float[] faceLengths) {
        PositionTransformVertex[] verts = new PositionTransformVertex[this.coords.size() * 2];
        PositionTransformVertex[] vertsTop = new PositionTransformVertex[this.coords.size()];
        PositionTransformVertex[] vertsBottom = new PositionTransformVertex[this.coords.size()];
        TexturedPolygon[] poly = new TexturedPolygon[this.coords.size() + 2];
        Vec3f extrudeVector = new Vec3f(0.0f, 0.0f, depth);
        this.setVectorRotations(extrudeVector, rotX, rotY, rotZ);
        if (faceLengths != null && faceLengths.length < this.coords.size()) {
            faceLengths = null;
        }
        float totalLength = 0.0f;
        for (int idx = 0; idx < this.coords.size(); ++idx) {
            Coord2D curCoord = this.coords.get(idx);
            Coord2D nextCoord = this.coords.get((idx + 1) % this.coords.size());
            float texU1 = (float)(curCoord.uCoord + u) / textureWidth;
            float texU2 = (float)(shapeTextureWidth * 2 - curCoord.uCoord + u) / textureWidth;
            float texV = (float)(curCoord.vCoord + v) / textureHeight;
            Vec3f vecCoord = new Vec3f(curCoord.xCoord, curCoord.yCoord, 0.0f);
            this.setVectorRotations(vecCoord, rotX, rotY, rotZ);
            verts[idx] = new PositionTransformVertex(x + vecCoord.xCoord, y + vecCoord.yCoord, z + vecCoord.zCoord, texU1, texV);
            verts[idx + this.coords.size()] = new PositionTransformVertex(x + vecCoord.xCoord - extrudeVector.xCoord, y + vecCoord.yCoord - extrudeVector.yCoord, z + vecCoord.zCoord - extrudeVector.zCoord, texU2, texV);
            vertsTop[idx] = new PositionTransformVertex(verts[idx].vector3F, verts[idx].textureX, verts[idx].textureY);
            vertsBottom[this.coords.size() - idx - 1] = new PositionTransformVertex(verts[idx + this.coords.size()].vector3F, verts[idx + this.coords.size()].textureX, verts[idx + this.coords.size()].textureY);
            if (faceLengths != null) {
                totalLength += faceLengths[idx];
                continue;
            }
            totalLength = (float)((double)totalLength + Math.sqrt(Math.pow(curCoord.xCoord - nextCoord.xCoord, 2.0) + Math.pow(curCoord.yCoord - nextCoord.yCoord, 2.0)));
        }
        poly[this.coords.size()] = new TexturedPolygon(vertsTop);
        poly[this.coords.size() + 1] = new TexturedPolygon(vertsBottom);
        float currentLengthPosition = totalLength;
        for (int idx = 0; idx < this.coords.size(); ++idx) {
            Coord2D curCoord = this.coords.get(idx);
            Coord2D nextCoord = this.coords.get((idx + 1) % this.coords.size());
            float currentLength = (float)Math.sqrt(Math.pow(curCoord.xCoord - nextCoord.xCoord, 2.0) + Math.pow(curCoord.yCoord - nextCoord.yCoord, 2.0));
            if (faceLengths != null) {
                currentLength = faceLengths[faceLengths.length - idx - 1];
            }
            float ratioPosition = currentLengthPosition / totalLength;
            float ratioLength = (currentLengthPosition - currentLength) / totalLength;
            float texU1 = (ratioLength * (float)sideTextureWidth + (float)u) / textureWidth;
            float texU2 = (ratioPosition * (float)sideTextureWidth + (float)u) / textureWidth;
            float texV1 = ((float)v + (float)shapeTextureHeight) / textureHeight;
            float texV2 = ((float)v + (float)shapeTextureHeight + (float)sideTextureHeight) / textureHeight;
            PositionTransformVertex[] polySide = new PositionTransformVertex[]{new PositionTransformVertex(verts[idx].vector3F, texU2, texV1), new PositionTransformVertex(verts[this.coords.size() + idx].vector3F, texU2, texV2), new PositionTransformVertex(verts[this.coords.size() + (idx + 1) % this.coords.size()].vector3F, texU1, texV2), new PositionTransformVertex(verts[(idx + 1) % this.coords.size()].vector3F, texU1, texV1)};
            poly[idx] = new TexturedPolygon(polySide);
            currentLengthPosition -= currentLength;
        }
        return new Shape3D(verts, poly);
    }

    protected Vec3f setVectorRotations(Vec3f extrudeVector, float xRot, float yRot, float zRot) {
        float x = xRot;
        float y = yRot;
        float z = zRot;
        float xC = MathHelper.func_76134_b((float)x);
        float xS = MathHelper.func_76126_a((float)x);
        float yC = MathHelper.func_76134_b((float)y);
        float yS = MathHelper.func_76126_a((float)y);
        float zC = MathHelper.func_76134_b((float)z);
        float zS = MathHelper.func_76126_a((float)z);
        double xVec = extrudeVector.xCoord;
        double yVec = extrudeVector.yCoord;
        double zVec = extrudeVector.zCoord;
        double xy = (double)xC * yVec - (double)xS * zVec;
        double xz = (double)xC * zVec + (double)xS * yVec;
        double yz = (double)yC * xz - (double)yS * xVec;
        double yx = (double)yC * xVec + (double)yS * xz;
        double zx = (double)zC * yx - (double)zS * xy;
        double zy = (double)zC * xy + (double)zS * yx;
        xVec = zx;
        yVec = zy;
        zVec = yz;
        return new Vec3f((float)xVec, (float)yVec, (float)zVec);
    }
}

