/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.TraincraftEntityHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import train.client.core.handlers.SoundUpdaterRollingStock;
import train.common.Traincraft;
import train.common.adminbook.ServerLogger;
import train.common.api.AbstractTrains;
import train.common.api.AbstractWorkCart;
import train.common.api.ElectricTrain;
import train.common.api.EntityBogie;
import train.common.api.Freight;
import train.common.api.IPassenger;
import train.common.api.LiquidTank;
import train.common.api.Locomotive;
import train.common.api.SpeedHandler;
import train.common.api.Tender;
import train.common.api.TrainsOnClick;
import train.common.blocks.BlockTCRail;
import train.common.blocks.BlockTCRailGag;
import train.common.core.HandleOverheating;
import train.common.core.handlers.CollisionHandler;
import train.common.core.handlers.ConfigHandler;
import train.common.core.handlers.FuelHandler;
import train.common.core.handlers.LinkHandler;
import train.common.core.handlers.TrainHandler;
import train.common.core.handlers.TrainsDamageSource;
import train.common.core.network.PacketRollingStockRotation;
import train.common.core.util.TraincraftUtil;
import train.common.entity.rollingStock.EntityTracksBuilder;
import train.common.items.ItemTCRail;
import train.common.items.ItemWrench;
import train.common.library.BlockIDs;
import train.common.library.EnumTrains;
import train.common.tile.TileTCRail;
import train.common.tile.TileTCRailGag;

public abstract class EntityRollingStock
extends AbstractTrains
implements ILinkableCart {
    public int fuelTrain;
    protected static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    protected EntityPlayer playerEntity;
    private AxisAlignedBB boundingBoxSmall;
    public float maxSpeed;
    public float railMaxSpeed;
    public double speedLimiter = 1.0;
    public boolean speedWasSet = false;
    public ItemStack item;
    public float rotation;
    public int rail;
    public int meta;
    public double d6;
    public double d7;
    private int rollingturnProgress;
    private double rollingX;
    private double rollingY;
    private double rollingZ;
    private float rollingServerPitch;
    public double rotationYawClient;
    public float rotationYawClientReal;
    public double anglePitchClient;
    public float serverRealRotation;
    private float previousServerRealRotation;
    public boolean isServerInReverse = false;
    public boolean isClientInReverse = false;
    public boolean serverInReverseSignPositive = false;
    public float serverRealPitch;
    private double rollingPitch;
    public float oldClientYaw = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private double rollingVelocityX;
    @SideOnly(value=Side.CLIENT)
    private double rollingVelocityY;
    @SideOnly(value=Side.CLIENT)
    private double rollingVelocityZ;
    private CollisionHandler collisionhandler;
    private LinkHandler linkhandler;
    private TrainsOnClick trainsOnClick;
    public boolean isBraking;
    public boolean isClimbing;
    public int overheatLevel;
    public int linkageNumber;
    public Side side;
    @SideOnly(value=Side.CLIENT)
    private SoundHandler theSoundManager;
    @SideOnly(value=Side.CLIENT)
    private SoundUpdaterRollingStock sndUpdater;
    public static ArrayList<TrainHandler> allTrains = new ArrayList();
    private HandleOverheating handleOverheating;
    public ArrayList<EntityRollingStock> RollingStock;
    private int numLaps;
    private int ticksSinceHeld = 0;
    private boolean cartLocked = false;
    private double bogieShift = 0.0;
    private boolean needsBogieUpdate;
    private boolean firstLoad = true;
    public EntityBogie bogieLoco = null;
    private double mountedOffset = -0.5;
    public double posYFromServer;
    private boolean shouldServerSetPosYOnClient = true;
    private int clientTicks = 0;
    private double derailSpeed = 0.46;
    List list = null;
    Block l;
    boolean flag;
    boolean flag1;
    private double norm;

    public EntityRollingStock(World world) {
        super(world);
        this.initRollingStock(world);
    }

    @Override
    public GameProfile getOwner() {
        return CartTools.getCartOwner(this);
    }

    public EntityRollingStock(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
        this.initRollingStock(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public void initRollingStock(World world) {
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70129_M = 0.65f;
        this.linkageNumber = 0;
        this.field_70144_Y = 0.8f;
        this.boundingBoxSmall = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0);
        this.setBoundingBoxSmall(0.0, 0.0, 0.0, 2.0f, 1.0f);
        this.RollingStock = new ArrayList();
        this.handleOverheating = new HandleOverheating(this);
        this.collisionhandler = new CollisionHandler(world);
        this.linkhandler = new LinkHandler(world);
        this.trainsOnClick = new TrainsOnClick();
        this.maxSpeedAirLateral = defaultMaxSpeedAirLateral;
        this.maxSpeedAirVertical = defaultMaxSpeedAirVertical;
        this.dragAir = defaultDragAir;
        if (ConfigHandler.FLICKERING) {
            this.field_70158_ak = true;
        }
        this.side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.side == Side.CLIENT) {
            this.sndUpdater = new SoundUpdaterRollingStock();
        }
        this.needsBogieUpdate = false;
        EntityRollingStock.setCollisionHandler(null);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        this.isBraking = additionalData.readBoolean();
        this.setTrainLockedFromPacket(additionalData.readBoolean());
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.isBraking);
        buffer.writeBoolean(this.getTrainLockedFromPacket());
    }

    public String getTrainName() {
        return this.field_70180_af.func_75681_e(9);
    }

    public String getTrainType() {
        return this.field_70180_af.func_75681_e(6);
    }

    @Override
    public String getTrainOwner() {
        return this.field_70180_af.func_75681_e(7);
    }

    public String getTrainCreator() {
        return this.field_70180_af.func_75681_e(13);
    }

    public int getIDForServer() {
        return this.field_70180_af.func_75679_c(5);
    }

    public int getNumberOfTrainsForServer() {
        return this.field_70180_af.func_75679_c(10);
    }

    public int getUniqueTrainIDClient() {
        return this.field_70180_af.func_75679_c(11);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public double func_70042_X() {
        return this.mountedOffset;
    }

    public void setMountedYOffset(double offset) {
        this.mountedOffset = offset;
    }

    public void setYFromServer(double posYServer) {
        this.posYFromServer = posYServer;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)1);
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(0.0f));
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    public boolean isLocomotive() {
        return this instanceof Locomotive;
    }

    @Override
    public boolean isPassenger() {
        return this instanceof IPassenger;
    }

    @Override
    public boolean isFreightCart() {
        return this instanceof Freight || this instanceof LiquidTank;
    }

    @Override
    public boolean isFreightOrPassenger() {
        return this instanceof Freight || this instanceof IPassenger || this instanceof LiquidTank;
    }

    @Override
    public boolean isBuilder() {
        return this instanceof EntityTracksBuilder;
    }

    @Override
    public boolean isTender() {
        return this instanceof Tender;
    }

    @Override
    public boolean isWorkCart() {
        return this instanceof AbstractWorkCart;
    }

    @Override
    public boolean isElectricTrain() {
        return this instanceof ElectricTrain;
    }

    protected int steamFuelLast(ItemStack it) {
        return FuelHandler.steamFuelLast(it);
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource.func_76346_g() instanceof EntityPlayer && !damagesource.func_76352_a()) {
            if (this instanceof IPassenger && this.canBeDestroyedByPlayer(damagesource)) {
                return false;
            }
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            if (((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.func_70492_c(1000.0f);
                if (ConfigHandler.ENABLE_WAGON_REMOVAL_NOTICES && ((EntityPlayer)damagesource.func_76346_g()).func_70003_b(2, "")) {
                    ((EntityPlayer)damagesource.func_76346_g()).func_146105_b((IChatComponent)new ChatComponentText("Operator removed train owned by " + this.getTrainOwner()));
                }
            }
            this.func_70492_c(this.func_70491_i() + i * 10.0f);
            if (this.func_70491_i() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                ServerLogger.deleteWagon(this);
                if (this instanceof IPassenger) {
                    this.func_70106_y();
                    this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70492_c(this.func_70491_i() + this.func_70491_i() * 10.0f);
    }

    public void unLink() {
        if (this.isAttached) {
            if (this.cartLinked1 != null) {
                if (this.cartLinked1.Link1 == (double)this.uniqueID) {
                    this.cartLinked1.Link1 = 0.0;
                    this.cartLinked1.cartLinked1 = null;
                    if (this.cartLinked1.RollingStock != null) {
                        this.cartLinked1.RollingStock.clear();
                    }
                } else if (this.cartLinked1.Link2 == (double)this.uniqueID) {
                    this.cartLinked1.Link2 = 0.0;
                    this.cartLinked1.cartLinked2 = null;
                    if (this.cartLinked1.RollingStock != null) {
                        this.cartLinked1.RollingStock.clear();
                    }
                }
            }
            if (this.cartLinked2 != null) {
                if (this.cartLinked2.Link1 == (double)this.uniqueID) {
                    this.cartLinked2.Link1 = 0.0;
                    this.cartLinked2.cartLinked1 = null;
                    if (this.cartLinked2.RollingStock != null) {
                        this.cartLinked2.RollingStock.clear();
                    }
                } else if (this.cartLinked2.Link2 == (double)this.uniqueID) {
                    this.cartLinked2.Link2 = 0.0;
                    this.cartLinked2.cartLinked2 = null;
                    if (this.cartLinked2.RollingStock != null) {
                        this.cartLinked2.RollingStock.clear();
                    }
                }
            }
            this.cartLinked1 = null;
            this.cartLinked2 = null;
            this.isAttached = false;
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.unLink();
        if (this.train != null && this.train.getTrains() != null) {
            for (int i2 = 0; i2 < this.train.getTrains().size(); ++i2) {
                if (this.train.getTrains().get(i2) instanceof Locomotive) {
                    this.train.getTrains().get((int)i2).cartLinked1 = null;
                    this.train.getTrains().get((int)i2).Link1 = 0.0;
                    this.train.getTrains().get((int)i2).cartLinked2 = null;
                    this.train.getTrains().get((int)i2).Link2 = 0.0;
                }
                if (this.train.getTrains().get(i2) == this || this.train == null || this.train.getTrains() == null || this.train.getTrains().get(i2) == null || this.train.getTrains().get((int)i2).train == null || this.train.getTrains().get((int)i2).train.getTrains() == null) continue;
                this.train.getTrains().get((int)i2).train.getTrains().clear();
            }
        }
        if (this.train != null && this.train.getTrains().size() <= 1) {
            this.train.getTrains().clear();
            allTrains.remove(this.train);
        }
        if (this.bogieLoco != null) {
            this.bogieLoco.func_70106_y();
            this.bogieLoco.field_70128_L = true;
        }
        this.field_70128_L = true;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            this.soundUpdater();
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void pressKey(int i) {
    }

    public void keyHandlerFromPacket(int i) {
        this.pressKey(i);
    }

    private void handleTrain() {
        if (this instanceof Locomotive && this.train != null) {
            for (int i2 = 0; i2 < this.train.getTrains().size(); ++i2) {
                if (RailTools.isCartLockedDown(this.train.getTrains().get(i2))) {
                    this.cartLocked = true;
                    this.ticksSinceHeld = 40;
                    if (!((Locomotive)this).canBeAdjusted) {
                        ((Locomotive)this).setCanBeAdjusted(true);
                    }
                }
                this.cartLocked = false;
            }
            if (this.ticksSinceHeld > 0 && !this.cartLocked) {
                --this.ticksSinceHeld;
            }
            if (this.ticksSinceHeld <= 0 && !this.cartLocked && ((Locomotive)this).canBeAdjusted && !((Locomotive)this).canBePulled) {
                ((Locomotive)this).setCanBeAdjusted(false);
            }
        }
        if (this.field_70173_aa % 40 != 0) {
            return;
        }
        if (allTrains.size() == 0) {
            if (this.cartLinked1 != null || this.cartLinked2 != null) {
                this.train = new TrainHandler(this);
            }
        } else if ((this.train == null || this.train != null && this.train.getTrains().size() == 0) && (this.cartLinked1 != null || this.cartLinked2 != null)) {
            if (this.cartLinked1 != null && this.cartLinked1.train != null && this.cartLinked1.train.getTrains() != null && this.cartLinked1.train.getTrains().size() != 0) {
                this.train = this.cartLinked1.train;
                return;
            }
            if (this.cartLinked2 != null && this.cartLinked2.train != null && this.cartLinked2.train.getTrains() != null && this.cartLinked2.train.getTrains().size() != 0) {
                this.train = this.cartLinked2.train;
                return;
            }
            this.train = new TrainHandler(this);
        }
        if (this.train != null && this.train.getTrains().size() > 1) {
            if (this instanceof Locomotive && !((Locomotive)this).canBeAdjusted && this.getDestination().length() > 0) {
                for (int i = 0; i < this.train.getTrains().size(); ++i) {
                    if (this.train.getTrains().get(i) != null && !this.train.getTrains().get(i).equals(this)) {
                        this.train.getTrains().get((int)i).destination = this.getDestination();
                    }
                    CartTools.setCartOwner((EntityMinecart)this.train.getTrains().get(i), CartTools.getCartOwner(this));
                }
            }
        } else if (!(this instanceof Locomotive)) {
            this.destination = "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.rollingX = par1;
        this.rollingY = par3;
        this.rollingZ = par5;
        this.rollingPitch = par8;
        this.rollingturnProgress = par9 + 2;
        this.field_70159_w = this.rollingVelocityX;
        this.field_70181_x = this.rollingVelocityY;
        this.field_70179_y = this.rollingVelocityZ;
    }

    @Override
    public void func_70071_h_() {
        Side side;
        EntityLivingBase entity;
        if (this.trainSpec.getBogieLocoPosition() != 0.0 && this.bogieLoco == null) {
            this.bogieShift = this.trainSpec.getBogieLocoPosition();
            this.bogieLoco = new EntityBogie(this.field_70170_p, this.field_70165_t - Math.cos((double)this.serverRealRotation * (Math.PI / 180)) * this.bogieShift, this.field_70163_u + (Math.tan((double)this.renderPitch * (Math.PI / 180)) * -this.bogieShift + this.func_70042_X()), this.field_70161_v - Math.sin((double)this.serverRealRotation * (Math.PI / 180)) * this.bogieShift, this, this.uniqueID, 0, this.bogieShift);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)this.bogieLoco);
            }
            this.needsBogieUpdate = true;
        }
        super.manageChunkLoading();
        if (!this.field_70170_p.field_72995_K && this.uniqueID == -1 && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            this.setNewUniqueID(this.func_145782_y());
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            ((EntityPlayer)this.field_70153_n).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 20, 5, true));
        }
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        this.isBraking = false;
        if (this.field_70170_p.field_72995_K && Traincraft.proxy.getCurrentScreen() == null && this.field_70153_n instanceof EntityLivingBase && TraincraftEntityHelper.getIsJumping(entity = (EntityLivingBase)this.field_70153_n)) {
            this.isBraking = true;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            if (this.field_71087_bX) {
                if (MinecraftServer.func_71276_C().func_71255_r()) {
                    if (this.field_70154_o == null && this.field_82153_h++ >= this.func_82145_z()) {
                        this.field_82153_h = this.func_82145_z();
                        this.field_71088_bW = this.func_82147_ab();
                        int var3 = this.field_70170_p.field_73011_w.field_76574_g == -1 ? 0 : -1;
                        this.func_71027_c(var3);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT) {
            this.soundUpdater();
        }
        if (this.field_70170_p.field_72995_K) {
            ++this.clientTicks;
            if (this.rollingturnProgress > 0) {
                this.field_70177_z = (float)this.rotationYawClient;
                this.field_70125_A = (float)((double)this.field_70125_A + (this.rollingPitch - (double)this.field_70125_A) / (double)this.rollingturnProgress);
                this.func_70107_b(this.field_70165_t + (this.rollingX - this.field_70165_t) / (double)this.rollingturnProgress, this.field_70163_u + (this.rollingY - this.field_70163_u) / (double)this.rollingturnProgress, this.field_70161_v + (this.rollingZ - this.field_70161_v) / (double)this.rollingturnProgress);
                --this.rollingturnProgress;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            if (this.posYFromServer != 0.0 && this.clientTicks < 600 && this.field_70163_u > this.posYFromServer && this.shouldServerSetPosYOnClient && Math.abs(this.field_70163_u - this.posYFromServer) > 0.04) {
                this.field_70163_u = this.posYFromServer;
            }
            return;
        }
        if (this.cartLinked1 == null && this.Link1 != 0.0 || this.cartLinked2 == null && this.Link2 != 0.0) {
            this.list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(15.0, 15.0, 15.0));
            if (this.list != null && this.list.size() > 0) {
                for (Object entity2 : this.list) {
                    if (!(entity2 instanceof EntityRollingStock)) continue;
                    if ((double)((EntityRollingStock)entity2).uniqueID == this.Link1) {
                        this.cartLinked1 = (EntityRollingStock)entity2;
                        continue;
                    }
                    if ((double)((EntityRollingStock)entity2).uniqueID != this.Link2) continue;
                    this.cartLinked2 = (EntityRollingStock)entity2;
                }
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.needsBogieUpdate) {
            if (this.bogieLoco != null) {
                double rotationCos1 = Math.cos(Math.toRadians(this.serverRealRotation));
                double rotationSin1 = Math.sin(Math.toRadians(this.serverRealRotation));
                if (!this.firstLoad) {
                    rotationCos1 = Math.cos(Math.toRadians(this.serverRealRotation + 90.0f));
                    rotationSin1 = Math.sin(Math.toRadians(this.serverRealRotation + 90.0f));
                }
                this.bogieLoco.func_70107_b(this.field_70165_t + rotationCos1 * Math.abs(this.bogieShift), this.bogieLoco.field_70163_u, this.field_70161_v + rotationSin1 * Math.abs(this.bogieShift));
            }
            this.firstLoad = false;
            this.needsBogieUpdate = false;
        }
        if (this.bogieLoco != null) {
            this.bogieLoco.updateDistance();
        }
        if (TraincraftUtil.isRailBlockAt(this.field_70170_p, i, j - 1, k) || this.field_70170_p.func_147439_a(i, j - 1, k) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j - 1, k) == BlockIDs.tcRailGag.block) {
            --j;
        } else if (TraincraftUtil.isRailBlockAt(this.field_70170_p, i, j + 1, k) || this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRailGag.block) {
            ++j;
        }
        this.l = this.field_70170_p.func_147439_a(i, j, k);
        this.updateOnTrack(i, j, k, this.l);
        this.d6 = this.field_70169_q - this.field_70165_t;
        this.d7 = this.field_70166_s - this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        if (this.d6 * this.d6 + this.d7 * this.d7 > 1.0E-4) {
            this.field_70177_z = (float)(Math.atan2(this.d7, this.d6) * 180.0 / Math.PI);
            if (this.isClientInReverse) {
                this.field_70177_z += 180.0f;
            }
        }
        float anglePitch = 0.0f;
        if (this.bogieLoco != null) {
            this.serverRealRotation = MathHelper.func_76142_g((float)((float)Math.toDegrees(Math.atan2((float)(this.bogieLoco.field_70161_v - this.field_70161_v), (float)(this.bogieLoco.field_70165_t - this.field_70165_t))) - 90.0f));
            anglePitch = (float)Math.atan((this.bogieLoco.field_70163_u - this.field_70163_u) / (double)MathHelper.func_76133_a((double)((this.bogieLoco.field_70165_t - this.field_70165_t) * (this.bogieLoco.field_70165_t - this.field_70165_t) + (this.bogieLoco.field_70161_v - this.field_70161_v) * (this.bogieLoco.field_70161_v - this.field_70161_v))));
            this.serverRealPitch = anglePitch + (float)((this.bogieLoco.field_70161_v - this.field_70161_v) * (this.bogieLoco.field_70161_v - this.field_70161_v));
        } else {
            float tempPitch;
            float rotation = this.field_70177_z;
            float delta = MathHelper.func_76142_g((float)(this.field_70177_z - this.previousServerRealRotation));
            this.previousServerRealRotation = this.field_70177_z;
            if (delta < -179.0f || delta > 179.0f) {
                this.field_70177_z += 180.0f;
                this.isServerInReverse = !this.isServerInReverse;
            }
            this.previousServerRealRotation = rotation;
            if (this.isServerInReverse) {
                rotation = this.serverInReverseSignPositive ? (rotation += 180.0f) : (rotation -= 180.0f);
            }
            this.serverRealRotation = rotation;
            double zDist = this.field_70161_v - this.field_70166_s;
            double xDist = this.field_70165_t - this.field_70169_q;
            float tempPitch2 = tempPitch = this.rollingServerPitch;
            if (Math.abs(zDist) > 0.02) {
                tempPitch = (float)(Math.atan((this.field_70163_u - this.field_70167_r) / zDist) * 57.29577951308232);
            } else if (Math.abs(xDist) > 0.02) {
                tempPitch = (float)(Math.atan((this.field_70163_u - this.field_70167_r) / xDist) * 57.29577951308232);
            }
            if (tempPitch2 < tempPitch && Math.abs(tempPitch2 - tempPitch) > 3.0f) {
                tempPitch2 += 3.0f;
            } else if (tempPitch2 > tempPitch && Math.abs(tempPitch2 - tempPitch) > 3.0f) {
                tempPitch2 -= 3.0f;
            } else if (tempPitch2 < tempPitch && (double)Math.abs(tempPitch2 - tempPitch) > 0.5) {
                tempPitch2 = (float)((double)tempPitch2 + 0.5);
            } else if (tempPitch2 > tempPitch && (double)Math.abs(tempPitch2 - tempPitch) > 0.5) {
                tempPitch2 = (float)((double)tempPitch2 - 0.5);
            }
            anglePitch = -tempPitch2;
            this.rollingServerPitch = tempPitch2;
        }
        if (this.field_70173_aa % 2 == 0) {
            this.shouldServerSetPosYOnClient = true;
        }
        if (this.shouldServerSetPosYOnClient) {
            Traincraft.rotationChannel.sendToAllAround((IMessage)new PacketRollingStockRotation(this, (int)(anglePitch * 60.0f)), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 300.0));
            this.shouldServerSetPosYOnClient = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.anglePitchClient = anglePitch * 60.0f;
        }
        this.list = this.field_70170_p.func_72839_b((Entity)this, EntityRollingStock.getCollisionHandler() != null ? EntityRollingStock.getCollisionHandler().getMinecartCollisionBox((EntityMinecart)this) : this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
        if (this.list != null && !this.list.isEmpty()) {
            for (Object obj : this.list) {
                Entity entity3 = (Entity)obj;
                if (entity3 != this.field_70153_n && entity3.func_70104_M() && entity3 instanceof EntityMinecart) {
                    entity3.func_70108_f((Entity)this);
                    continue;
                }
                if (entity3 == this.field_70153_n || !entity3.func_70104_M() || entity3 instanceof EntityMinecart) continue;
                this.func_70108_f(entity3);
            }
        }
        this.handleTrain();
        this.handleOverheating.HandleHeatLevel(this);
        this.linkhandler.handleStake(this, this.field_70121_D);
        this.collisionhandler.handleCollisions((Entity)this, this.field_70121_D);
        this.func_145775_I();
        MinecraftForge.EVENT_BUS.post((Event)new MinecartUpdateEvent((EntityMinecart)this, (float)i, (float)j, (float)k));
        ++this.numLaps;
        if (this instanceof Locomotive && this.Link1 == 0.0 && this.Link2 == 0.0 && this.numLaps > 700) {
            this.RollingStock.clear();
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            if (this.field_70153_n.field_70154_o == this) {
                this.field_70153_n.field_70154_o = null;
            }
            this.field_70153_n = null;
        }
        this.field_70180_af.func_75692_b(14, (Object)((int)(this.field_70159_w * 100.0)));
        this.field_70180_af.func_75692_b(21, (Object)((int)(this.field_70179_y * 100.0)));
        if (ConfigHandler.ENABLE_LOGGING && !this.field_70170_p.field_72995_K && this.field_70173_aa % 120 == 0) {
            ServerLogger.writeWagonToFolder(this);
        }
    }

    public void updateOnTrack(int i, int j, int k, Block l) {
        if (this.canUseRail() && BlockRailBase.func_150051_a((Block)l)) {
            int i1;
            Vec3 vec3d = this.func_514_g(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.meta = i1 = ((BlockRailBase)l).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
            this.field_70163_u = j;
            this.flag = false;
            this.flag1 = false;
            if (l == Blocks.field_150318_D) {
                this.flag = (this.field_70170_p.func_72805_g(i, j, k) & 8) != 0;
                boolean bl = this.flag1 = !this.flag;
                if (i1 == 8) {
                    i1 = 0;
                } else if (i1 == 9) {
                    i1 = 1;
                }
            }
            if (l == Blocks.field_150319_E) {
                this.field_70170_p.func_72921_c(i, j, k, this.meta | 8, 3);
                this.field_70170_p.func_147459_d(i, j, k, l);
                this.field_70170_p.func_147459_d(i, j - 1, k, l);
                this.field_70170_p.func_147458_c(i, j, k, i, j, k);
                this.field_70170_p.func_147464_a(i, j, k, l, l.func_149738_a(this.field_70170_p));
            }
            if (i1 >= 2 && i1 <= 5) {
                this.field_70163_u = j + 1;
            }
            this.adjustSlopeVelocities(i1);
            double d9 = matrix[i1][1][0] - matrix[i1][0][0];
            double d10 = matrix[i1][1][2] - matrix[i1][0][2];
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            if (this.field_70159_w * d9 + this.field_70179_y * d10 < 0.0) {
                d9 = -d9;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70159_w = d13 * d9 / d11;
            this.field_70179_y = d13 * d10 / d11;
            if (this.flag1 && this.shouldDoRailFunctions()) {
                if (Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.03) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                } else {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.0;
                    this.field_70179_y *= 0.5;
                }
            }
            double d17 = 0.0;
            double d18 = (double)i + 0.5 + (double)matrix[i1][0][0] * 0.5;
            double d19 = (double)k + 0.5 + (double)matrix[i1][0][2] * 0.5;
            double d20 = (double)i + 0.5 + (double)matrix[i1][1][0] * 0.5;
            double d21 = (double)k + 0.5 + (double)matrix[i1][1][2] * 0.5;
            d9 = d20 - d18;
            d10 = d21 - d19;
            if (d9 == 0.0) {
                this.field_70165_t = (double)i + 0.5;
                d17 = this.field_70161_v - (double)k;
            } else if (d10 == 0.0) {
                this.field_70161_v = (double)k + 0.5;
                d17 = this.field_70165_t - (double)i;
            } else {
                double d22 = this.field_70165_t - d18;
                double d24 = this.field_70161_v - d19;
                d17 = (d22 * d9 + d24 * d10) * 2.0;
                if (this.bogieLoco != null && !this.bogieLoco.isOnRail()) {
                    this.derailSpeed = 0.0;
                    this.unLink();
                }
                if (this instanceof Locomotive && d13 > this.derailSpeed && i1 >= 6) {
                    if (d9 > 0.0 && d10 < 0.0) {
                        d10 = 0.0;
                        d9 += 2.0;
                    } else if (d9 < 0.0 && d10 > 0.0) {
                        d9 = 0.0;
                        d10 += 2.0;
                    } else if (d10 < 0.0 && d9 < 0.0) {
                        d10 -= 2.0;
                        d9 = 0.0;
                    } else if (d9 > 0.0 && d10 > 0.0) {
                        d10 += 2.0;
                        d9 = 0.0;
                    }
                    if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.field_70153_n instanceof EntityPlayer) {
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.field_70153_n).getDisplayName() + "derailed" + this.trainOwner + "'s locomotive"));
                    }
                }
            }
            this.field_70165_t = d18 + d9 * d17;
            this.field_70161_v = d19 + d10 * d17;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M + 0.35, this.field_70161_v);
            this.moveMinecartOnRail(i, j, k, 0.0);
            if (matrix[i1][0][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - i == matrix[i1][0][0] && MathHelper.func_76128_c((double)this.field_70161_v) - k == matrix[i1][0][2]) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)matrix[i1][0][1], this.field_70161_v);
            } else if (matrix[i1][1][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - i == matrix[i1][1][0] && MathHelper.func_76128_c((double)this.field_70161_v) - k == matrix[i1][1][2]) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)matrix[i1][1][1], this.field_70161_v);
            }
            this.applyDragAndPushForces();
            Vec3 vec3d1 = this.func_514_g(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (vec3d1 != null && vec3d != null) {
                double d14;
                double d28 = (vec3d.field_72448_b - vec3d1.field_72448_b) * 0.05;
                if (this instanceof Locomotive) {
                    d28 = 0.0;
                }
                if ((d14 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.0) {
                    this.field_70159_w = this.field_70159_w / d14 * (d14 + d28);
                    this.field_70179_y = this.field_70179_y / d14 * (d14 + d28);
                }
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M - 0.8, this.field_70161_v);
            }
            int k1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int l1 = MathHelper.func_76128_c((double)this.field_70161_v);
            if (k1 != i || l1 != k) {
                double d15 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                this.field_70159_w = d15 * (double)(k1 - i);
                this.field_70179_y = d15 * (double)(l1 - k);
            }
            if (this.shouldDoRailFunctions()) {
                ((BlockRailBase)l).onMinecartPass(this.field_70170_p, (EntityMinecart)this, i, j, k);
            }
            if (this.flag && this.shouldDoRailFunctions()) {
                double d31 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (d31 > 0.01) {
                    this.field_70159_w += this.field_70159_w / d31 * 0.06;
                    this.field_70179_y += this.field_70179_y / d31 * 0.06;
                } else if (i1 == 1) {
                    if (this.field_70170_p.func_147445_c(i - 1, j, k, false)) {
                        this.field_70159_w = 0.02;
                    } else if (this.field_70170_p.func_147445_c(i + 1, j, k, false)) {
                        this.field_70159_w = -0.02;
                    }
                } else if (i1 == 0) {
                    if (this.field_70170_p.func_147445_c(i, j, k - 1, false)) {
                        this.field_70179_y = 0.02;
                    } else if (this.field_70170_p.func_147445_c(i, j, k + 1, false)) {
                        this.field_70179_y = -0.02;
                    }
                }
            }
        } else if (l == BlockIDs.tcRail.block) {
            this.limitSpeedOnTCRail();
            TileTCRail tile = (TileTCRail)this.field_70170_p.func_147438_o(i, j, k);
            if (ItemTCRail.isTCTurnTrack(tile)) {
                if (this.bogieLoco != null && !this.bogieLoco.isOnRail()) {
                    this.derailSpeed = 0.0;
                }
                if (this.derailSpeed == 0.0) {
                    this.unLink();
                    this.moveOnTCStraight(i, j, k, tile.field_145851_c, tile.field_145849_e, (tile.func_145832_p() + 1) % 4);
                } else {
                    int meta = tile.func_145832_p();
                    if (this.shouldIgnoreSwitch(tile, i, j, k, meta)) {
                        this.moveOnTCStraight(i, j, k, tile.field_145851_c, tile.field_145849_e, meta);
                    } else if (ItemTCRail.isTCTurnTrack(tile)) {
                        this.moveOnTC90TurnRail(i, j, k, tile.r, tile.cx, tile.cz);
                    }
                }
            }
            if (ItemTCRail.isTCStraightTrack(tile)) {
                this.moveOnTCStraight(i, j, k, tile.field_145851_c, tile.field_145849_e, tile.func_145832_p());
            }
            if (ItemTCRail.isTCSlopeTrack(tile)) {
                this.moveOnTCSlope(j, tile.field_145851_c, tile.field_145849_e, tile.slopeAngle, tile.func_145832_p());
            }
            if (ItemTCRail.isTCTwoWaysCrossingTrack(tile)) {
                this.moveOnTCTwoWaysCrossing(i, j, k, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145832_p());
            }
        } else if (l == BlockIDs.tcRailGag.block) {
            this.limitSpeedOnTCRail();
            TileTCRailGag tileGag = (TileTCRailGag)this.field_70170_p.func_147438_o(i, j, k);
            if (tileGag != null && this.field_70170_p.func_147438_o(tileGag.originX, tileGag.originY, tileGag.originZ) instanceof TileTCRail) {
                TileTCRail tile = (TileTCRail)this.field_70170_p.func_147438_o(tileGag.originX, tileGag.originY, tileGag.originZ);
                if (ItemTCRail.isTCTurnTrack(tile)) {
                    this.moveOnTC90TurnRail(i, j, k, tile.r, tile.cx, tile.cz);
                }
                if (ItemTCRail.isTCStraightTrack(tile)) {
                    this.moveOnTCStraight(i, j, k, tile.field_145851_c, tile.field_145849_e, tile.func_145832_p());
                }
                if (ItemTCRail.isTCSlopeTrack(tile)) {
                    this.moveOnTCSlope(j, tile.field_145851_c, tile.field_145849_e, tile.slopeAngle, tile.func_145832_p());
                }
            }
        } else {
            super.func_70071_h_();
        }
    }

    private boolean shouldIgnoreSwitch(TileTCRail tile, int i, int j, int k, int meta) {
        if (tile != null && (tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_RIGHT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_LEFT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.LARGE_LEFT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.LARGE_RIGHT_TURN.getLabel())) && tile.canTypeBeModifiedBySwitch) {
            if (meta == 2 && this.field_70179_y > 0.0 && Math.abs(this.field_70159_w) < 0.01) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i, j, k + 1);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 0 && this.field_70179_y < 0.0 && Math.abs(this.field_70159_w) < 0.01) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i, j, k - 1);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 1 && Math.abs(this.field_70179_y) < 0.01 && this.field_70159_w > 0.0) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i + 1, j, k);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 3 && Math.abs(this.field_70179_y) < 0.01 && this.field_70159_w < 0.0) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i - 1, j, k);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
        }
        return false;
    }

    private void moveOnTCStraight(int i, int j, int k, double cx, double cz, int meta) {
        List boxes;
        this.field_70163_u = j;
        if (meta == 2 || meta == 0) {
            this.norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.func_70107_b(cx + 0.5, this.field_70163_u + (double)this.field_70129_M + (double)this.field_70139_V + 0.5, this.field_70161_v);
            this.field_70159_w = 0.0;
            this.field_70179_y = Math.copySign(this.norm, this.field_70179_y);
            this.field_70121_D.func_72317_d(0.0, 0.0, Math.copySign(this.norm, this.field_70179_y));
            boxes = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D);
            for (Object b : boxes) {
                if (b instanceof BlockRailBase || b instanceof BlockTCRail || b instanceof BlockTCRailGag || b instanceof BlockAir) continue;
                return;
            }
            this.func_70107_b((this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) * 0.5, this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V - 0.5, (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) * 0.5);
        }
        if (meta == 1 || meta == 3) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M + (double)this.field_70139_V + 0.5, cz + 0.5);
            this.field_70159_w = Math.copySign(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y), this.field_70159_w);
            this.field_70179_y = 0.0;
            this.field_70121_D.func_72317_d(this.field_70159_w, 0.0, 0.0);
            boxes = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D);
            for (Object b : boxes) {
                if (b instanceof BlockRailBase || b instanceof BlockTCRail || b instanceof BlockTCRailGag || b instanceof BlockAir) continue;
                return;
            }
            this.func_70107_b((this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) * 0.5, this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V - 0.5, (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) * 0.5);
        }
    }

    private void moveOnTCSlope(int j, double cx, double cz, double slopeAngle, int meta) {
        this.field_70163_u = j;
        if (meta == 2 || meta == 0) {
            if (meta == 2) {
                cz += 1.0;
                if (!(this instanceof Locomotive) && !(this instanceof EntityTracksBuilder)) {
                    this.field_70179_y += this.field_70125_A < 90.0f ? 0.01 : -0.01;
                }
            } else if (!(this instanceof Locomotive) && !(this instanceof EntityTracksBuilder)) {
                this.field_70179_y += this.field_70125_A > 90.0f ? 0.01 : -0.01;
            }
            this.func_70107_b(cx + 0.5, Math.abs((double)j + Math.tan(slopeAngle * Math.abs(cz - this.field_70161_v)) + (double)this.field_70129_M - (double)this.field_70139_V + 0.1), this.field_70161_v + this.field_70179_y);
            this.field_70159_w = 0.0;
        } else if (meta == 1 || meta == 3) {
            if (meta == 1) {
                cx += 1.0;
                if (!(this instanceof Locomotive) && !(this instanceof EntityTracksBuilder)) {
                    this.field_70159_w += this.field_70125_A < 90.0f ? 0.01 : -0.01;
                }
            } else if (!(this instanceof Locomotive) && !(this instanceof EntityTracksBuilder)) {
                this.field_70159_w += this.field_70125_A > 90.0f ? 0.01 : -0.01;
            }
            this.func_70107_b(this.field_70165_t + this.field_70159_w, (double)j + Math.tan(slopeAngle * Math.abs(cx - this.field_70165_t)) + (double)this.field_70129_M - (double)this.field_70139_V + 0.1, cz + 0.5);
            this.field_70179_y = 0.0;
        }
        this.func_70043_V();
    }

    protected void moveOnTC90TurnRail(int i, int j, int k, double r, double cx, double cz) {
        this.field_70163_u = j;
        double cpx = this.field_70165_t - cx;
        double cpz = this.field_70161_v - cz;
        double cp_norm = Math.sqrt(cpx * cpx + cpz * cpz);
        this.norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double vx2 = -(cpz / cp_norm) * this.norm;
        double vz2 = cpx / cp_norm * this.norm;
        double px2_cx = this.field_70165_t + this.field_70159_w * 2.0 - cx;
        double pz2_cz = this.field_70161_v + this.field_70179_y * 2.0 - cz;
        this.norm = Math.sqrt(px2_cx * px2_cx + pz2_cz * pz2_cz);
        vx2 = Math.copySign(vx2, cx + px2_cx / this.norm * r - this.field_70165_t);
        vz2 = Math.copySign(vz2, cz + pz2_cz / this.norm * r - this.field_70161_v);
        this.func_70107_b(cx + cpx / cp_norm * r, this.field_70163_u + (double)this.field_70129_M - (double)this.field_70139_V, cz + cpz / cp_norm * r);
        this.func_70091_d(vx2, 0.0, vz2);
        this.field_70159_w = vx2;
        this.field_70179_y = vz2;
    }

    protected void moveOnTCTwoWaysCrossing(int i, int j, int k, double cx, double cy, double cz, int meta) {
        this.field_70163_u = (double)j + 0.1;
        if (!(this instanceof Locomotive)) {
            int l = MathHelper.func_76128_c((double)((double)(this.serverRealRotation * 4.0f / 360.0f) + 0.5)) & 3;
            if (l == 2 || l == 0) {
                this.func_70091_d(this.field_70159_w, 0.0, 0.0);
            } else if (l == 1 || l == 3) {
                this.func_70091_d(0.0, 0.0, this.field_70179_y);
            }
        } else {
            int l = MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (l == 2 || l == 0) {
                this.func_70091_d(this.field_70159_w, 0.0, 0.0);
            } else if (l == 1 || l == 3) {
                this.func_70091_d(0.0, 0.0, this.field_70179_y);
            }
        }
    }

    public void limitSpeedOnTCRail() {
        this.railMaxSpeed = 3.0f;
        this.maxSpeed = Math.min(this.railMaxSpeed, this.getMaxCartSpeedOnRail());
        this.maxSpeed = SpeedHandler.handleSpeed(this.railMaxSpeed, this.maxSpeed, (Entity)this);
        if (this.speedLimiter != 0.0 && this.speedWasSet) {
            this.adjustSpeed(this.maxSpeed, this.speedLimiter);
        }
        this.field_70159_w *= 0.9;
        this.field_70179_y *= 0.9;
        if (this.field_70159_w < (double)(-this.maxSpeed)) {
            this.field_70159_w = -this.maxSpeed;
        }
        if (this.field_70159_w > (double)this.maxSpeed) {
            this.field_70159_w = this.maxSpeed;
        }
        if (this.field_70179_y < (double)(-this.maxSpeed)) {
            this.field_70179_y = -this.maxSpeed;
        }
        if (this.field_70179_y > (double)this.maxSpeed) {
            this.field_70179_y = this.maxSpeed;
        }
    }

    protected void moveMinecartOffRail(int i, int j, int k) {
        this.field_70181_x -= (double)0.04f;
        double d2 = this.getMaxCartSpeedOnRail();
        if (!this.field_70122_E) {
            d2 = this.getMaxSpeedAirLateral();
        }
        if (this.field_70159_w < -d2) {
            this.field_70159_w = -d2;
        }
        if (this.field_70159_w > d2) {
            this.field_70159_w = d2;
        }
        if (this.field_70179_y < -d2) {
            this.field_70179_y = -d2;
        }
        if (this.field_70179_y > d2) {
            this.field_70179_y = d2;
        }
        double moveY = this.field_70181_x;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.field_70181_x > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.field_70159_w) < (double)0.3f && Math.abs(this.field_70179_y) < (double)0.3f) {
                this.field_70181_x = moveY = (double)0.15f;
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, moveY, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= this.getDragAir();
            this.field_70181_x *= this.getDragAir();
            this.field_70179_y *= this.getDragAir();
        }
    }

    public Vec3 func_514_g(double d, double d1, double d2) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)d);
        if (TraincraftUtil.isRailBlockAt(this.field_70170_p, i, (j = MathHelper.func_76128_c((double)d1)) - 1, k = MathHelper.func_76128_c((double)d2))) {
            --j;
        } else if (TraincraftUtil.isRailBlockAt(this.field_70170_p, i, j + 1, k)) {
            ++j;
        }
        Block l = this.field_70170_p.func_147439_a(i, j, k);
        if (BlockRailBase.func_150051_a((Block)l)) {
            int i1 = ((BlockRailBase)l).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
            if (l == Blocks.field_150318_D) {
                if (i1 == 8) {
                    i1 = 0;
                }
                if (i1 == 9) {
                    i1 = 1;
                }
            }
            int[][] ai = matrix[i1];
            double d3 = 0.0;
            double d4 = (double)i + 0.5 + (double)ai[0][0] * 0.5;
            double d5 = (double)j + 0.5 + (double)ai[0][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)ai[0][2] * 0.5;
            double d7 = (double)i + 0.5 + (double)ai[1][0] * 0.5;
            double d8 = (double)j + 0.5 + (double)ai[1][1] * 0.5;
            double d9 = (double)k + 0.5 + (double)ai[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                d3 = d2 - (double)k;
            } else if (d12 == 0.0) {
                d3 = d - (double)i;
            } else {
                double d13 = d - d4;
                double d14 = d2 - d6;
                d3 = (d13 * d10 + d14 * d12) * 2.0;
            }
            d1 = d5 + d11 * d3;
            if (d11 < 0.0) {
                d1 += 1.0;
            } else if (d11 > 0.0) {
                d1 += 0.5;
            }
            return Vec3.func_72443_a((double)(d4 + d10 * d3), (double)d1, (double)(d6 + d12 * d3));
        }
        return null;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("speedLimiter", this.speedLimiter);
        nbttagcompound.func_74776_a("serverRealRotation", this.serverRealRotation);
        nbttagcompound.func_74776_a("yawRotation", this.field_70177_z);
        nbttagcompound.func_74757_a("firstLoad", this.firstLoad);
        nbttagcompound.func_74776_a("rotation", this.rotation);
        nbttagcompound.func_74757_a("brake", this.isBraking);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.speedLimiter = nbttagcompound.func_74769_h("speedLimiter");
        this.serverRealRotation = nbttagcompound.func_74760_g("serverRealRotation");
        if (nbttagcompound.func_74764_b("yawRotation")) {
            this.field_70177_z = nbttagcompound.func_74760_g("yawRotation");
        }
        this.firstLoad = nbttagcompound.func_74767_n("firstLoad");
        this.rotation = nbttagcompound.func_74760_g("rotation");
        this.isBraking = nbttagcompound.func_74767_n("brake");
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (super.func_130002_c(entityplayer)) {
            return true;
        }
        if (entityplayer.field_70154_o == this) {
            return false;
        }
        if (this.lockThisCart(entityplayer.field_71071_by.func_70448_g(), entityplayer)) {
            return true;
        }
        this.playerEntity = entityplayer;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (this.getTrainLockedFromPacket()) {
            if (!this.playerEntity.getDisplayName().toLowerCase().equals(this.trainOwner.toLowerCase()) && !this.canBeRiddenWhileLocked(this)) {
                if (!this.field_70170_p.field_72995_K) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Train is locked"));
                }
                return true;
            }
            if (!this.playerEntity.getDisplayName().toLowerCase().equals(this.trainOwner.toLowerCase()) && entityplayer.field_71071_by.func_70448_g() != null && entityplayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemDye && this instanceof Locomotive) {
                if (!this.field_70170_p.field_72995_K) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Train is locked"));
                }
                return true;
            }
        }
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemWrench && this instanceof Locomotive && entityplayer.func_70093_af() && !this.field_70170_p.field_72995_K) {
            this.destination = "";
            entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Destination reset"));
            return true;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, entityplayer))) {
            return true;
        }
        if (itemstack != null && itemstack.func_77942_o() && EntityRollingStock.getTicketDestination(itemstack) != null && EntityRollingStock.getTicketDestination(itemstack).length() > 0) {
            this.setDestination(itemstack);
            ItemStack ticket = GameRegistry.findItemStack((String)"Railcraft", (String)"railcraft.routing.ticket", (int)1);
            if (ticket != null && ticket.func_77973_b() != null && itemstack.func_77973_b() == ticket.func_77973_b() && --itemstack.field_77994_a == 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemDye) {
            if (this.acceptedColors != null && this.acceptedColors.size() > 0) {
                for (int i = 0; i < this.acceptedColors.size(); ++i) {
                    if (itemstack.func_77960_j() != ((Byte)this.acceptedColors.get(i)).byteValue()) continue;
                    this.setColor(itemstack.func_77960_j());
                    --itemstack.field_77994_a;
                    return true;
                }
                if (this.field_70170_p.field_72995_K && ConfigHandler.SHOW_POSSIBLE_COLORS) {
                    String concatColors = ": ";
                    for (int t = 0; t < this.acceptedColors.size(); ++t) {
                        concatColors = concatColors.concat(EntityRollingStock.getColorAsString(((Byte)this.acceptedColors.get(t)).byteValue()) + ", ");
                    }
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Possible colors" + concatColors));
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("To paint, click me with the right dye"));
                    return true;
                }
            } else if (this.acceptedColors != null && this.acceptedColors.size() == 0) {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentText("No other colors available"));
            }
        } else if (this.trainsOnClick.onClickWithStake(this, itemstack, this.playerEntity, this.field_70170_p)) {
            return true;
        }
        return this.field_70170_p.field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    private void soundUpdater() {
        if (FMLClientHandler.instance().getClient() != null) {
            this.theSoundManager = FMLClientHandler.instance().getClient().func_147118_V();
        }
        if (FMLClientHandler.instance().getClient() != null && this.theSoundManager != null && FMLClientHandler.instance().getClient().field_71439_g != null && this.sndUpdater != null) {
            this.sndUpdater.update(FMLClientHandler.instance().getClient().func_147118_V(), this, (EntityPlayerSP)FMLClientHandler.instance().getClient().field_71439_g);
        }
    }

    public void func_70108_f(Entity par1Entity) {
        if (this.bogieLoco == null) {
            return;
        }
        if (par1Entity == this) {
            return;
        }
        if (par1Entity instanceof EntityBogie && ((EntityBogie)par1Entity).entityMainTrainID == this.uniqueID) {
            return;
        }
        if (par1Entity == this.bogieLoco) {
            return;
        }
        if (par1Entity instanceof EntityRollingStock && ((EntityRollingStock)par1Entity).bogieLoco != null && par1Entity == ((EntityRollingStock)par1Entity).bogieLoco) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new MinecartCollisionEvent((EntityMinecart)this, par1Entity));
        if (EntityRollingStock.getCollisionHandler() != null) {
            EntityRollingStock.getCollisionHandler().onEntityCollision((EntityMinecart)this, par1Entity);
            return;
        }
        if (!this.field_70170_p.field_72995_K && par1Entity != this.field_70153_n) {
            double d0 = par1Entity.field_70165_t - this.field_70165_t;
            double d1 = par1Entity.field_70161_v - this.field_70161_v;
            double[] distancesX = new double[4];
            double[] distancesZ = new double[4];
            double[] euclidian = new double[4];
            if (par1Entity instanceof EntityRollingStock) {
                EntityRollingStock entity = (EntityRollingStock)par1Entity;
                if (((EntityRollingStock)par1Entity).bogieLoco != null || this.bogieLoco != null) {
                    if (((EntityRollingStock)par1Entity).bogieLoco != null && this.bogieLoco == null) {
                        distancesX[0] = entity.field_70165_t - this.field_70165_t;
                        distancesZ[0] = entity.field_70161_v - this.field_70161_v;
                        euclidian[0] = MathHelper.func_76133_a((double)(distancesX[0] * distancesX[0] + distancesZ[0] * distancesZ[0]));
                        distancesX[1] = entity.bogieLoco.field_70165_t - this.field_70165_t;
                        distancesZ[1] = entity.bogieLoco.field_70161_v - this.field_70161_v;
                        euclidian[1] = MathHelper.func_76133_a((double)(distancesX[1] * distancesX[1] + distancesZ[1] * distancesZ[1]));
                        distancesX[2] = 100.0;
                        distancesZ[2] = 100.0;
                        euclidian[2] = MathHelper.func_76133_a((double)(distancesX[2] * distancesX[2] + distancesZ[2] * distancesZ[2]));
                        distancesX[3] = 100.0;
                        distancesZ[3] = 100.0;
                        euclidian[3] = MathHelper.func_76133_a((double)(distancesX[3] * distancesX[3] + distancesZ[3] * distancesZ[3]));
                    } else if (((EntityRollingStock)par1Entity).bogieLoco == null && this.bogieLoco != null) {
                        distancesX[0] = entity.field_70165_t - this.field_70165_t;
                        distancesZ[0] = entity.field_70161_v - this.field_70161_v;
                        euclidian[0] = MathHelper.func_76133_a((double)(distancesX[0] * distancesX[0] + distancesZ[0] * distancesZ[0]));
                        distancesX[1] = entity.field_70165_t - this.bogieLoco.field_70165_t;
                        distancesZ[1] = entity.field_70161_v - this.bogieLoco.field_70161_v;
                        euclidian[1] = MathHelper.func_76133_a((double)(distancesX[1] * distancesX[1] + distancesZ[1] * distancesZ[1]));
                        distancesX[2] = 100.0;
                        distancesZ[2] = 100.0;
                        euclidian[2] = MathHelper.func_76133_a((double)(distancesX[2] * distancesX[2] + distancesZ[2] * distancesZ[2]));
                        distancesX[3] = 100.0;
                        distancesZ[3] = 100.0;
                        euclidian[3] = MathHelper.func_76133_a((double)(distancesX[3] * distancesX[3] + distancesZ[3] * distancesZ[3]));
                    } else {
                        distancesX[0] = entity.field_70165_t - this.field_70165_t;
                        distancesZ[0] = entity.field_70161_v - this.field_70161_v;
                        euclidian[0] = MathHelper.func_76133_a((double)(distancesX[0] * distancesX[0] + distancesZ[0] * distancesZ[0]));
                        distancesX[1] = entity.bogieLoco.field_70165_t - this.field_70165_t;
                        distancesZ[1] = entity.bogieLoco.field_70161_v - this.field_70161_v;
                        euclidian[1] = MathHelper.func_76133_a((double)(distancesX[1] * distancesX[1] + distancesZ[1] * distancesZ[1]));
                        distancesX[2] = entity.field_70165_t - this.bogieLoco.field_70165_t;
                        distancesZ[2] = entity.field_70161_v - this.bogieLoco.field_70161_v;
                        euclidian[2] = MathHelper.func_76133_a((double)(distancesX[2] * distancesX[2] + distancesZ[2] * distancesZ[2]));
                        distancesX[3] = entity.bogieLoco.field_70165_t - this.bogieLoco.field_70165_t;
                        distancesZ[3] = entity.bogieLoco.field_70161_v - this.bogieLoco.field_70161_v;
                        euclidian[3] = MathHelper.func_76133_a((double)(distancesX[3] * distancesX[3] + distancesZ[3] * distancesZ[3]));
                    }
                    double min = euclidian[0];
                    int minIndex = 0;
                    for (int k = 0; k < euclidian.length; ++k) {
                        if (!(Math.abs(euclidian[k]) < Math.abs(min))) continue;
                        min = euclidian[k];
                        minIndex = k;
                    }
                    d0 = distancesX[minIndex];
                    d1 = distancesZ[minIndex];
                }
            }
            double d2 = d0 * d0 + d1 * d1;
            if (par1Entity instanceof AbstractTrains && d2 <= (double)((AbstractTrains)par1Entity).getLinkageDistance((EntityMinecart)par1Entity) * 0.7 && d2 >= (double)1.0E-4f || par1Entity instanceof EntityBogie && ((EntityBogie)par1Entity).entityMainTrain != null && d2 <= (double)((EntityBogie)par1Entity).entityMainTrain.getLinkageDistance((EntityMinecart)par1Entity) * 0.7 && d2 >= (double)1.0E-4f || !(par1Entity instanceof AbstractTrains) && d2 >= (double)1.0E-4f) {
                d2 = MathHelper.func_76133_a((double)d2);
                if (d0 != 0.0) {
                    d0 /= d2;
                } else {
                    d2 = 0.0;
                }
                if (d1 != 0.0) {
                    d1 /= d2;
                } else {
                    d2 = 0.0;
                }
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                d0 *= d2;
                d1 *= d2;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                d0 *= 0.5;
                d1 *= 0.5;
                if (par1Entity instanceof EntityMinecart && !this.isAttached) {
                    Vec3 vec31 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b();
                    if (Math.abs(Vec3.func_72443_a((double)(par1Entity.field_70165_t - this.field_70165_t), (double)0.0, (double)(par1Entity.field_70161_v - this.field_70161_v)).func_72432_b().func_72430_b(vec31)) < (double)0.8f) {
                        return;
                    }
                    double d9 = par1Entity.field_70159_w + this.field_70159_w;
                    double d8 = par1Entity.field_70179_y + this.field_70179_y;
                    if (par1Entity instanceof Locomotive && !this.isPoweredCart() || ((EntityMinecart)par1Entity).isPoweredCart() && !this.isPoweredCart()) {
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g(par1Entity.field_70159_w - d0, 0.0, par1Entity.field_70179_y - d1);
                        if (!(par1Entity instanceof Locomotive)) {
                            par1Entity.field_70159_w *= (double)0.95f;
                            par1Entity.field_70179_y *= (double)0.95f;
                        }
                    } else if (!(par1Entity instanceof Locomotive) && this.isPoweredCart() || !((EntityMinecart)par1Entity).isPoweredCart() && this.isPoweredCart()) {
                        if (par1Entity instanceof EntityBogie && ((EntityBogie)par1Entity).entityMainTrain != null) {
                            this.field_70159_w *= 0.2;
                            this.field_70179_y *= 0.2;
                            this.func_70024_g(this.field_70159_w + d0 * 3.0, 0.0, this.field_70179_y + d1 * 3.0);
                            if (this instanceof Locomotive && ((EntityBogie)par1Entity).entityMainTrain instanceof Locomotive) {
                                this.field_70159_w *= 0.0;
                                this.field_70179_y *= 0.0;
                                ((EntityBogie)par1Entity).entityMainTrain.field_70159_w *= 0.0;
                                ((EntityBogie)par1Entity).entityMainTrain.field_70179_y *= 0.0;
                            }
                        } else {
                            par1Entity.field_70159_w *= (double)0.2f;
                            par1Entity.field_70179_y *= (double)0.2f;
                            par1Entity.func_70024_g(this.field_70159_w + d0, 0.0, this.field_70179_y + d1);
                        }
                        if (!(this instanceof Locomotive)) {
                            this.field_70159_w *= (double)0.95f;
                            this.field_70179_y *= (double)0.95f;
                        }
                    } else {
                        d9 *= 0.4;
                        d8 *= 0.4;
                        if (par1Entity instanceof EntityBogie || par1Entity instanceof Locomotive) {
                            d9 *= -1.0;
                            d8 *= -1.0;
                        }
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g(d9 - d0, 0.0, d8 - d1);
                        if (par1Entity instanceof EntityBogie) {
                            d9 *= 0.333333333333;
                            d8 *= 0.333333333333;
                        }
                        par1Entity.field_70159_w *= (double)0.2f;
                        par1Entity.field_70179_y *= (double)0.2f;
                        par1Entity.func_70024_g(d9 + d0, 0.0, d8 + d1);
                    }
                } else {
                    if (!(par1Entity instanceof EntityItem || par1Entity instanceof EntityPlayer && this instanceof Locomotive || par1Entity instanceof EntityCreature || par1Entity instanceof EntityBogie)) {
                        this.func_70024_g(-d0 * 2.0, 0.0, -d1 * 2.0);
                    } else if (par1Entity instanceof EntityBogie) {
                        this.func_70024_g(-d0, 0.0, -d1);
                    }
                    par1Entity.func_70024_g(d0 * 2.0 * 100.0, 0.0, d1 * 2.0 * 100.0);
                    if (par1Entity instanceof EntityPlayer) {
                        MovingObjectPosition movingobjectposition = new MovingObjectPosition(par1Entity);
                        if (movingobjectposition.field_72308_g != null) {
                            par1Entity.field_70133_I = true;
                        }
                    }
                    if (par1Entity instanceof EntityLiving) {
                        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * 60.0f;
                        if ((double)f1 * 3.6 < 35.0) {
                            return;
                        }
                        int j1 = (int)Math.ceil(f1 * (float)(par1Entity instanceof EntityCreeper ? 100 : 1));
                        par1Entity.func_70097_a((DamageSource)TrainsDamageSource.ranOver, (float)j1);
                    }
                }
            }
        }
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        return true;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return this.getOptimalDistance(cart) + 2.4f;
    }

    @Override
    public abstract float getOptimalDistance(EntityMinecart var1);

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return true;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
        this.linked = true;
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
        this.linked = false;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    public ItemStack getCartItem() {
        return this.getItemsDropped().get(0);
    }

    public boolean isPoweredCart() {
        return this.isLocomotive();
    }

    public boolean isStorageCart() {
        return this.isFreightCart();
    }

    public boolean canBeRidden() {
        return this.isLocomotive() || this.isPassenger() || this.isWorkCart();
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    protected void applyDragAndPushForces() {
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    public double getDragAir() {
        return 0.98;
    }

    public void moveMinecartOnRail(int i, int j, int k, double d) {
        Block id = this.field_70170_p.func_147439_a(i, j, k);
        if (!BlockRailBase.func_150051_a((Block)id)) {
            return;
        }
        this.railMaxSpeed = ((BlockRailBase)id).getRailMaxSpeed(this.field_70170_p, (EntityMinecart)this, i, j, k);
        this.maxSpeed = Math.max(this.railMaxSpeed, this.getMaxCartSpeedOnRail());
        this.maxSpeed = SpeedHandler.handleSpeed(this.railMaxSpeed, this.maxSpeed, (Entity)this);
        if (this.speedLimiter != 0.0 && this.speedWasSet) {
            this.adjustSpeed(this.maxSpeed, this.speedLimiter);
        }
        if (!this.isLocomotive()) {
            this.field_70159_w *= 0.99;
            this.field_70179_y *= 0.99;
        } else {
            this.field_70159_w *= 1.0;
            this.field_70179_y *= 1.0;
        }
        if (this.field_70159_w < (double)(-this.maxSpeed)) {
            this.field_70159_w = -this.maxSpeed;
        }
        if (this.field_70159_w > (double)this.maxSpeed) {
            this.field_70159_w = this.maxSpeed;
        }
        if (this.field_70179_y < (double)(-this.maxSpeed)) {
            this.field_70179_y = -this.maxSpeed;
        }
        if (this.field_70179_y > (double)this.maxSpeed) {
            this.field_70179_y = this.maxSpeed;
        }
        this.func_70091_d(this.field_70159_w, 0.0, this.field_70179_y);
    }

    public void adjustSpeed(float maxSpeed, double limiter) {
        float targetSpeed = (float)((double)maxSpeed * limiter);
        float targetSpeedX = (float)Math.copySign((double)targetSpeed, this.field_70159_w);
        float targetSpeedZ = (float)Math.copySign((double)targetSpeed, this.field_70179_y);
        if (this.field_70159_w > (double)targetSpeedX && this.field_70159_w != 0.0) {
            this.field_70159_w -= 0.01;
        }
        if (this.field_70179_y > (double)targetSpeedZ && this.field_70179_y != 0.0) {
            this.field_70179_y -= 0.01;
        }
        if (this.field_70159_w < (double)targetSpeedX && this.field_70159_w != 0.0) {
            this.field_70159_w += 0.01;
        }
        if (this.field_70179_y < (double)targetSpeedZ && this.field_70179_y != 0.0) {
            this.field_70179_y += 0.01;
        }
        if (Math.abs(this.field_70159_w) < (double)Math.abs(targetSpeedX) + 0.01 && Math.abs(this.field_70159_w) > (double)Math.abs(targetSpeedX) - 0.01) {
            this.speedWasSet = false;
        }
        if (Math.abs(this.field_70179_y) < (double)Math.abs(targetSpeedZ) + 0.01 && Math.abs(this.field_70179_y) > (double)Math.abs(targetSpeedZ) - 0.01) {
            this.speedWasSet = false;
        }
    }

    protected void adjustSlopeVelocities(int i1) {
        if (this instanceof Locomotive) {
            return;
        }
        double d4 = -0.002;
        if (i1 == 2) {
            this.field_70159_w -= d4;
        } else if (i1 == 3) {
            this.field_70159_w += d4;
        } else if (i1 == 4) {
            this.field_70179_y += d4;
        } else if (i1 == 5) {
            this.field_70179_y -= d4;
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 300.0;
    }

    public float getMaxCartSpeedOnRail() {
        return this.maxSpeed;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    @Override
    public boolean canOverheat() {
        return false;
    }

    @Override
    public int getOverheatTime() {
        return 0;
    }

    public int getAverageOverheat() {
        return (this.getOverheatTime() + 30) / 2;
    }

    public void setOverheatLevel(int overheatLevel) {
        this.overheatLevel = overheatLevel;
        this.field_70180_af.func_75692_b(20, (Object)overheatLevel);
    }

    public int getOverheatLevel() {
        return this.field_70180_af.func_75679_c(20);
    }

    public double convertSpeed(Locomotive entity) {
        double speed = entity.getCustomSpeed();
        speed = ConfigHandler.REAL_TRAIN_SPEED ? (speed /= 2.0) : (speed /= 6.0);
        return speed /= 10.0;
    }

    public int getMotionXClient() {
        return this.field_70180_af.func_75679_c(14);
    }

    public int getMotionZClient() {
        return this.field_70180_af.func_75679_c(21);
    }

    protected void func_145775_I() {
        int var6;
        int var5;
        int var4;
        int var3;
        int var2;
        int var1 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72340_a + 0.001));
        if (this.field_70170_p.func_72904_c(var1, var2 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72338_b + 0.001)), var3 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72339_c + 0.001)), var4 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72336_d - 0.001)), var5 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72337_e - 0.001)), var6 = MathHelper.func_76128_c((double)(this.boundingBoxSmall.field_72334_f - 0.001)))) {
            for (int var7 = var1; var7 <= var4; ++var7) {
                for (int var8 = var2; var8 <= var5; ++var8) {
                    for (int var9 = var3; var9 <= var6; ++var9) {
                        Block var10 = this.field_70170_p.func_147439_a(var7, var8, var9);
                        if (var10 == null) continue;
                        var10.func_149670_a(this.field_70170_p, var7, var8, var9, (Entity)this);
                    }
                }
            }
        }
    }

    private void setBoundingBoxSmall(double par1, double par3, double par5, float width, float height) {
        float var7 = width * 0.5f;
        this.boundingBoxSmall.func_72324_b(par1 - (double)var7, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - (double)var7, par1 + (double)var7, par3 - (double)this.field_70129_M + (double)this.field_70139_V + (double)height, par5 + (double)var7);
    }

    public float getYaw() {
        return this.field_70177_z;
    }

    public float getPitch() {
        return this.field_70125_A;
    }

    public int func_94087_l() {
        return 0;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EnumTrains trains : EnumTrains.values()) {
            if (!trains.getEntityClass().equals(this.getClass())) continue;
            items.add(new ItemStack(trains.getItem()));
            return items;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 renderY(double par1, double par3, double par5, double par7) {
        int i1;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)par1);
        if (this.field_70170_p.func_147439_a(i, (j = MathHelper.func_76128_c((double)par3)) - 1, k = MathHelper.func_76128_c((double)par5)) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j - 1, k) == BlockIDs.tcRailGag.block) {
            --j;
        } else if (this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRailGag.block) {
            ++j;
        }
        Block l = this.field_70170_p.func_147439_a(i, j, k);
        if (l == BlockIDs.tcRail.block || l == BlockIDs.tcRailGag.block) {
            i1 = this.field_70170_p.func_72805_g(i, j, k);
            if (i1 == 2) {
                i1 = 0;
            } else if (i1 == 3) {
                i1 = 1;
            }
        } else {
            return null;
        }
        if (l != BlockIDs.tcRail.block && l != BlockIDs.tcRailGag.block) {
            par3 = j;
            if (i1 >= 2 && i1 <= 5) {
                par3 = j + 1;
            }
        } else {
            TileEntity tileOrigin;
            TileEntity tile = this.field_70170_p.func_147438_o(i, j, k);
            if (tile instanceof TileTCRail) {
                if (((TileTCRail)tile).getType() != null && !ItemTCRail.isTCSlopeTrack((TileTCRail)tile)) {
                    par3 = j;
                }
            } else if (tile instanceof TileTCRailGag && (tileOrigin = this.field_70170_p.func_147438_o(((TileTCRailGag)tile).originX, ((TileTCRailGag)tile).originY, ((TileTCRailGag)tile).originZ)) instanceof TileTCRail && ((TileTCRail)tileOrigin).getType() != null && !ItemTCRail.isTCSlopeTrack((TileTCRail)tileOrigin)) {
                par3 = j;
            }
        }
        double d4 = matrix[i1][1][0] - matrix[i1][0][0];
        double d5 = matrix[i1][1][2] - matrix[i1][0][2];
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        par1 += (d4 /= d6) * par7;
        par5 += (d5 /= d6) * par7;
        if (l != BlockIDs.tcRail.block && l != BlockIDs.tcRailGag.block) {
            if (matrix[i1][0][1] != 0 && MathHelper.func_76128_c((double)par1) - i == matrix[i1][0][0] && MathHelper.func_76128_c((double)par5) - k == matrix[i1][0][2]) {
                par3 += (double)matrix[i1][0][1];
            } else if (matrix[i1][1][1] != 0 && MathHelper.func_76128_c((double)par1) - i == matrix[i1][1][0] && MathHelper.func_76128_c((double)par5) - k == matrix[i1][1][2]) {
                par3 += (double)matrix[i1][1][1];
            }
        }
        return this.func_70489_a(par1, par3, par5);
    }

    public Vec3 yVector(double par1, double par3, double par5) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)par1);
        if (this.field_70170_p.func_147439_a(i, (j = MathHelper.func_76128_c((double)par3)) - 1, k = MathHelper.func_76128_c((double)par5)) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j - 1, k) == BlockIDs.tcRailGag.block) {
            --j;
        } else if (this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRail.block || this.field_70170_p.func_147439_a(i, j + 1, k) == BlockIDs.tcRailGag.block) {
            ++j;
        }
        Block l = this.field_70170_p.func_147439_a(i, j, k);
        if (l == BlockIDs.tcRail.block || l == BlockIDs.tcRailGag.block) {
            double d4 = (double)i + 0.5 + (double)matrix[0][0][0] * 0.5;
            double d6 = (double)k + 0.5 + (double)matrix[0][0][2] * 0.5;
            double d10 = (double)i + 0.5 + (double)matrix[0][1][0] * 0.5 - d4;
            double d12 = (double)k + 0.5 + (double)matrix[0][1][2] * 0.5 - d6;
            if (d10 == 0.0) {
                return Vec3.func_72443_a((double)(d4 + d10 * (par5 - (double)k)), (double)(par3 + 0.2), (double)(d6 + d12 * (par5 - (double)k)));
            }
            if (d12 == 0.0) {
                return Vec3.func_72443_a((double)(d4 + d10 * (par1 - (double)i)), (double)(par3 + 0.2), (double)(d6 + d12 * (par1 - (double)i)));
            }
            double d13 = par1 - d4;
            double d14 = par5 - d6;
            return Vec3.func_72443_a((double)(d4 + d10 * ((d13 * d10 + d14 * d12) * 2.0)), (double)par3, (double)(d6 + d12 * ((d13 * d10 + d14 * d12) * 2.0)));
        }
        return null;
    }

    public ItemStack[] getInventory() {
        return null;
    }
}

