/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.adminbook.ServerLogger;
import train.common.api.EntityRollingStock;
import train.common.api.SpeedHandler;
import train.common.api.SteamTrain;
import train.common.api.WirelessTransmitter;
import train.common.core.HandleMaxAttachedCarts;
import train.common.core.handlers.ConfigHandler;
import train.common.core.network.PacketKeyPress;
import train.common.core.network.PacketParkingBrake;
import train.common.core.network.PacketSlotsFilled;
import train.common.entity.rollingStock.EntityLocoDieselCD742;
import train.common.entity.rollingStock.EntityLocoDieselClass66;
import train.common.entity.rollingStock.EntityLocoDieselDD35A;
import train.common.entity.rollingStock.EntityLocoDieselIC4_DSB_MG;
import train.common.entity.rollingStock.EntityLocoDieselSD40;
import train.common.entity.rollingStock.EntityLocoDieselSD70;
import train.common.entity.rollingStock.EntityLocoDieselV60_DB;
import train.common.entity.rollingStock.EntityLocoElectricBP4;
import train.common.entity.rollingStock.EntityLocoElectricBR185;
import train.common.entity.rollingStock.EntityLocoElectricCD151;
import train.common.entity.rollingStock.EntityLocoElectricE103;
import train.common.entity.rollingStock.EntityLocoElectricHighSpeedZeroED;
import train.common.entity.rollingStock.EntityLocoElectricICE1;
import train.common.entity.rollingStock.EntityLocoElectricTramNY;
import train.common.entity.rollingStock.EntityLocoElectricVL10;
import train.common.items.ItemWirelessTransmitter;
import train.common.library.EnumSounds;
import train.common.mtc.PDMMessage;
import train.common.mtc.TilePDMInstructionRadio;
import train.common.mtc.packets.PacketATO;
import train.common.mtc.packets.PacketATOSetStopPoint;
import train.common.mtc.packets.PacketMTC;
import train.common.mtc.packets.PacketNextSpeed;
import train.common.mtc.packets.PacketSetSpeed;

public abstract class Locomotive
extends EntityRollingStock
implements IInventory,
WirelessTransmitter {
    public int inventorySize;
    protected ItemStack[] locoInvent;
    private int soundPosition = 0;
    public boolean parkingBrake = false;
    private int whistleDelay = 0;
    private int blowUpDelay = 0;
    private String lastRider = "";
    private Entity lastEntityRider;
    public int numCargoSlots;
    public int numCargoSlots1;
    public int numCargoSlots2;
    private boolean hasDrowned = false;
    protected boolean canCheckInvent = true;
    private int slotsFilled = 0;
    private int fuelUpdateTicks = 0;
    public boolean isLocoTurnedOn = false;
    public boolean forwardPressed = false;
    private boolean backwardPressed = false;
    public boolean brakePressed = false;
    public int speedLimit = 0;
    public String trainLevel = "1";
    public int mtcStatus = 0;
    public int mtcType = 1;
    public int atoStatus = 0;
    public Double xFromStopPoint = 0.0;
    public Double yFromStopPoint = 0.0;
    public Double zFromStopPoint = 0.0;
    public Double distanceFromStopPoint = 0.0;
    public Double xStationStop = 0.0;
    public Double yStationStop = 0.0;
    public Double zStationStop = 0.0;
    public Double distanceFromStationStop = 0.0;
    public boolean stationStopping = false;
    public int nextSpeedLimit = 0;
    public Double distanceFromSpeedChange = 0.0;
    public Double xSpeedLimitChange = 0.0;
    public Double ySpeedLimitChange = 0.0;
    public Double zSpeedLimitChange = 0.0;
    public boolean isDriverOverspeed = false;
    public boolean overspeedBrakingInProgress = false;
    public Boolean mtcOverridePressed = false;
    public Boolean overspeedOveridePressed = false;
    public String serverUUID = "";
    public String trainID;
    public String currentSignalBlock = "";
    public boolean speedGoingDown = false;
    public boolean isConnected = false;
    public TileEntity[] blocksToCheck;
    public boolean stationStop = false;
    private String locoState = "";
    protected boolean canBeAdjusted = false;
    public int currentNumCartsPulled = 0;
    public double currentMassPulled = 0.0;
    public double currentSpeedSlowDown = 0.0;
    public double currentAccelSlowDown = 0.0;
    public double currentBrakeSlowDown = 0.0;
    public double currentFuelConsumptionChange = 0.0;
    protected int fuelRate;
    public boolean canBePulled = false;

    public Locomotive(World world) {
        super(world);
        String output;
        this.setFuelConsumption(0);
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1;
        this.field_70180_af.func_75682_a(2, (Object)0);
        this.setDefaultMass(0.0);
        this.setCustomSpeed(this.getMaxSpeed());
        this.field_70180_af.func_75682_a(3, (Object)this.destination);
        this.field_70180_af.func_75682_a(22, (Object)this.locoState);
        this.field_70180_af.func_75682_a(24, (Object)this.fuelTrain);
        this.field_70180_af.func_75682_a(25, (Object)((int)this.convertSpeed(Math.sqrt(Math.abs(this.field_70159_w * this.field_70159_w) + Math.abs(this.field_70179_y * this.field_70179_y)))));
        this.field_70180_af.func_75682_a(26, (Object)this.castToString(this.currentNumCartsPulled));
        this.field_70180_af.func_75682_a(27, (Object)this.castToString(this.currentMassPulled));
        this.field_70180_af.func_75682_a(28, (Object)this.castToString(Math.round(this.currentSpeedSlowDown)));
        this.field_70180_af.func_75682_a(29, (Object)this.castToString(this.currentAccelSlowDown));
        this.field_70180_af.func_75682_a(30, (Object)this.castToString(this.currentBrakeSlowDown));
        this.field_70180_af.func_75682_a(31, (Object)this.castToString(this.currentFuelConsumptionChange));
        this.field_70180_af.func_75682_a(15, (Object)Float.valueOf(Math.round(this.getCustomSpeed() * 3.6f)));
        this.setAccel(0.0);
        this.setBrake(0.0);
        this.field_70144_Y = 0.99f;
        if (this instanceof SteamTrain) {
            this.isLocoTurnedOn = true;
        }
        char[] chars = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        StringBuilder sb = new StringBuilder(5);
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        this.trainID = output = sb.toString();
        if (this.serverUUID != "") {
            this.attemptConnection(this.serverUUID);
        }
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.isLocoTurnedOn = additionalData.readBoolean();
        this.parkingBrake = additionalData.readBoolean();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isLocoTurnedOn);
        buffer.writeBoolean(this.parkingBrake);
    }

    private String castToString(double str) {
        return "" + str;
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return false;
    }

    @Override
    public boolean isStorageCart() {
        return false;
    }

    protected int getCurrentMaxSpeed() {
        return this.field_70180_af.func_75679_c(2);
    }

    protected void setCurrentMaxSpeed(int maxSpeed) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(2, (Object)maxSpeed);
        }
    }

    public void setCustomSpeed(double m) {
        if (m != 0.0) {
            this.setCurrentMaxSpeed((int)m);
            return;
        }
        this.setCurrentMaxSpeed((int)this.getMaxSpeed());
    }

    public float getMaxSpeed() {
        if (this.trainSpec != null) {
            float power;
            if (this.currentMassPulled > 1.0 && (power = (float)this.currentMassPulled / ((float)this.trainSpec.getMHP() * 0.37f)) > 1.0f) {
                return (float)this.trainSpec.getMaxSpeed() / power;
            }
            return this.trainSpec.getMaxSpeed();
        }
        return 50.0f;
    }

    public float getCustomSpeed() {
        return (float)this.getCurrentMaxSpeed() / 3.6f;
    }

    @Override
    public boolean canOverheat() {
        return this.getOverheatTime() > 0;
    }

    @Override
    public int getOverheatTime() {
        if (this.trainSpec != null) {
            return this.trainSpec.getHeatingTime();
        }
        return 0;
    }

    @Override
    public void limitSpeedOnTCRail() {
        this.maxSpeed = SpeedHandler.handleSpeed(this.getMaxSpeed(), this.maxSpeed, (Entity)this);
        if (this.speedLimiter != 0.0 && this.speedWasSet) {
            this.adjustSpeed(this.maxSpeed, this.speedLimiter);
        }
        if (this.field_70159_w < (double)(-this.maxSpeed)) {
            this.field_70159_w = -this.maxSpeed;
        }
        if (this.field_70159_w > (double)this.maxSpeed) {
            this.field_70159_w = this.maxSpeed;
        }
        if (this.field_70179_y < (double)(-this.maxSpeed)) {
            this.field_70179_y = -this.maxSpeed;
        }
        if (this.field_70179_y > (double)this.maxSpeed) {
            this.field_70179_y = this.maxSpeed;
        }
    }

    public int setFuelConsumption(int c) {
        if (c != 0) {
            this.fuelRate = c;
            return this.fuelRate;
        }
        if (this.trainSpec != null) {
            this.fuelRate = this.trainSpec.getFuelConsumption();
            return this.fuelRate;
        }
        return 0;
    }

    public int getFuelConsumption() {
        return this.fuelRate == 0 ? this.trainSpec.getFuelConsumption() : this.fuelRate;
    }

    public int getPower() {
        if (this.trainSpec != null) {
            return this.trainSpec.getMHP();
        }
        return 0;
    }

    public double setAccel(double rate) {
        if (rate != 0.0) {
            this.accelerate = rate;
            return this.accelerate;
        }
        if (this.trainSpec != null) {
            this.accelerate = this.trainSpec.getAccelerationRate();
            return this.accelerate;
        }
        return 0.45;
    }

    public double setBrake(double rate) {
        if (rate != 0.0) {
            this.brake = rate;
            return this.brake;
        }
        if (this.trainSpec != null) {
            this.brake = this.trainSpec.getBrakeRate();
            return this.brake;
        }
        return 0.98;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
        nbttagcompound.func_74757_a("canBePulled", this.canBePulled);
        nbttagcompound.func_74768_a("overheatLevel", this.getOverheatLevel());
        nbttagcompound.func_74778_a("lastRider", this.lastRider);
        nbttagcompound.func_74778_a("destination", this.destination);
        nbttagcompound.func_74757_a("parkingBrake", this.parkingBrake);
        if (!(this instanceof SteamTrain)) {
            nbttagcompound.func_74757_a("isLocoTurnedOn", this.isLocoTurnedOn);
        }
        nbttagcompound.func_74778_a("trainID", this.trainID);
        nbttagcompound.func_74768_a("speedLimit", this.speedLimit);
        nbttagcompound.func_74778_a("trainLevel", this.trainLevel);
        nbttagcompound.func_74768_a("mtcStatus", this.mtcStatus);
        nbttagcompound.func_74768_a("mtcType", this.mtcType);
        nbttagcompound.func_74768_a("atoStatus", this.atoStatus);
        nbttagcompound.func_74780_a("xFromStop", this.xFromStopPoint.doubleValue());
        nbttagcompound.func_74780_a("yFromStop", this.yFromStopPoint.doubleValue());
        nbttagcompound.func_74780_a("zFromStop", this.zFromStopPoint.doubleValue());
        nbttagcompound.func_74780_a("xFromStationStop", this.xStationStop.doubleValue());
        nbttagcompound.func_74780_a("yFromStationStop", this.yStationStop.doubleValue());
        nbttagcompound.func_74780_a("zFromStationStop", this.zStationStop.doubleValue());
        nbttagcompound.func_74768_a("nextSpeedLimit", this.nextSpeedLimit);
        nbttagcompound.func_74780_a("xSpeedChange", this.xSpeedLimitChange.doubleValue());
        nbttagcompound.func_74780_a("ySpeedChange", this.ySpeedLimitChange.doubleValue());
        nbttagcompound.func_74780_a("zSpeedChange", this.zSpeedLimitChange.doubleValue());
        nbttagcompound.func_74757_a("mtcOverridePressed", this.mtcOverridePressed.booleanValue());
        nbttagcompound.func_74757_a("overspeedOverridePressed", this.overspeedOveridePressed.booleanValue());
        nbttagcompound.func_74778_a("serverUUID", this.serverUUID);
        nbttagcompound.func_74778_a("currentSignalBlock", this.currentSignalBlock);
        nbttagcompound.func_74757_a("isConnected", this.isConnected);
        nbttagcompound.func_74757_a("stationStop", this.stationStop);
    }

    @Override
    protected void func_70037_a(NBTTagCompound ntc) {
        super.func_70037_a(ntc);
        this.canBeAdjusted = ntc.func_74767_n("canBeAdjusted");
        this.canBePulled = ntc.func_74767_n("canBePulled");
        this.setOverheatLevel(ntc.func_74762_e("overheatLevel"));
        this.lastRider = ntc.func_74779_i("lastRider");
        this.destination = ntc.func_74779_i("destination");
        this.parkingBrake = ntc.func_74767_n("parkingBrake");
        if (!(this instanceof SteamTrain)) {
            this.isLocoTurnedOn = ntc.func_74767_n("isLocoTurnedOn");
        }
        this.trainID = ntc.func_74779_i("trainID");
        this.speedLimit = ntc.func_74762_e("speedLimit");
        this.trainLevel = ntc.func_74779_i("trainLevel");
        this.mtcStatus = ntc.func_74762_e("mtcStatus");
        this.mtcType = ntc.func_74762_e("mtcType");
        this.atoStatus = ntc.func_74762_e("atoStatus");
        this.xFromStopPoint = ntc.func_74769_h("xFromStop");
        this.yFromStopPoint = ntc.func_74769_h("yFromStop");
        this.zFromStopPoint = ntc.func_74769_h("zFromStop");
        this.xStationStop = ntc.func_74769_h("xFromStationStop");
        this.yStationStop = ntc.func_74769_h("yFromStationStop");
        this.zStationStop = ntc.func_74769_h("zFromStationStop");
        this.nextSpeedLimit = ntc.func_74762_e("nextSpeedLimit");
        this.xSpeedLimitChange = ntc.func_74769_h("xSpeedChange");
        this.ySpeedLimitChange = ntc.func_74769_h("ySpeedChange");
        this.zSpeedLimitChange = ntc.func_74769_h("zSpeedChange");
        this.mtcOverridePressed = ntc.func_74767_n("mtcOverridePressed");
        this.overspeedOveridePressed = ntc.func_74767_n("overspeedOverridePressed");
        this.serverUUID = ntc.func_74779_i("serverUUID");
        this.currentSignalBlock = ntc.func_74779_i("currentSignalBlock");
        this.isConnected = ntc.func_74767_n("isConnected");
        this.stationStop = ntc.func_74767_n("stationStop");
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public void setCanBeAdjusted(boolean canBeAdj) {
        this.canBeAdjusted = canBeAdj;
    }

    @Override
    public void keyHandlerFromPacket(int i) {
        if (this.getTrainLockedFromPacket() && this.field_70153_n instanceof EntityPlayer && !((EntityPlayer)this.field_70153_n).getDisplayName().toLowerCase().equals(this.getTrainOwner().toLowerCase())) {
            return;
        }
        this.pressKey(i);
        if (i == 8 && ConfigHandler.SOUNDS) {
            this.soundHorn();
        }
        if (i == 4) {
            this.forwardPressed = true;
        }
        if (i == 5) {
            this.backwardPressed = true;
        }
        if (i == 12) {
            this.brakePressed = true;
        }
        if (i == 13) {
            this.forwardPressed = false;
        }
        if (i == 14) {
            this.backwardPressed = false;
        }
        if (i == 15) {
            this.brakePressed = false;
        }
        if (i == 16 && this.mtcStatus != 0 && this.mtcType == 2 && this.trainIsATOSupported().booleanValue()) {
            if (this.atoStatus == 1) {
                this.atoStatus = 0;
                Minecraft.func_71410_x().field_71439_g.func_71165_d("Automatic Train Operation disabled.");
            } else {
                this.atoStatus = 1;
                Minecraft.func_71410_x().field_71439_g.func_71165_d("Automatic Train Operation enabled.");
            }
        }
        if (i == 17) {
            if (this.mtcOverridePressed.booleanValue()) {
                this.mtcOverridePressed = false;
            } else {
                this.mtcOverridePressed = true;
                this.mtcStatus = 0;
                this.speedLimit = 0;
                this.nextSpeedLimit = 0;
                this.xSpeedLimitChange = 0.0;
                this.ySpeedLimitChange = 0.0;
                this.zSpeedLimitChange = 0.0;
                this.xFromStopPoint = 0.0;
                this.yFromStopPoint = 0.0;
                this.zFromStopPoint = 0.0;
                this.trainLevel = "0";
                this.disconnectFromServer();
            }
        }
        if (i == 18 && this.mtcStatus != 0) {
            this.overspeedOveridePressed = this.overspeedOveridePressed != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
    }

    public String getCurrentNumCartsPulled() {
        return this.field_70180_af.func_75681_e(26);
    }

    public String getCurrentMassPulled() {
        return this.field_70180_af.func_75681_e(27);
    }

    public String getCurrentSpeedSlowDown() {
        return this.field_70180_af.func_75681_e(28);
    }

    public String getCurrentAccelSlowDown() {
        return this.field_70180_af.func_75681_e(29);
    }

    public String getCurrentBrakeSlowDown() {
        return this.field_70180_af.func_75681_e(30);
    }

    public String getCurrentFuelConsumptionChange() {
        return this.field_70180_af.func_75681_e(31);
    }

    public Float getCustomSpeedGUI() {
        return Float.valueOf(this.field_70180_af.func_111145_d(15));
    }

    public String getDestinationGUI() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75681_e(3);
        }
        return this.destination;
    }

    private double convertSpeed(double speed) {
        speed = ConfigHandler.REAL_TRAIN_SPEED ? (speed *= 2.0) : (speed *= 6.0);
        return speed *= 36.0;
    }

    public void soundHorn() {
        for (EnumSounds sounds : EnumSounds.values()) {
            if (sounds.getEntityClass() == null || sounds.getHornString().equals("") || !sounds.getEntityClass().equals(this.getClass()) || this.whistleDelay != 0) continue;
            this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getHornString(), sounds.getHornVolume().floatValue(), 1.0f);
            this.whistleDelay = 65;
        }
        List entities = this.field_70170_p.func_72872_a(EntityAnimal.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 20.0), (double)(this.field_70163_u - 5.0), (double)(this.field_70161_v - 20.0), (double)(this.field_70165_t + 20.0), (double)(this.field_70163_u + 5.0), (double)(this.field_70161_v + 20.0)));
        for (Object e : entities) {
            if (!(e instanceof EntityAnimal)) continue;
            ((EntityAnimal)e).func_70784_b((Entity)this);
            ((EntityAnimal)e).func_70661_as().func_75484_a(null, 0.0);
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0 && !Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146241_e()) {
            if (FMLClientHandler.instance().getClient().field_71474_y.field_74351_w.func_151470_d() && !this.forwardPressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(4));
                this.forwardPressed = true;
            } else if (!FMLClientHandler.instance().getClient().field_71474_y.field_74351_w.func_151470_d() && this.forwardPressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(13));
                this.forwardPressed = false;
            }
            if (FMLClientHandler.instance().getClient().field_71474_y.field_74368_y.func_151470_d() && !this.backwardPressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(5));
                this.backwardPressed = true;
            } else if (!FMLClientHandler.instance().getClient().field_71474_y.field_74368_y.func_151470_d() && this.backwardPressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(14));
                this.backwardPressed = false;
            }
            if (FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d() && !this.brakePressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(12));
                this.brakePressed = true;
            } else if (!FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d() && this.brakePressed) {
                Traincraft.keyChannel.sendToServer((IMessage)new PacketKeyPress(15));
                this.brakePressed = false;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70153_n instanceof EntityLivingBase) {
                if (this.forwardPressed || this.backwardPressed) {
                    if (this.getFuel() > 0 && this.isLocoTurnedOn() && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K) {
                        if (this.getTrainLockedFromPacket() && !((EntityPlayer)this.field_70153_n).getDisplayName().toLowerCase().equals(this.getTrainOwner().toLowerCase())) {
                            return;
                        }
                        if (this.field_70153_n instanceof EntityPlayer) {
                            int dir = MathHelper.func_76128_c((double)((double)(((EntityPlayer)this.field_70153_n).field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                            if (dir == 2) {
                                this.field_70179_y = this.forwardPressed ? (this.field_70179_y -= 0.0075 * this.accelerate) : (this.field_70179_y += 0.0075 * this.accelerate);
                            } else if (dir == 0) {
                                this.field_70179_y = this.forwardPressed ? (this.field_70179_y += 0.0075 * this.accelerate) : (this.field_70179_y -= 0.0075 * this.accelerate);
                            } else if (dir == 1) {
                                this.field_70159_w = this.forwardPressed ? (this.field_70159_w -= 0.0075 * this.accelerate) : (this.field_70159_w += 0.0075 * this.accelerate);
                            } else if (dir == 3) {
                                this.field_70159_w = this.forwardPressed ? (this.field_70159_w += 0.0075 * this.accelerate) : (this.field_70159_w -= 0.0075 * this.accelerate);
                            }
                        }
                    }
                } else if (this.brakePressed) {
                    this.field_70159_w *= this.brake;
                    this.field_70179_y *= this.brake;
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                HandleMaxAttachedCarts.PullPhysic(this);
            }
            if (this.field_70173_aa % 200 == 0) {
                this.slotsFilled = 0;
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.func_70301_a(i);
                    if (itemstack == null) continue;
                    ++this.slotsFilled;
                }
                Traincraft.slotschannel.sendToAllAround((IMessage)new PacketSlotsFilled(this, this.slotsFilled), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
            }
            if (this.fuelUpdateTicks >= 100) {
                this.fuelUpdateTicks = 0;
                this.updateFuelTrain(this.getFuelConsumption());
            }
            ++this.fuelUpdateTicks;
            if (!this.isLocoTurnedOn()) {
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            }
        }
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            this.lastRider = ((EntityPlayer)this.field_70153_n).getDisplayName();
            this.lastEntityRider = this.field_70153_n;
        }
        if (!this.field_70170_p.field_72995_K && this.getParkingBrakeFromPacket() && !this.getState().equals("broken")) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (ConfigHandler.SOUNDS) {
            for (EnumSounds sounds : EnumSounds.values()) {
                if (sounds.getEntityClass() == null || sounds.getHornString().equals("") || !sounds.getEntityClass().equals(this.getClass()) || this.whistleDelay != 0) continue;
                if (this.getFuel() <= 0 || !this.isLocoTurnedOn()) break;
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (speed > -0.001 && speed < 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getIdleString(), sounds.getIdleVolume().floatValue(), 0.001f);
                    this.soundPosition = sounds.getIdleSoundLenght();
                }
                if (sounds.getSoundChangeWithSpeed() && !sounds.getHornString().equals("") && sounds.getEntityClass().equals(this.getClass()) && this.whistleDelay == 0) {
                    if (speed > 0.01 && speed < 0.06 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.1f);
                        this.soundPosition = sounds.getRunSoundLenght();
                    } else if (speed > 0.06 && speed < 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                        this.soundPosition = sounds.getRunSoundLenght() / 2;
                    } else if (speed > 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.5f);
                        this.soundPosition = sounds.getRunSoundLenght() / 3;
                    }
                } else if (speed > 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                    this.soundPosition = sounds.getRunSoundLenght();
                }
                if (this.soundPosition <= 0) break;
                --this.soundPosition;
                break;
            }
        }
        if (this.getState().equals("cold")) {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= (double)this.getMaxSpeed() * 0.6) {
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            }
        }
        if (this.getState().equals("warm")) {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= (double)this.getMaxSpeed() * 0.7) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        }
        if (this.getState().equals("hot")) {
            this.func_70066_B();
        }
        if (this.getState().equals("too hot")) {
            this.field_70159_w *= 0.95;
            this.field_70179_y *= 0.95;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.getState().equals("broken")) {
            this.func_70015_d(8);
            this.setCustomSpeed(0.0);
            this.setAccel(1.0E-6);
            this.setBrake(1.0);
            this.field_70159_w *= 0.97;
            this.field_70179_y *= 0.97;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            ++this.blowUpDelay;
            if (this.blowUpDelay > 80) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, false);
                    this.func_70106_y();
                }
                if (!this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider instanceof EntityPlayer) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " blew " + this.getTrainOwner() + "'s locomotive"));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " blew " + this.getTrainOwner() + "'s locomotive"));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.mtcStatus == 1 | this.mtcStatus == 2) {
            if (this.mtcType == 2) {
                if (this.field_70173_aa % 20 == 0) {
                    JsonObject sendingObj = new JsonObject();
                    sendingObj.addProperty("funct", "update");
                    sendingObj.addProperty("signalBlock", this.currentSignalBlock);
                    sendingObj.addProperty("trainLevel", this.trainLevel);
                    sendingObj.addProperty("trainName", this.getTrainName());
                    this.sendMessage(new PDMMessage(this.trainID, this.serverUUID, sendingObj.toString(), 1));
                }
                if (this.mtcType == 2 && !this.trainIsWMTCSupported().booleanValue()) {
                    this.disconnectFromServer();
                    this.serverUUID = "";
                    this.mtcStatus = 0;
                    Traincraft.mscChannel.sendToAllAround((IMessage)new PacketMTC(this.func_145782_y(), this.mtcStatus, 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
            }
            this.isDriverOverspeed = this.getSpeed() > (double)this.speedLimit && this.speedLimit != 0;
            if (this.isDriverOverspeed && this.field_70173_aa % 120 == 0 && !this.overspeedBrakingInProgress && !this.overspeedOveridePressed.booleanValue() && this.atoStatus != 1) {
                this.overspeedBrakingInProgress = true;
            }
            if (this.overspeedBrakingInProgress && this.atoStatus != 1) {
                if (this.getSpeed() < (double)this.speedLimit) {
                    this.overspeedBrakingInProgress = false;
                    this.isDriverOverspeed = false;
                } else {
                    this.slow(this.speedLimit);
                }
            }
            this.distanceFromStopPoint = this.func_70011_f(this.xFromStopPoint, this.yFromStopPoint, this.zFromStopPoint);
            this.distanceFromSpeedChange = this.func_70011_f(this.xSpeedLimitChange, this.ySpeedLimitChange, this.zSpeedLimitChange);
            if (this.distanceFromSpeedChange <= (double)this.speedLimit && this.distanceFromSpeedChange <= this.getSpeed() && !(this.distanceFromSpeedChange <= (double)this.nextSpeedLimit)) {
                this.speedLimit = (int)Math.round(this.distanceFromSpeedChange);
                this.speedGoingDown = true;
                Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                if (this.distanceFromSpeedChange <= 6.0) {
                    this.xSpeedLimitChange = 0.0;
                    this.ySpeedLimitChange = 0.0;
                    this.zSpeedLimitChange = 0.0;
                    this.speedLimit = this.nextSpeedLimit;
                    this.nextSpeedLimit = 0;
                    Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                    Traincraft.itnsChannel.sendToAllAround((IMessage)new PacketNextSpeed(this.nextSpeedLimit, 0, 0, 0, this.xSpeedLimitChange, this.ySpeedLimitChange, this.zSpeedLimitChange, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                    this.speedGoingDown = false;
                }
            }
            if (this.distanceFromStopPoint >= 40.0 && this.distanceFromStopPoint < (double)this.speedLimit && this.xFromStopPoint != 0.0 && this.mtcType == 1) {
                this.speedLimit = (int)Math.round(this.distanceFromStopPoint);
                Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                this.speedGoingDown = true;
            }
            if (this.distanceFromStopPoint >= 10.0 && this.distanceFromStopPoint < (double)this.speedLimit && this.xFromStopPoint != 0.0 && this.mtcType == 2) {
                this.speedLimit = (int)Math.round(this.distanceFromStopPoint);
                Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                this.speedGoingDown = true;
            }
            if (this.atoStatus == 1 && this.trainIsATOSupported().booleanValue()) {
                this.distanceFromStationStop = this.func_70011_f(this.xStationStop, this.yStationStop, this.zStationStop);
                if (this.parkingBrake) {
                    this.parkingBrake = false;
                }
                if (!(this.distanceFromStopPoint < this.getSpeed()) && !(this.distanceFromSpeedChange < this.getSpeed())) {
                    this.accel(this.speedLimit);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70180_af.func_75692_b(25, (Object)((int)this.convertSpeed(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))));
                    if (this.field_70173_aa % 5 == 0) {
                        this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
                        this.field_70180_af.func_75692_b(20, (Object)this.overheatLevel);
                        this.field_70180_af.func_75692_b(22, (Object)this.locoState);
                        this.field_70180_af.func_75692_b(3, (Object)this.destination);
                        this.field_70180_af.func_75692_b(31, (Object)("1c/" + this.castToString((int)this.currentFuelConsumptionChange) + " per tick"));
                    }
                    if (this.field_70173_aa % 20 == 0) {
                        this.field_70180_af.func_75692_b(26, (Object)this.castToString(this.currentNumCartsPulled));
                        this.field_70180_af.func_75692_b(27, (Object)(this.castToString(this.currentMassPulled) + " tons"));
                        this.field_70180_af.func_75692_b(28, (Object)this.castToString((int)this.currentSpeedSlowDown));
                        this.field_70180_af.func_75692_b(29, (Object)this.castToString((double)Math.round(this.currentAccelSlowDown * 1000.0) / 1000.0));
                        this.field_70180_af.func_75692_b(30, (Object)this.castToString((double)Math.round(this.currentBrakeSlowDown * 1000.0) / 1000.0));
                        this.field_70180_af.func_75692_b(15, (Object)Float.valueOf(this.getMaxSpeed()));
                    }
                    if (this.field_70173_aa % 4 == 0 && this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, -0.2000000059604645, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this)) {
                        if (!this.hasDrowned && !this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider instanceof EntityPlayer) {
                            FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                            FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                        }
                        this.setCustomSpeed(0.0);
                        this.setAccel(1.0E-6);
                        this.setBrake(1.0);
                        this.field_70159_w *= 0.97;
                        this.field_70179_y *= 0.97;
                        this.fuelTrain = 0;
                        this.hasDrowned = true;
                        this.canCheckInvent = false;
                        ++this.blowUpDelay;
                        if (this.blowUpDelay > 20) {
                            this.func_70097_a(DamageSource.field_76369_e, 100.0f);
                        }
                    }
                }
                if (this.distanceFromStopPoint < this.getSpeed()) {
                    this.stop(Vec3.func_72443_a((double)this.xFromStopPoint, (double)this.yFromStopPoint, (double)this.zFromStopPoint));
                }
                if (this.distanceFromStationStop < this.getSpeed()) {
                    this.stop(Vec3.func_72443_a((double)this.xStationStop, (double)this.yStationStop, (double)this.zStationStop));
                    this.stationStopping = true;
                } else {
                    this.stationStopping = false;
                }
                if (this.distanceFromSpeedChange < this.getSpeed() && this.getSpeed() != (double)this.nextSpeedLimit) {
                    this.slow(this.nextSpeedLimit);
                }
                if (this.isDriverOverspeed) {
                    this.slow(this.speedLimit);
                }
                if (this.distanceFromStopPoint < 2.0 || this.distanceFromStationStop < 2.0) {
                    this.parkingBrake = true;
                    this.isBraking = true;
                    if (this.distanceFromStopPoint < 2.0) {
                        this.xFromStopPoint = 0.0;
                        this.yFromStopPoint = 0.0;
                        this.zFromStopPoint = 0.0;
                    } else if (this.distanceFromStationStop < 2.0) {
                        this.xStationStop = 0.0;
                        this.yStationStop = 0.0;
                        this.zStationStop = 0.0;
                    }
                    this.atoStatus = 0;
                    this.stationStop = true;
                    Traincraft.atoChannel.sendToAllAround((IMessage)new PacketATO(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                    Traincraft.atoSetStopPoint.sendToAllAround((IMessage)new PacketATOSetStopPoint(this.func_145782_y(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                    Traincraft.brakeChannel.sendToAllAround((IMessage)new PacketParkingBrake(true, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                    if (this.isConnected && this.trainIsATOSupported().booleanValue()) {
                        JsonObject sendingObj = new JsonObject();
                        sendingObj.addProperty("funct", "stationstopcomplete");
                        this.sendMessage(new PDMMessage(this.trainID, this.serverUUID, sendingObj.toString(), 0));
                    }
                }
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(25, (Object)((int)this.convertSpeed(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))));
            if (this.field_70173_aa % 5 == 0) {
                this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
                this.field_70180_af.func_75692_b(20, (Object)this.overheatLevel);
                this.field_70180_af.func_75692_b(22, (Object)this.locoState);
                this.field_70180_af.func_75692_b(3, (Object)this.destination);
                this.field_70180_af.func_75692_b(31, (Object)("1c/" + this.castToString((int)this.currentFuelConsumptionChange) + " per tick"));
            }
            if (this.field_70173_aa % 20 == 0) {
                this.field_70180_af.func_75692_b(26, (Object)this.castToString(this.currentNumCartsPulled));
                this.field_70180_af.func_75692_b(27, (Object)(this.castToString(this.currentMassPulled) + " tons"));
                this.field_70180_af.func_75692_b(28, (Object)this.castToString((int)this.currentSpeedSlowDown));
                this.field_70180_af.func_75692_b(29, (Object)this.castToString((double)Math.round(this.currentAccelSlowDown * 1000.0) / 1000.0));
                this.field_70180_af.func_75692_b(30, (Object)this.castToString((double)Math.round(this.currentBrakeSlowDown * 1000.0) / 1000.0));
                this.field_70180_af.func_75692_b(15, (Object)Float.valueOf(this.getMaxSpeed()));
            }
            if (this.field_70173_aa % 4 == 0 && this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, -0.2000000059604645, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this)) {
                if (!this.hasDrowned && !this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider instanceof EntityPlayer) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                }
                this.setCustomSpeed(0.0);
                this.setAccel(1.0E-6);
                this.setBrake(1.0);
                this.field_70159_w *= 0.97;
                this.field_70179_y *= 0.97;
                this.fuelTrain = 0;
                this.hasDrowned = true;
                this.canCheckInvent = false;
                ++this.blowUpDelay;
                if (this.blowUpDelay > 20) {
                    this.func_70097_a(DamageSource.field_76369_e, 100.0f);
                }
            }
        }
    }

    @Override
    protected void applyDragAndPushForces() {
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    @Override
    public double getDragAir() {
        return 1.0;
    }

    public boolean getParkingBrakeFromPacket() {
        return this.parkingBrake;
    }

    public void setParkingBrakeFromPacket(boolean set) {
        this.parkingBrake = set;
    }

    public double getSpeed() {
        return this.field_70180_af.func_75679_c(25);
    }

    @Override
    public int getOverheatLevel() {
        return this.field_70180_af.func_75679_c(20);
    }

    public String getState() {
        return this.field_70180_af.func_75681_e(22);
    }

    public void setState(String state) {
        this.locoState = state;
        this.field_70180_af.func_75692_b(22, (Object)state);
    }

    public int getFuel() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24);
        }
        return this.fuelTrain;
    }

    public boolean getIsFuelled() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) > 0;
        }
        return this.fuelTrain > 0;
    }

    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / 1200;
        }
        return this.fuelTrain * i / 1200;
    }

    protected void updateFuelTrain(int consumption) {
        if (this.fuelTrain < 0) {
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        } else if (this.isLocoTurnedOn()) {
            this.fuelTrain -= consumption;
            if (this.fuelTrain < 0) {
                this.fuelTrain = 0;
            }
        }
    }

    public void setLocoTurnedOnFromPacket(boolean set) {
        this.isLocoTurnedOn = set;
    }

    public boolean isLocoTurnedOn() {
        return this.isLocoTurnedOn;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            this.disconnectFromServer();
            ServerLogger.deleteWagon(this);
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
            } else {
                this.dropCartAsItem(false);
            }
        }
        return true;
    }

    @Override
    public void dropCartAsItem(boolean isCreative) {
        if (!this.itemdropped) {
            super.dropCartAsItem(isCreative);
            for (ItemStack stack : this.locoInvent) {
                if (stack == null) continue;
                this.func_70099_a(stack, 0.0f);
            }
        }
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (ticket != null) {
            this.destination = Locomotive.getTicketDestination(ticket);
            return true;
        }
        return false;
    }

    public ItemStack func_70301_a(int i) {
        return this.locoInvent[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.locoInvent[par1] != null) {
            ItemStack var2 = this.locoInvent[par1];
            this.locoInvent[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.locoInvent[i] != null) {
            if (this.locoInvent[i].field_77994_a <= j) {
                ItemStack itemstack = this.locoInvent[i];
                this.locoInvent[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.locoInvent[i].func_77979_a(j);
            if (this.locoInvent[i].field_77994_a == 0) {
                this.locoInvent[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.locoInvent[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.slotsFilled = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack == null) continue;
                ++this.slotsFilled;
            }
            Traincraft.slotschannel.sendToAllAround((IMessage)new PacketSlotsFilled(this, this.slotsFilled), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
        }
    }

    public int getAmmountOfCargo() {
        return this.slotsFilled;
    }

    public void recieveSlotsFilled(int amount) {
        this.slotsFilled = amount;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.locoInvent;
    }

    public void accel(Integer desiredSpeed) {
        if (this.field_70170_p != null && this.getSpeed() != (double)desiredSpeed.intValue() && (int)this.getSpeed() <= this.speedLimit) {
            if (this.field_70153_n == null) {
                double rotation = this.serverRealRotation;
                if (rotation == 90.0) {
                    this.field_70159_w -= 0.002 * this.accelerate;
                } else if (rotation == -90.0) {
                    this.field_70159_w += 0.002 * this.accelerate;
                } else if (rotation == 0.0) {
                    this.field_70179_y += 0.002 * this.accelerate;
                } else if (rotation == -180.0) {
                    this.field_70179_y -= 0.002 * this.accelerate;
                }
            } else {
                int dir = MathHelper.func_76128_c((double)((double)(((EntityPlayer)this.field_70153_n).field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                if (dir == 2) {
                    this.field_70179_y -= 0.002 * this.accelerate;
                } else if (dir == 0) {
                    this.field_70179_y += 0.002 * this.accelerate;
                } else if (dir == 1) {
                    this.field_70159_w -= 0.002 * this.accelerate;
                } else if (dir == 3) {
                    this.field_70159_w += 0.002 * this.accelerate;
                }
            }
        }
    }

    public void slow(Integer desiredSpeed) {
        if (this.getSpeed() >= (double)desiredSpeed.intValue()) {
            this.field_70159_w *= this.brake;
            this.field_70179_y *= this.brake;
        }
    }

    public void stop(Vec3 signalPosition) {
        double currentDistance;
        double originalDistance = currentDistance = Math.copySign(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72438_d(signalPosition), 1.0);
        double slowPercentage = 0.5;
        if (1.0 - currentDistance != 0.0 && originalDistance != 0.0) {
            slowPercentage = currentDistance / this.getSpeed();
        }
        this.field_70159_w *= slowPercentage;
        this.field_70179_y *= slowPercentage;
    }

    @Override
    public void receiveMessage(PDMMessage message) {
        JsonParser parser = new JsonParser();
        JsonObject thing = parser.parse(PDMMessage.message.toString()).getAsJsonObject();
        if (message != null && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            if (thing.get("funct").getAsString().equals("startlevel2")) {
                this.serverUUID = PDMMessage.UUIDFrom;
                this.mtcType = 2;
                this.mtcStatus = thing.get("mtcStatus").getAsInt();
                this.isConnected = true;
                Traincraft.mscChannel.sendToAllAround((IMessage)new PacketMTC(this.func_145782_y(), this.mtcStatus, 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                this.speedLimit = thing.get("speedLimit").getAsInt();
                this.nextSpeedLimit = thing.get("nextSpeedLimit").getAsInt();
                Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, 0, 0, 0, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                if (this.nextSpeedLimit != 0) {
                    this.xSpeedLimitChange = thing.get("nextSpeedLimitChangeX").getAsDouble();
                    this.ySpeedLimitChange = thing.get("nextSpeedLimitChangeY").getAsDouble();
                    this.zSpeedLimitChange = thing.get("nextSpeedLimitChangeZ").getAsDouble();
                }
            } else if (thing.get("funct").getAsString().equals("response")) {
                this.mtcType = 2;
                this.mtcStatus = thing.get("mtcStatus").getAsInt();
                Traincraft.mscChannel.sendToAllAround((IMessage)new PacketMTC(this.func_145782_y(), this.mtcStatus, 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                this.nextSpeedLimit = thing.get("nextSpeedLimit").getAsInt();
                if (!this.speedGoingDown && this.xFromStopPoint == 0.0) {
                    this.speedLimit = thing.get("speedLimit").getAsInt();
                    Traincraft.itsChannel.sendToAllAround((IMessage)new PacketSetSpeed(this.speedLimit, 0, 0, 0, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
                if (thing.get("speedChange").getAsBoolean()) {
                    this.xSpeedLimitChange = thing.get("nextSpeedLimitChangeX").getAsDouble();
                    this.ySpeedLimitChange = thing.get("nextSpeedLimitChangeY").getAsDouble();
                    this.zSpeedLimitChange = thing.get("nextSpeedLimitChangeZ").getAsDouble();
                    Traincraft.itnsChannel.sendToAllAround((IMessage)new PacketNextSpeed(this.nextSpeedLimit, 0, 0, 0, this.xSpeedLimitChange, this.ySpeedLimitChange, this.zSpeedLimitChange, this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
                if (thing.get("endSoon").getAsBoolean() && !this.stationStop) {
                    this.xFromStopPoint = thing.get("xStopPoint").getAsDouble();
                    this.yFromStopPoint = thing.get("yStopPoint").getAsDouble();
                    this.zFromStopPoint = thing.get("zStopPoint").getAsDouble();
                    Traincraft.atoSetStopPoint.sendToAllAround((IMessage)new PacketATOSetStopPoint(this.func_145782_y(), this.xFromStopPoint, this.yFromStopPoint, this.zFromStopPoint, this.xStationStop, this.yStationStop, this.zStationStop), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
                if (thing.get("stationStopSoon").getAsBoolean() && !this.stationStop) {
                    this.xStationStop = thing.get("xStationStop").getAsDouble();
                    this.yStationStop = thing.get("yStationStop").getAsDouble();
                    this.zStationStop = thing.get("zStationStop").getAsDouble();
                    Traincraft.atoSetStopPoint.sendToAllAround((IMessage)new PacketATOSetStopPoint(this.func_145782_y(), this.xFromStopPoint, this.yFromStopPoint, this.zFromStopPoint, this.xStationStop, this.yStationStop, this.zStationStop), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
                if (thing.get("atoStatus") != null) {
                    this.atoStatus = thing.get("atoStatus").getAsInt();
                    Traincraft.atoChannel.sendToAllAround((IMessage)new PacketATO(this.func_145782_y(), thing.get("atoStatus").getAsInt()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
            } else if (thing.get("funct").getAsString().equals("startrun")) {
                if (this.field_70154_o != null) {
                    Minecraft.func_71410_x().field_71439_g.func_71165_d("ATO start requested from W-MTC server. ");
                }
                if (this.trainIsATOSupported().booleanValue()) {
                    this.atoStatus = 1;
                    Traincraft.atoChannel.sendToAllAround((IMessage)new PacketATO(this.func_145782_y(), thing.get("atoStatus").getAsInt()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
                }
            }
        }
    }

    @Override
    public void sendMessage(PDMMessage message) {
        if (Loader.isModLoaded((String)"ComputerCraft") && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            AxisAlignedBB targetBox = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 2000.0), (double)(this.field_70163_u + 2000.0), (double)(this.field_70161_v + 2000.0));
            List allTEs = this.field_70170_p.field_147482_g;
            for (Object te : allTEs) {
                System.out.println(te.getClass());
                if (!(te instanceof TilePDMInstructionRadio)) continue;
                TilePDMInstructionRadio teP = (TilePDMInstructionRadio)te;
                if (!teP.uniqueID.equals(PDMMessage.UUIDTo)) continue;
                teP.receiveMessage(message);
            }
        }
    }

    public void attemptConnection(String theServerUUID) {
        if (this.trainIsWMTCSupported().booleanValue() && this.field_70170_p != null && !this.field_70170_p.field_72995_K && theServerUUID != null && !this.serverUUID.equals(theServerUUID) && !this.canBePulled) {
            JsonObject sendTo = new JsonObject();
            sendTo.addProperty("funct", "attemptconnection");
            sendTo.addProperty("trainType", this.trainLevel);
            this.sendMessage(new PDMMessage(this.trainID, theServerUUID, sendTo.toString(), 0));
        }
    }

    public Boolean trainIsWMTCSupported() {
        Boolean support = false;
        Integer whichOneToCheck = 0;
        if (this instanceof SteamTrain) {
            whichOneToCheck = 2;
        }
        if (!(this instanceof SteamTrain)) {
            whichOneToCheck = 1;
        }
        if (this.getInventory()[whichOneToCheck] != null) {
            support = this.getInventory()[whichOneToCheck].func_77973_b() instanceof ItemWirelessTransmitter ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (this instanceof EntityLocoDieselSD40 || this instanceof EntityLocoElectricBP4 || this instanceof EntityLocoDieselClass66 || this instanceof EntityLocoElectricBR185 || this instanceof EntityLocoElectricCD151 || this instanceof EntityLocoDieselDD35A || this instanceof EntityLocoElectricICE1 || this instanceof EntityLocoElectricHighSpeedZeroED || this instanceof EntityLocoElectricE103 || this instanceof EntityLocoDieselV60_DB || this instanceof EntityLocoDieselCD742 || this instanceof EntityLocoElectricVL10 || this instanceof EntityLocoElectricTramNY || this instanceof EntityLocoDieselIC4_DSB_MG || this instanceof EntityLocoDieselSD70 || support.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean trainIsATOSupported() {
        if (this instanceof EntityLocoElectricHighSpeedZeroED || this instanceof EntityLocoElectricTramNY || this instanceof EntityLocoElectricICE1 || this instanceof EntityLocoDieselIC4_DSB_MG) {
            return true;
        }
        return false;
    }

    public void disconnectFromServer() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            JsonObject sendTo = new JsonObject();
            sendTo.addProperty("funct", "disconnect");
            this.sendMessage(new PDMMessage(this.trainID, this.serverUUID, sendTo.toString(), 0));
            this.mtcType = 1;
            this.serverUUID = "";
            this.isConnected = false;
        }
    }
}

