/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.api.Locomotive;
import train.common.core.handlers.ConfigHandler;

public class SpeedHandler {
    public static float handleSpeed(float railMaxSpeed, float maxSpeed, Entity entity) {
        if (entity instanceof Locomotive) {
            if (railMaxSpeed < 0.4f) {
                return Math.min(SpeedHandler.convertSpeed(entity, maxSpeed), railMaxSpeed);
            }
            if (railMaxSpeed > 0.45f && railMaxSpeed < 1.1f) {
                return SpeedHandler.convertSpeed(entity, maxSpeed) + 0.2f;
            }
            return SpeedHandler.convertSpeed(entity, maxSpeed);
        }
        return 15.0f;
    }

    public static boolean isSpeedRailAt(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block != null && block.getClass().getName().equals("IRailSpeed")) {
            return true;
        }
        TileEntity tile = world.func_147438_o(i, j, k);
        return tile != null && tile.getClass().getName().equals("IRailSpeed");
    }

    public double speedXFromPitch(EntityPlayer player, double var3) {
        return (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI))) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    public double speedZFromPitch(EntityPlayer player, double var3) {
        return (double)MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    private static float convertSpeed(Entity entity, float maxSpeed) {
        float speed = ((Locomotive)entity).getMaxSpeed() * 0.2775f;
        return (speed /= ConfigHandler.REAL_TRAIN_SPEED ? 2.0f : 6.0f) / 10.0f;
    }
}

