/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.tracks.ITrackEmitter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import train.common.blocks.tracks.TrackBaseTraincraft;
import train.common.entity.rollingStock.EntityStockCar;
import train.common.entity.rollingStock.EntityStockCarDRWG;
import train.common.library.Tracks;

public class BlockMobBoardingTrack
extends TrackBaseTraincraft
implements ITrackEmitter {
    private byte delay = 0;

    @Override
    public Tracks getTrackType() {
        return Tracks.MOB_BOARDING_TRACK;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (cart instanceof EntityStockCar || cart instanceof EntityStockCarDRWG) {
            if (cart.field_70153_n != null) {
                return;
            }
            AxisAlignedBB box = null;
            box = cart.field_70121_D.func_72314_b(4.0, 4.0, 4.0);
            List list = this.getWorld().func_72839_b((Entity)cart, box);
            if (list != null && list.size() > 0) {
                for (int j1 = 0; j1 < list.size(); ++j1) {
                    Entity entity = (Entity)list.get(j1);
                    if (!(entity instanceof EntityCreature)) continue;
                    entity.func_70078_a((Entity)cart);
                    this.setTrackPowering();
                }
            }
        }
    }

    @Override
    public void updateEntity() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.delay > 0) {
            this.delay = (byte)(this.delay - 1);
            if (this.delay == 0) {
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public IIcon getIcon() {
        if (this.delay > 0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    protected void notifyNeighbors() {
        Block block = this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), block);
        this.getWorld().func_147459_d(this.getX(), this.getY() - 1, this.getZ(), block);
        this.markBlockNeedsUpdate();
    }

    protected void setTrackPowering() {
        boolean notify = this.delay == 0;
        this.delay = (byte)3;
        if (notify) {
            this.notifyNeighbors();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74774_a("delay", this.delay);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.delay = nbttagcompound.func_74771_c("delay");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.delay);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.delay = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public int getPowerOutput() {
        return this.delay > 0 ? 15 : 0;
    }
}

