/*
 * Decompiled with CFR 0.152.
 */
package train.common.core;

import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;

public class HandleMaxAttachedCarts {
    public static void PullPhysic(Locomotive cart1) {
        double maxSpeed;
        double totalMass = 0.0;
        if (cart1.train != null && cart1.train.getTrains().size() != 0) {
            for (int j1 = 0; j1 < cart1.train.getTrains().size(); ++j1) {
                totalMass += cart1.train.getTrains().get((int)j1).mass;
            }
            cart1.currentNumCartsPulled = cart1.train.getTrains().size() - 1;
            cart1.currentMassPulled = Math.round(totalMass * 10.0);
        } else {
            totalMass = 0.0;
            cart1.currentNumCartsPulled = 0;
            cart1.currentMassPulled = 0.0;
        }
        totalMass = totalMass < 0.0 ? 0.0 : (totalMass *= 0.745);
        double power = 0.0;
        if (cart1.train != null && cart1.train.getTrains().size() != 0 && cart1.train.getTrains().size() > 1) {
            power = cart1.getPower();
            for (int i = 0; i < cart1.train.getTrains().size(); ++i) {
                EntityRollingStock stock = cart1.train.getTrains().get(i);
                if (!(stock instanceof Locomotive) || stock.uniqueID == cart1.uniqueID) continue;
                power += (double)((Locomotive)stock).getPower();
            }
            maxSpeed = cart1.getMaxSpeed();
            if ((maxSpeed -= totalMass == 0.0 ? 0.0 : totalMass / (power / 74.57)) > 0.0) {
                cart1.setCustomSpeed(maxSpeed);
            } else {
                cart1.setCustomSpeed(0.1);
            }
            cart1.currentSpeedSlowDown = totalMass == 0.0 ? 0.0 : totalMass / (power / 74.57);
        } else if (cart1.train == null || cart1.train.getTrains().size() < 2) {
            maxSpeed = cart1.getMaxSpeed();
            cart1.setCustomSpeed(maxSpeed);
            cart1.currentSpeedSlowDown = 0.0;
        }
        double scaledPower = totalMass == 0.0 ? 0.0 : totalMass / (power / 745.7);
        scaledPower = HandleMaxAttachedCarts.scalePower(scaledPower);
        double accelerate = cart1.setAccel(0.0);
        if (power * totalMass > 0.0) {
            accelerate -= scaledPower * totalMass * 1.13;
        }
        if (accelerate > 0.0) {
            cart1.setAccel(accelerate);
        }
        cart1.currentAccelSlowDown = power * totalMass > 0.0 ? scaledPower * (totalMass * 1.13) : 0.0;
        double brake = cart1.setBrake(0.0);
        if ((brake += scaledPower * totalMass) > 1.0) {
            brake = 0.998;
        }
        if (brake > 0.0 && power * totalMass > 0.0) {
            cart1.setBrake(brake);
        }
        cart1.currentBrakeSlowDown = power * totalMass > 0.0 ? scaledPower * totalMass : 0.0;
        int fuelRate = cart1.setFuelConsumption(0);
        if ((fuelRate -= (int)(scaledPower * totalMass * 100.0)) > 0) {
            cart1.setFuelConsumption(fuelRate);
        }
        cart1.currentFuelConsumptionChange = power * totalMass > 0.0 ? (double)fuelRate : 0.0;
    }

    @Deprecated
    private double convertPower(double power) {
        power /= 1000.0;
        power = 1.0 - power;
        return power;
    }

    private static double scalePower(double power) {
        if (power == 0.0) {
            return 0.0;
        }
        power /= 1000.0;
        return power *= 0.8;
    }
}

