/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.util;

import net.minecraft.block.BlockRailBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;

public class TraincraftUtil {
    public static final double degrees = 57.29577951308232;
    public static final double radian = Math.PI / 180;

    public static Item getItemFromName(String name) {
        if (Item.field_150901_e.func_148741_d(name)) {
            return (Item)Item.field_150901_e.func_82594_a(name);
        }
        return null;
    }

    public static ItemStack getItemFromUnlocalizedName(String itemName, int meta) {
        Item item = TraincraftUtil.getItemFromName(itemName);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        return null;
    }

    public static byte getByteFromColor(String c) {
        if (c.equals("Black")) {
            return 0;
        }
        if (c.equals("Red")) {
            return 1;
        }
        if (c.equals("Green")) {
            return 2;
        }
        if (c.equals("Brown")) {
            return 3;
        }
        if (c.equals("Blue")) {
            return 4;
        }
        if (c.equals("Purple")) {
            return 5;
        }
        if (c.equals("Cyan")) {
            return 6;
        }
        if (c.equals("LightGrey")) {
            return 7;
        }
        if (c.equals("Grey")) {
            return 8;
        }
        if (c.equals("Magenta")) {
            return 13;
        }
        if (c.equals("Lime")) {
            return 10;
        }
        if (c.equals("Yellow")) {
            return 11;
        }
        if (c.equals("LightBlue")) {
            return 12;
        }
        if (c.equals("Pink")) {
            return 9;
        }
        if (c.equals("Orange")) {
            return 14;
        }
        if (c.equals("White")) {
            return 15;
        }
        if (c.equals("Full")) {
            return 101;
        }
        if (c.equals("Empty")) {
            return 100;
        }
        return 0;
    }

    public static byte[] getBytesFromColors(String[] c) {
        byte[] ret = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            ret[i] = TraincraftUtil.getByteFromColor(c[i]);
        }
        return ret;
    }

    public static boolean itemStackMatches(ItemStack item1, ItemStack item2) {
        return item1.func_77973_b() == item2.func_77973_b() && (item1.func_77960_j() == item2.func_77960_j() || item1.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == Short.MAX_VALUE);
    }

    public static boolean isRailBlockAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockRailBase;
    }

    public static void updateRider(EntityRollingStock transport, double distance, double yOffset) {
        if (transport.field_70153_n == null) {
            return;
        }
        double pitchRads = transport.anglePitchClient * (Math.PI / 180);
        double rotationCos1 = Math.cos(Math.toRadians(transport.renderYaw + (float)(transport instanceof Locomotive ? 90 : 180)));
        double rotationSin1 = Math.sin(Math.toRadians(transport.renderYaw + (float)(transport instanceof Locomotive ? 90 : 180)));
        if (transport.side.isServer()) {
            rotationCos1 = Math.cos(Math.toRadians(transport.serverRealRotation + 90.0f));
            rotationSin1 = Math.sin(Math.toRadians(transport.serverRealRotation + 90.0f));
            transport.anglePitchClient = transport.serverRealPitch * 60.0f;
        }
        float pitch = (float)(transport.field_70163_u + (Math.tan(pitchRads) * distance + transport.func_70042_X()) + transport.field_70153_n.func_70033_W() + yOffset);
        double bogieX1 = transport.field_70165_t + rotationCos1 * distance;
        double bogieZ1 = transport.field_70161_v + rotationSin1 * distance;
        if (transport.anglePitchClient > 20.0 && rotationCos1 == 1.0) {
            bogieX1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (transport.anglePitchClient > 20.0 && rotationSin1 == 1.0) {
            bogieZ1 -= pitchRads * 2.0;
            pitch = (float)((double)pitch - pitchRads * 1.2);
        }
        if (pitchRads == 0.0) {
            transport.field_70153_n.func_70107_b(bogieX1, transport.field_70163_u + transport.func_70042_X() + transport.field_70153_n.func_70033_W() + yOffset, bogieZ1);
        }
        if (pitchRads > -1.01 && pitchRads < 1.01) {
            transport.field_70153_n.func_70107_b(bogieX1, (double)pitch, bogieZ1);
        }
    }
}

