/*
 * Decompiled with CFR 0.152.
 */
package train.common.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.blocks.BlockOpenHearthFurnace;
import train.common.inventory.TrainCraftingManager;
import train.common.library.BlockIDs;
import train.common.library.ItemIDs;
import train.common.tile.TileTraincraft;

public class TileEntityOpenHearthFurnace
extends TileTraincraft {
    private ForgeDirection facing;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    private int cookDuration = 600;
    private Random random = new Random();

    public TileEntityOpenHearthFurnace() {
        super(4, "Open Hearth Furnace");
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.furnaceCookTime * i / this.cookDuration;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookDuration;
        }
        return this.furnaceBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        this.cookDuration = TrainCraftingManager.instance.getHearthFurnaceRecipeDuration(this.slots[0], this.slots[1]);
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt() && this.slots[2] != null) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.slots[2]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.slots[2].func_77973_b().hasContainerItem(this.slots[2])) {
                        this.slots[2] = new ItemStack(this.slots[2].func_77973_b().func_77668_q());
                    } else {
                        --this.slots[2].field_77994_a;
                    }
                    if (this.slots[2].field_77994_a == 0) {
                        this.slots[2] = null;
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.cookDuration) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockOpenHearthFurnace.updateHearthFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.random);
            }
            this.syncTileEntity();
        }
        if (this.field_145850_b.field_72995_K && this.furnaceBurnTime > 0) {
            this.smoke(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.random);
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void smoke(World world, int i, int j, int k, Random random) {
        float var7 = (float)i + 0.5f;
        float var9 = (float)k + 0.5f;
        float f3 = 0.009f;
        double gaussian = random.nextGaussian() * (double)f3;
        for (int t = 0; t < 50; ++t) {
            world.func_72869_a("smoke", (double)var7, (double)j + (double)1.2f, (double)var9, gaussian, gaussian * (double)0.002f, gaussian);
        }
        world.func_72869_a("flame", (double)var7, (double)j + (double)1.03f, (double)var9, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 + 0.06, (double)j + (double)1.03f, (double)var9 + 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 - 0.06, (double)j + (double)1.03f, (double)var9 - 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 + 0.06, (double)j + (double)1.03f, (double)var9 - 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 - 0.06, (double)j + (double)1.03f, (double)var9 + 0.06, 0.0, 0.0, 0.0);
    }

    private boolean canSmelt() {
        if (this.slots[0] == null) {
            return false;
        }
        if (this.slots[1] == null) {
            return false;
        }
        ItemStack itemstack = TrainCraftingManager.instance.getHearthFurnaceRecipeResult(this.slots[0], this.slots[1]);
        return itemstack != null && (this.slots[3] == null || this.slots[3].func_77969_a(itemstack) && this.slots[3].field_77994_a < itemstack.func_77976_d());
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = TrainCraftingManager.instance.getHearthFurnaceRecipeResult(this.slots[0], this.slots[1]);
        if (this.slots[3] == null) {
            this.slots[3] = itemstack.func_77946_l();
        } else if (this.slots[3].func_77973_b() == itemstack.func_77973_b()) {
            this.slots[3].field_77994_a += itemstack.field_77994_a;
        }
        if (this.slots[0].func_77973_b().hasContainerItem(this.slots[0])) {
            this.slots[0] = new ItemStack(this.slots[0].func_77973_b().func_77668_q());
        } else {
            --this.slots[0].field_77994_a;
        }
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
        if (this.slots[1].func_77973_b().hasContainerItem(this.slots[1])) {
            this.slots[1] = new ItemStack(this.slots[1].func_77973_b().func_77668_q());
        } else {
            --this.slots[1].field_77994_a;
        }
        if (this.slots[1].field_77994_a <= 0) {
            this.slots[1] = null;
        }
    }

    private int getItemBurnTime(ItemStack it) {
        if (it == null) {
            return 0;
        }
        if (TileEntityFurnace.func_145952_a((ItemStack)it) > 0) {
            return TileEntityFurnace.func_145952_a((ItemStack)it);
        }
        Item var1 = it.func_77973_b();
        if (Item.func_150891_b((Item)var1) < 256 && Block.func_149634_a((Item)var1).func_149688_o() == Material.field_151575_d) {
            return 300;
        }
        if (var1 == Items.field_151055_y) {
            return 100;
        }
        if (var1 == Items.field_151044_h) {
            return 2600;
        }
        if (var1 == Items.field_151129_at) {
            return 20000;
        }
        if (var1 == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (var1 == Items.field_151072_bj) {
            return 2500;
        }
        if (var1 == Item.func_150898_a((Block)BlockIDs.oreTC.block) && it.func_77960_j() == 1) {
            return 2500;
        }
        if (var1 == Item.func_150898_a((Block)BlockIDs.oreTC.block) && it.func_77960_j() == 2) {
            return 2500;
        }
        if (var1 == ItemIDs.diesel.item) {
            return 4000;
        }
        if (var1 == ItemIDs.refinedFuel.item) {
            return 6000;
        }
        return GameRegistry.getFuelValue((ItemStack)it);
    }

    public ForgeDirection getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return ForgeDirection.NORTH;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean forSyncing) {
        super.writeToNBT(nbt, forSyncing);
        nbt.func_74774_a("Orientation", (byte)this.getFacing().ordinal());
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbt.func_74777_a("ItemBurnTime", (short)this.currentItemBurnTime);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, boolean forSyncing) {
        super.readFromNBT(nbt, forSyncing);
        this.facing = ForgeDirection.getOrientation((int)nbt.func_74771_c("Orientation"));
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = nbt.func_74765_d("ItemBurnTime");
    }
}

