/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.main.Utils;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockMine
extends BlockExplosive {
    public boolean cut;

    public BlockMine(Material par1Material, boolean cut) {
        super(par1Material);
        float f = 0.2f;
        float g = 0.1f;
        this.cut = cut;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, g * 2.0f / 2.0f + 0.1f, 0.5f + f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151579_a) {
            return;
        }
        this.explode(par1World, par2, par3, par4);
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151592_s && par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151570_A && par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151579_a && par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151568_F && par1World.func_147439_a(par2, par3 - 1, par4).func_149688_o() != Material.field_151585_k;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (player != null && player.field_71075_bZ.field_75098_d) {
                if (!mod_SecurityCraft.configHandler.mineExplodesWhenInCreative) {
                    return super.removedByPlayer(world, player, x, y, z, willHarvest);
                }
            }
            this.explode(world, x, y, z);
            return super.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        if (par5EntityPlayer.func_71045_bC() == null || !this.isInteractibleItem(par5EntityPlayer.func_71045_bC().func_77973_b())) {
            this.explode(par1World, par2, par3, par4);
            return false;
        }
        if (par5EntityPlayer.func_71045_bC().func_77973_b() == mod_SecurityCraft.wireCutters && par1World.func_147439_a(par2, par3, par4) == mod_SecurityCraft.Mine) {
            par1World.func_147449_b(par2, par3, par4, (Block)mod_SecurityCraft.MineCut);
            par5EntityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)par5EntityPlayer);
            return true;
        }
        if (par5EntityPlayer.func_71045_bC().func_77973_b() == Items.field_151033_d && par1World.func_147439_a(par2, par3, par4) == mod_SecurityCraft.MineCut) {
            par1World.func_147449_b(par2, par3, par4, (Block)mod_SecurityCraft.Mine);
            return true;
        }
        return false;
    }

    private boolean isInteractibleItem(Item item) {
        return item == mod_SecurityCraft.wireCutters || item == mod_SecurityCraft.remoteAccessMine || item == Items.field_151033_d;
    }

    public void func_149670_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par1World.field_72995_K) {
            return;
        }
        if (par5Entity instanceof EntityCreeper || par5Entity instanceof EntityOcelot || par5Entity instanceof EntityEnderman || par5Entity instanceof EntityItem) {
            return;
        }
        this.explode(par1World, par2, par3, par4);
    }

    public Explosion newExplosion(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9, boolean par10, World par11World) {
        Explosion explosion = new Explosion(par11World, par1Entity, par2, par4, par6, par8);
        explosion.field_77286_a = mod_SecurityCraft.configHandler.shouldSpawnFire;
        explosion.field_82755_b = par10;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Utils.BlockUtils.getItemFromBlock((Block)mod_SecurityCraft.Mine);
    }

    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Utils.BlockUtils.getItemFromBlock((Block)mod_SecurityCraft.Mine);
    }

    @Override
    public void activateMine(World world, int par2, int par3, int par4) {
        if (!world.field_72995_K) {
            world.func_147449_b(par2, par3, par4, (Block)mod_SecurityCraft.Mine);
        }
    }

    @Override
    public void defuseMine(World world, int par2, int par3, int par4) {
        if (!world.field_72995_K) {
            world.func_147449_b(par2, par3, par4, (Block)mod_SecurityCraft.MineCut);
        }
    }

    @Override
    public void explode(World par1World, int par2, int par3, int par4) {
        if (!this.cut) {
            par1World.func_147480_a(par2, par3, par4, false);
            if (mod_SecurityCraft.configHandler.smallerMineExplosion) {
                this.newExplosion(null, par2, par3, par4, 1.0f, true, true, par1World);
            } else {
                this.newExplosion(null, par2, par3, par4, 3.0f, true, true, par1World);
            }
        }
    }

    @Override
    public boolean isActive(World world, int par2, int par3, int par4) {
        return !this.cut;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = this.cut ? par1IconRegister.func_94245_a("securitycraft:mineCut") : par1IconRegister.func_94245_a("securitycraft:mine");
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityOwnable();
    }
}

