/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.interfaces;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;

public class CursorBox {
    private ArrayList<String> strings;
    private String language;
    private String fullCode = "";
    private int boxWidth = 150;
    private static final int color = -2147483640;

    public CursorBox(String code) {
        this.fullCode = code;
        String text = I18n.func_135052_a((String)code, (Object[])new Object[0]);
        this.createLines(text);
    }

    public void createLines(String text) {
        this.language = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        this.strings = new ArrayList();
        String[] words = text.split(" ");
        int spaceWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
        String line = "";
        int width = 0;
        for (int i = 0; i < words.length; ++i) {
            int wordWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(words[i]);
            if (width == 0 && wordWidth > this.boxWidth - 15) {
                this.boxWidth = wordWidth + 15;
            }
            if (width + wordWidth <= this.boxWidth - 15) {
                width += spaceWidth + wordWidth;
                line = line + words[i] + " ";
            } else {
                this.strings.add(line);
                line = new String("");
                width = 0;
                --i;
            }
            if (i != words.length - 1) continue;
            this.strings.add(line);
        }
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add("");
        }
    }

    public String getString(int line) {
        return this.strings.get(line);
    }

    public void drawBox(int x, int y, int width, int height) {
        try {
            if (!this.language.equals(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())) {
                this.createLines(I18n.func_135052_a((String)this.fullCode, (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int fix = x + this.boxWidth > width ? x + this.boxWidth - width : 0;
        int h = 5 + this.strings.size() * 10 + 5;
        int fiy = y + h > height ? y + h - height : 0;
        Gui.func_73734_a((int)(x - fix), (int)(y - fiy), (int)(x + this.boxWidth - fix), (int)(y + h - fiy), (int)-2147483640);
        for (int i = 0; i < this.strings.size(); ++i) {
            String s = this.getString(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a7f" + s, x + 10 - fix, y + 5 + 10 * i - fiy, 0xFFFFFF);
        }
    }
}

