/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.minimap;

import com.minimap.XaeroMinimap;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.minimap.Minimap;
import com.minimap.settings.ModSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class Waypoint {
    public int x;
    public int y;
    public int z;
    public String name;
    public String symbol;
    public int color;
    public boolean disabled = false;
    public int type = 0;
    public double lastDistance = 0.0;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public void drawIconInWorld(Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        int t;
        GL11.glScalef((float)XaeroMinimap.getSettings().waypointsScale, (float)XaeroMinimap.getSettings().waypointsScale, (float)1.0f);
        if (this.type == 0) {
            int c = ModSettings.COLORS[this.color];
            int l = c >> 16 & 0xFF;
            int i1 = c >> 8 & 0xFF;
            int j1 = c & 0xFF;
            GL11.glDisable((int)3553);
            int s = fontrenderer.func_78256_a(this.symbol) / 2;
            tessellator.func_78382_b();
            tessellator.func_78370_a(l, i1, j1, 120);
            tessellator.func_78377_a(-5.0, -9.0, 0.0);
            tessellator.func_78377_a(-5.0, 0.0, 0.0);
            tessellator.func_78377_a(4.0, 0.0, 0.0);
            tessellator.func_78377_a(4.0, -9.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(this.symbol, -s, -8, 0x20FFFFFF);
            fontrenderer.func_78276_b(this.symbol, -s, -8, -1);
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            tessellator.func_78382_b();
            tessellator.func_78370_a(256, 256, 256, 200);
            tessellator.func_78374_a(-5.0, -9.0, 0.0, 0.0, (double)(78.0f * f1));
            tessellator.func_78374_a(-5.0, 0.0, 0.0, 0.0, (double)(87.0f * f1));
            tessellator.func_78374_a(4.0, 0.0, 0.0, (double)(9.0f * f), (double)(87.0f * f1));
            tessellator.func_78374_a(4.0, -9.0, 0.0, (double)(9.0f * f), (double)(78.0f * f1));
            tessellator.func_78381_a();
            if (!showDistance) {
                name = this.getName();
                if (!XaeroMinimap.getSettings().keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        if (Minecraft.func_71410_x().func_152349_b()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            t = fontrenderer.func_78256_a(distance) / 2;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78370_a(0, 0, 0, 70);
            tessellator.func_78377_a((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)t, (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), 0x20FFFFFF);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), -1);
        }
        if (showingName) {
            t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_78276_b(name, -t, 1, 0x20FFFFFF);
            fontrenderer.func_78276_b(name, -t, 1, -1);
        }
    }

    public void drawIconOnGUI(int drawX, int drawY) {
        if (this.type == 0) {
            int rectX2 = drawX + 9;
            int rectY2 = drawY + 9;
            Gui.func_73734_a((int)drawX, (int)drawY, (int)rectX2, (int)rectY2, (int)ModSettings.COLORS[this.color]);
            int j = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.symbol) / 2;
            Minecraft.func_71410_x().field_71466_p.func_78261_a(this.symbol, drawX + 5 - j, drawY + 1, Minimap.radarPlayers.hashCode());
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(drawX, drawY, 0, 78, 9, 9);
        }
    }
}

