/*++

Copyright (c) 1995  Digital Equipment Corporation

Module Name:

    stdarg.h

Abstract:

    This header defines the ANSI C variable arguments interface.

Author:

    Dave Richards [DEC] 7-Sep-95

Revision History:

--*/

#ifndef _STDARG_H_
#define _STDARG_H_

typedef struct {
    char *a0;
    int offset;
} va_list;

void *__builtin_va_start(va_list, ...);

#define va_start(ap, parmN) \
        __builtin_va_start(ap, parmN, 1)

#define va_end(ap)

#define va_arg(ap, type) \
        (*(((ap).offset += ((int)sizeof (type) + 7) & ~7), \
           (type *)((ap).a0 + (ap).offset - \
                    ((__builtin_isfloat(type) && (ap).offset <= (6 * 8)) \
                         ? (6 * 8) + 8 \
                         : ((int)sizeof (type) + 7) & ~7))))

#endif /* _STDARG_H_ */
