/*++

Copyright (c) 1997 Digital Equipment Corporation

Module Name:

    pciscan.c

Abstract:

    Simple ARC app that will scan the PCI bus and display a list of the devices
    on the bus.

    Note: You need to have access to the NT DDK which has ntddk.h. The BusNumber
    does not need to be scan to 10. Since we do not have a way of getting the
    number of buses present in the system, we need to pick a high number to make
    sure all the buses will be scanned.


Author:

    Scott Lee (leesc) Jul-3-1997

Revision History:

--*/

#include "ntddk.h" // or "miniport.h" . Note: They must be put ahead of ADK header files.
#include "arc.h"
#include "vendor.h"
#include "errno.h"

//
// Function prototype.
//

VOID
FlushAndWaitForKeypress(
    VOID 
    );

VOID
ScanPciBus(
   VOID
   );

LONG 
main (LONG Argcm,PUCHAR Argvm[],PUCHAR Envp[])
   
{

    //
    // Announce the program.
    //

    Print("PCI Scan V1.0\n\r\n\r");

    //
    // Scan the bus.
    //

    ScanPciBus();
   
    return 0;

}

//
// Wait for a key.
//

VOID
FlushAndWaitForKeypress(
    VOID 
    )

/*++

Routine Description:

    Flush keyboard buffer and wait for any key.

Arguments:

    None.

Return Value:

    None.

--*/
{
    UCHAR Character;
    ULONG Count;

    //
    // Flush the keyboard buffer.
    //

    while (GetReadStatus(StandardIn) == ESUCCESS) {

        //
        // Read a character.
        //

        Read(StandardIn, &Character, 1, &Count);

        //
        // Add a slight delay.
        //

        StallExecution(100);

    }

    //
    // Wait for key stroke.
    //

    while (GetReadStatus(StandardIn) != ESUCCESS) {

    }

    Read(StandardIn, &Character, 1, &Count);

}

VOID
ScanPciBus(
   VOID
   )
{
    BOOLEAN PrintBusNum = TRUE;
    ULONG BusNumber;
    ULONG DeviceNumber;
    ULONG Length;
    PCI_SLOT_NUMBER PciSlot;
    PCI_COMMON_CONFIG PciCommonConfig;

    for (BusNumber = 0; BusNumber < 10; BusNumber++) {

      for (DeviceNumber = 0; DeviceNumber < 32; DeviceNumber++) {

	PciSlot.u.AsULONG = 0;
	PciSlot.u.bits.DeviceNumber = DeviceNumber;

	Length = GetBusDataByOffset(PCIConfiguration,
				       BusNumber,
				       PciSlot.u.AsULONG,
				       &PciCommonConfig,
				       0,
				       0x40);

	if (Length != 0x40)
	  continue;

	if (PrintBusNum) {

	  Print("\r\nScanning PCI Bus %d.\r\n", BusNumber);
	  PrintBusNum = FALSE;

	}

	//
        // We have a valid slot. Display the slot number, vendor and device id.
	//

        Print("DeviceNumber %d: VendorId = 0x%x DeviceId = 0x%x.\r\n", 
		 DeviceNumber, PciCommonConfig.VendorID, 
		 PciCommonConfig.DeviceID);

      }

      PrintBusNum = TRUE;
      Print("\r\nPress a key to scan the next bus.\r\n");
      FlushAndWaitForKeypress();

    }

}


