/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (Config.isCustomSky()) {
            worldSkyLayers = CustomSky.readCustomSkies();
        }
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] acustomskylayer = new CustomSkyLayer[10][0];
        String s2 = "mcpatcher/sky/world";
        int i2 = -1;
        for (int j2 = 0; j2 < acustomskylayer.length; ++j2) {
            String s1 = s2 + j2 + "/sky";
            ArrayList<CustomSkyLayer> list = new ArrayList<CustomSkyLayer>();
            for (int k2 = 1; k2 < 1000; ++k2) {
                String s22 = s1 + k2 + ".properties";
                try {
                    jy resourcelocation = new jy(s22);
                    InputStream inputstream = Config.getResourceStream(resourcelocation);
                    if (inputstream == null) break;
                    PropertiesOrdered properties = new PropertiesOrdered();
                    properties.load(inputstream);
                    inputstream.close();
                    Config.dbg("CustomSky properties: " + s22);
                    String s3 = s1 + k2 + ".png";
                    CustomSkyLayer customskylayer = new CustomSkyLayer(properties, s3);
                    if (!customskylayer.isValid(s22)) continue;
                    jy resourcelocation1 = new jy(customskylayer.source);
                    bmk itextureobject = TextureUtils.getTexture(resourcelocation1);
                    if (itextureobject == null) {
                        Config.log("CustomSky: Texture not found: " + resourcelocation1);
                        continue;
                    }
                    customskylayer.textureId = itextureobject.b();
                    list.add(customskylayer);
                    inputstream.close();
                    continue;
                }
                catch (FileNotFoundException var15) {
                    break;
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                }
            }
            if (list.size() <= 0) continue;
            CustomSkyLayer[] acustomskylayer2 = list.toArray(new CustomSkyLayer[list.size()]);
            acustomskylayer[j2] = acustomskylayer2;
            i2 = j2;
        }
        if (i2 < 0) {
            return null;
        }
        int l2 = i2 + 1;
        CustomSkyLayer[][] acustomskylayer1 = new CustomSkyLayer[l2][0];
        for (int i1 = 0; i1 < acustomskylayer1.length; ++i1) {
            acustomskylayer1[i1] = acustomskylayer[i1];
        }
        return acustomskylayer1;
    }

    public static void renderSky(adm world, bmj re2, float partialTicks) {
        CustomSkyLayer[] acustomskylayer;
        int i2;
        if (worldSkyLayers != null && (i2 = world.t.q()) >= 0 && i2 < worldSkyLayers.length && (acustomskylayer = worldSkyLayers[i2]) != null) {
            long j2 = world.L();
            int k2 = (int)(j2 % 24000L);
            float f2 = world.c(partialTicks);
            float f1 = world.j(partialTicks);
            float f22 = world.h(partialTicks);
            if (f1 > 0.0f) {
                f22 /= f1;
            }
            for (int l2 = 0; l2 < acustomskylayer.length; ++l2) {
                CustomSkyLayer customskylayer = acustomskylayer[l2];
                if (!customskylayer.isActive(world, k2)) continue;
                customskylayer.render(world, k2, f2, f1, f22);
            }
            float f3 = 1.0f - f1;
            Blender.clearBlend(f3);
        }
    }

    public static boolean hasSkyLayers(adm world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int i2 = world.t.q();
        if (i2 >= 0 && i2 < worldSkyLayers.length) {
            CustomSkyLayer[] acustomskylayer = worldSkyLayers[i2];
            return acustomskylayer == null ? false : acustomskylayer.length > 0;
        }
        return false;
    }
}

