/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import net.optifine.shaders.SMath;
import net.optifine.shaders.Shaders;

public class ClippingHelperShadow
extends bid {
    private static ClippingHelperShadow instance = new ClippingHelperShadow();
    float[] frustumTest = new float[6];
    float[][] shadowClipPlanes = new float[10][4];
    int shadowClipPlaneCount;
    float[] matInvMP = new float[16];
    float[] vecIntersection = new float[4];

    public boolean b(double x1, double y1, double z1, double x2, double y2, double z2) {
        for (int i2 = 0; i2 < this.shadowClipPlaneCount; ++i2) {
            float[] afloat = this.shadowClipPlanes[i2];
            if (!(this.dot4(afloat, x1, y1, z1) <= 0.0) || !(this.dot4(afloat, x2, y1, z1) <= 0.0) || !(this.dot4(afloat, x1, y2, z1) <= 0.0) || !(this.dot4(afloat, x2, y2, z1) <= 0.0) || !(this.dot4(afloat, x1, y1, z2) <= 0.0) || !(this.dot4(afloat, x2, y1, z2) <= 0.0) || !(this.dot4(afloat, x1, y2, z2) <= 0.0) || !(this.dot4(afloat, x2, y2, z2) <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private double dot4(float[] plane, double x2, double y2, double z2) {
        return (double)plane[0] * x2 + (double)plane[1] * y2 + (double)plane[2] * z2 + (double)plane[3];
    }

    private double dot3(float[] vecA, float[] vecB) {
        return (double)vecA[0] * (double)vecB[0] + (double)vecA[1] * (double)vecB[1] + (double)vecA[2] * (double)vecB[2];
    }

    public static bid getInstance() {
        instance.init();
        return instance;
    }

    private void normalizePlane(float[] plane) {
        float f2 = ns.c(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
        plane[0] = plane[0] / f2;
        plane[1] = plane[1] / f2;
        plane[2] = plane[2] / f2;
        plane[3] = plane[3] / f2;
    }

    private void normalize3(float[] plane) {
        float f2 = ns.c(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
        if (f2 == 0.0f) {
            f2 = 1.0f;
        }
        plane[0] = plane[0] / f2;
        plane[1] = plane[1] / f2;
        plane[2] = plane[2] / f2;
    }

    private void assignPlane(float[] plane, float a2, float b2, float c2, float d2) {
        float f2 = (float)Math.sqrt(a2 * a2 + b2 * b2 + c2 * c2);
        plane[0] = a2 / f2;
        plane[1] = b2 / f2;
        plane[2] = c2 / f2;
        plane[3] = d2 / f2;
    }

    private void copyPlane(float[] dst, float[] src) {
        dst[0] = src[0];
        dst[1] = src[1];
        dst[2] = src[2];
        dst[3] = src[3];
    }

    private void cross3(float[] out, float[] a2, float[] b2) {
        out[0] = a2[1] * b2[2] - a2[2] * b2[1];
        out[1] = a2[2] * b2[0] - a2[0] * b2[2];
        out[2] = a2[0] * b2[1] - a2[1] * b2[0];
    }

    private void addShadowClipPlane(float[] plane) {
        this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], plane);
    }

    private float length(float x2, float y2, float z2) {
        return (float)Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
    }

    private float distance(float x1, float y1, float z1, float x2, float y2, float z2) {
        return this.length(x1 - x2, y1 - y2, z1 - z2);
    }

    private void makeShadowPlane(float[] shadowPlane, float[] positivePlane, float[] negativePlane, float[] vecSun) {
        this.cross3(this.vecIntersection, positivePlane, negativePlane);
        this.cross3(shadowPlane, this.vecIntersection, vecSun);
        this.normalize3(shadowPlane);
        float f2 = (float)this.dot3(positivePlane, negativePlane);
        float f1 = (float)this.dot3(shadowPlane, negativePlane);
        float f22 = this.distance(shadowPlane[0], shadowPlane[1], shadowPlane[2], negativePlane[0] * f1, negativePlane[1] * f1, negativePlane[2] * f1);
        float f3 = this.distance(positivePlane[0], positivePlane[1], positivePlane[2], negativePlane[0] * f2, negativePlane[1] * f2, negativePlane[2] * f2);
        float f4 = f22 / f3;
        float f5 = (float)this.dot3(shadowPlane, positivePlane);
        float f6 = this.distance(shadowPlane[0], shadowPlane[1], shadowPlane[2], positivePlane[0] * f5, positivePlane[1] * f5, positivePlane[2] * f5);
        float f7 = this.distance(negativePlane[0], negativePlane[1], negativePlane[2], positivePlane[0] * f2, positivePlane[1] * f2, positivePlane[2] * f2);
        float f8 = f6 / f7;
        shadowPlane[3] = positivePlane[3] * f4 + negativePlane[3] * f8;
    }

    public void init() {
        float[] afloat = this.b;
        float[] afloat1 = this.c;
        float[] afloat2 = this.d;
        System.arraycopy(Shaders.faProjection, 0, afloat, 0, 16);
        System.arraycopy(Shaders.faModelView, 0, afloat1, 0, 16);
        SMath.multiplyMat4xMat4(afloat2, afloat1, afloat);
        this.assignPlane(this.a[0], afloat2[3] - afloat2[0], afloat2[7] - afloat2[4], afloat2[11] - afloat2[8], afloat2[15] - afloat2[12]);
        this.assignPlane(this.a[1], afloat2[3] + afloat2[0], afloat2[7] + afloat2[4], afloat2[11] + afloat2[8], afloat2[15] + afloat2[12]);
        this.assignPlane(this.a[2], afloat2[3] + afloat2[1], afloat2[7] + afloat2[5], afloat2[11] + afloat2[9], afloat2[15] + afloat2[13]);
        this.assignPlane(this.a[3], afloat2[3] - afloat2[1], afloat2[7] - afloat2[5], afloat2[11] - afloat2[9], afloat2[15] - afloat2[13]);
        this.assignPlane(this.a[4], afloat2[3] - afloat2[2], afloat2[7] - afloat2[6], afloat2[11] - afloat2[10], afloat2[15] - afloat2[14]);
        this.assignPlane(this.a[5], afloat2[3] + afloat2[2], afloat2[7] + afloat2[6], afloat2[11] + afloat2[10], afloat2[15] + afloat2[14]);
        float[] afloat3 = Shaders.shadowLightPositionVector;
        float f2 = (float)this.dot3(this.a[0], afloat3);
        float f1 = (float)this.dot3(this.a[1], afloat3);
        float f22 = (float)this.dot3(this.a[2], afloat3);
        float f3 = (float)this.dot3(this.a[3], afloat3);
        float f4 = (float)this.dot3(this.a[4], afloat3);
        float f5 = (float)this.dot3(this.a[5], afloat3);
        this.shadowClipPlaneCount = 0;
        if (f2 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[0]);
            if (f2 > 0.0f) {
                if (f22 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[0], this.a[2], afloat3);
                }
                if (f3 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[0], this.a[3], afloat3);
                }
                if (f4 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[0], this.a[4], afloat3);
                }
                if (f5 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[0], this.a[5], afloat3);
                }
            }
        }
        if (f1 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[1]);
            if (f1 > 0.0f) {
                if (f22 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[1], this.a[2], afloat3);
                }
                if (f3 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[1], this.a[3], afloat3);
                }
                if (f4 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[1], this.a[4], afloat3);
                }
                if (f5 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[1], this.a[5], afloat3);
                }
            }
        }
        if (f22 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[2]);
            if (f22 > 0.0f) {
                if (f2 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[2], this.a[0], afloat3);
                }
                if (f1 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[2], this.a[1], afloat3);
                }
                if (f4 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[2], this.a[4], afloat3);
                }
                if (f5 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[2], this.a[5], afloat3);
                }
            }
        }
        if (f3 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[3]);
            if (f3 > 0.0f) {
                if (f2 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[3], this.a[0], afloat3);
                }
                if (f1 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[3], this.a[1], afloat3);
                }
                if (f4 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[3], this.a[4], afloat3);
                }
                if (f5 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[3], this.a[5], afloat3);
                }
            }
        }
        if (f4 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[4]);
            if (f4 > 0.0f) {
                if (f2 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[4], this.a[0], afloat3);
                }
                if (f1 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[4], this.a[1], afloat3);
                }
                if (f22 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[4], this.a[2], afloat3);
                }
                if (f3 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[4], this.a[3], afloat3);
                }
            }
        }
        if (f5 >= 0.0f) {
            this.copyPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[5]);
            if (f5 > 0.0f) {
                if (f2 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[5], this.a[0], afloat3);
                }
                if (f1 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[5], this.a[1], afloat3);
                }
                if (f22 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[5], this.a[2], afloat3);
                }
                if (f3 < 0.0f) {
                    this.makeShadowPlane(this.shadowClipPlanes[this.shadowClipPlaneCount++], this.a[5], this.a[3], afloat3);
                }
            }
        }
    }
}

