/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.BlockAlias;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

public class BlockAliases {
    private static BlockAlias[][] blockAliases = null;
    private static PropertiesOrdered blockLayerPropertes = null;
    private static boolean updateOnResourcesReloaded;

    public static int getBlockAliasId(int blockId, int metadata) {
        if (blockAliases == null) {
            return blockId;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return blockId;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        if (aliases == null) {
            return blockId;
        }
        for (int i2 = 0; i2 < aliases.length; ++i2) {
            BlockAlias ba2 = aliases[i2];
            if (!ba2.matches(blockId, metadata)) continue;
            return ba2.getBlockAliasId();
        }
        return blockId;
    }

    public static void resourcesReloaded() {
        if (!updateOnResourcesReloaded) {
            return;
        }
        updateOnResourcesReloaded = false;
        BlockAliases.update(Shaders.getShaderPack());
    }

    public static void update(IShaderPack shaderPack) {
        BlockAliases.reset();
        if (shaderPack == null) {
            return;
        }
        if (Reflector.Loader_getActiveModList.exists() && ave.A().R() == null) {
            Config.dbg("[Shaders] Delayed loading of block mappings after resources are loaded");
            updateOnResourcesReloaded = true;
            return;
        }
        ArrayList<List<BlockAlias>> listBlockAliases = new ArrayList<List<BlockAlias>>();
        String path = "/shaders/block.properties";
        InputStream in2 = shaderPack.getResourceAsStream(path);
        if (in2 != null) {
            BlockAliases.loadBlockAliases(in2, path, listBlockAliases);
        }
        BlockAliases.loadModBlockAliases(listBlockAliases);
        if (listBlockAliases.size() <= 0) {
            return;
        }
        blockAliases = BlockAliases.toArrays(listBlockAliases);
    }

    private static void loadModBlockAliases(List<List<BlockAlias>> listBlockAliases) {
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                jy loc = new jy(modId, "shaders/block.properties");
                InputStream in2 = Config.getResourceStream(loc);
                BlockAliases.loadBlockAliases(in2, loc.toString(), listBlockAliases);
                continue;
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
    }

    private static void loadBlockAliases(InputStream in2, String path, List<List<BlockAlias>> listBlockAliases) {
        if (in2 == null) {
            return;
        }
        try {
            in2 = MacroProcessor.process(in2, path);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            Config.dbg("[Shaders] Parsing block mappings: " + path);
            ConnectedParser cp2 = new ConnectedParser("Shaders");
            Set<Object> keys = ((Properties)props).keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                if (string.startsWith("layer.")) {
                    if (blockLayerPropertes == null) {
                        blockLayerPropertes = new PropertiesOrdered();
                    }
                    blockLayerPropertes.put(string, val);
                    continue;
                }
                String prefix = "block.";
                if (!string.startsWith(prefix)) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                String blockIdStr = StrUtils.removePrefix(string, prefix);
                int blockId = Config.parseInt(blockIdStr, -1);
                if (blockId < 0) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                MatchBlock[] matchBlocks = cp2.parseMatchBlocks(val);
                if (matchBlocks == null || matchBlocks.length < 1) {
                    Config.warn("[Shaders] Invalid block ID mapping: " + string + "=" + val);
                    continue;
                }
                BlockAlias ba2 = new BlockAlias(blockId, matchBlocks);
                BlockAliases.addToList(listBlockAliases, ba2);
            }
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static void addToList(List<List<BlockAlias>> blocksAliases, BlockAlias ba2) {
        int[] blockIds = ba2.getMatchBlockIds();
        for (int i2 = 0; i2 < blockIds.length; ++i2) {
            int blockId = blockIds[i2];
            while (blockId >= blocksAliases.size()) {
                blocksAliases.add(null);
            }
            List<BlockAlias> blockAliases = blocksAliases.get(blockId);
            if (blockAliases == null) {
                blockAliases = new ArrayList<BlockAlias>();
                blocksAliases.set(blockId, blockAliases);
            }
            BlockAlias baBlock = new BlockAlias(ba2.getBlockAliasId(), ba2.getMatchBlocks(blockId));
            blockAliases.add(baBlock);
        }
    }

    private static BlockAlias[][] toArrays(List<List<BlockAlias>> listBlocksAliases) {
        BlockAlias[][] bas2 = new BlockAlias[listBlocksAliases.size()][];
        for (int i2 = 0; i2 < bas2.length; ++i2) {
            List<BlockAlias> listBlockAliases = listBlocksAliases.get(i2);
            if (listBlockAliases == null) continue;
            bas2[i2] = listBlockAliases.toArray(new BlockAlias[listBlockAliases.size()]);
        }
        return bas2;
    }

    public static PropertiesOrdered getBlockLayerPropertes() {
        return blockLayerPropertes;
    }

    public static void reset() {
        blockAliases = null;
        blockLayerPropertes = null;
    }
}

