/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.Signal;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultFutureListeners;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GenericProgressiveFutureListener;
import io.netty.util.concurrent.ProgressiveFuture;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final int MAX_LISTENER_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> LISTENER_STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final Signal SUCCESS = new Signal(DefaultPromise.class.getName() + ".SUCCESS");
    private static final Signal UNCANCELLABLE = new Signal(DefaultPromise.class.getName() + ".UNCANCELLABLE");
    private final EventExecutor executor;
    private volatile Object result;
    private Object listeners;
    private short waiters;

    public DefaultPromise(EventExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    private static boolean isCancelled0(Object result) {
        return result instanceof CauseHolder && ((CauseHolder)result).cause instanceof CancellationException;
    }

    @Override
    public boolean isCancellable() {
        return this.result == null;
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    private static boolean isDone0(Object result) {
        return result != null && result != UNCANCELLABLE;
    }

    @Override
    public boolean isSuccess() {
        Object result = this.result;
        if (result == null || result == UNCANCELLABLE) {
            return false;
        }
        return !(result instanceof CauseHolder);
    }

    @Override
    public Throwable cause() {
        Object result = this.result;
        if (result instanceof CauseHolder) {
            return ((CauseHolder)result).cause;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            DefaultPromise.notifyListener(this.executor(), this, listener);
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners == null) {
                    this.listeners = listener;
                } else if (this.listeners instanceof DefaultFutureListeners) {
                    ((DefaultFutureListeners)this.listeners).add(listener);
                } else {
                    GenericFutureListener firstListener = (GenericFutureListener)this.listeners;
                    this.listeners = new DefaultFutureListeners(firstListener, listener);
                }
                return this;
            }
        }
        DefaultPromise.notifyListener(this.executor(), this, listener);
        return this;
    }

    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future<? super V>> l : listeners) {
            if (l == null) break;
            this.addListener((GenericFutureListener)l);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners instanceof DefaultFutureListeners) {
                    ((DefaultFutureListeners)this.listeners).remove(listener);
                } else if (this.listeners == listener) {
                    this.listeners = null;
                }
            }
        }
        return this;
    }

    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future<? super V>> l : listeners) {
            if (l == null) break;
            this.removeListener((GenericFutureListener)l);
        }
        return this;
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        PlatformDependent.throwException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                Object var3_2;
                this.checkDeadLock();
                this.incWaiters();
                try {
                    this.wait();
                    var3_2 = null;
                    this.decWaiters();
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    this.decWaiters();
                    throw throwable;
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Promise<V> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        boolean interrupted = false;
        DefaultPromise defaultPromise = this;
        // MONITORENTER : defaultPromise
        while (true) {
            Object var5_4;
            if (this.isDone()) {
                // MONITOREXIT : defaultPromise
                if (!interrupted) return this;
                Thread.currentThread().interrupt();
                return this;
            }
            this.checkDeadLock();
            this.incWaiters();
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    var5_4 = null;
                    this.decWaiters();
                    continue;
                }
                var5_4 = null;
                this.decWaiters();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.decWaiters();
                throw throwable;
            }
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        block23: {
            block22: {
                block21: {
                    if (this.isDone()) {
                        return true;
                    }
                    if (timeoutNanos <= 0L) {
                        return this.isDone();
                    }
                    if (interruptable && Thread.interrupted()) {
                        throw new InterruptedException(this.toString());
                    }
                    startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
                    waitTime = timeoutNanos;
                    interrupted = false;
                    try {
                        var9_6 = this;
                        synchronized (var9_6) {
                            if (this.isDone()) {
                                var10_7 = true;
                                // MONITOREXIT @DISABLED, blocks:[16, 0, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var9_6
                                var15_12 = null;
                                if (interrupted == false) return var10_7;
                                Thread.currentThread().interrupt();
                                return var10_7;
                            }
                            if (waitTime <= 0L) {
                                var10_8 = this.isDone();
                                // MONITOREXIT @DISABLED, blocks:[0, 20, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var9_6
                                break block21;
                            }
                            this.checkDeadLock();
                            this.incWaiters();
                            while (true) {
                                try {
                                    try {
                                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                                    }
                                    catch (InterruptedException e) {
                                        if (interruptable) {
                                            throw e;
                                        }
                                        interrupted = true;
                                    }
                                    if (!this.isDone()) continue;
                                    var10_10 = true;
                                    var12_17 = null;
                                    this.decWaiters();
                                    break block22;
                                }
                                catch (Throwable var11_20) {
                                    var12_19 = null;
                                    this.decWaiters();
                                    throw var11_20;
                                }
                                break;
                            }
                            {
                                if ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L) ** continue;
                                var10_11 = this.isDone();
                                var12_18 = null;
                                this.decWaiters();
                            }
                        }
                        break block23;
                    }
                    catch (Throwable var14_21) {
                        var15_16 = null;
                        if (interrupted == false) throw var14_21;
                        Thread.currentThread().interrupt();
                        throw var14_21;
                    }
                }
                var15_13 = null;
                if (interrupted == false) return var10_8;
                Thread.currentThread().interrupt();
                return var10_8;
            }
            var15_14 = null;
            if (interrupted == false) return var10_10;
            Thread.currentThread().interrupt();
            return var10_10;
        }
        var15_15 = null;
        if (interrupted == false) return var10_11;
        Thread.currentThread().interrupt();
        return var10_11;
    }

    protected void checkDeadLock() {
        EventExecutor e = this.executor();
        if (e != null && e.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    @Override
    public Promise<V> setSuccess(V result) {
        if (this.setSuccess0(result)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V result) {
        if (this.setSuccess0(result)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    @Override
    public Promise<V> setFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already: " + this, cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object result = this.result;
        if (DefaultPromise.isDone0(result) || result == UNCANCELLABLE) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            result = this.result;
            if (DefaultPromise.isDone0(result) || result == UNCANCELLABLE) {
                return false;
            }
            this.result = new CauseHolder(new CancellationException());
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setUncancellable() {
        Object result = this.result;
        if (DefaultPromise.isDone0(result)) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            result = this.result;
            if (DefaultPromise.isDone0(result)) {
                return false;
            }
            this.result = UNCANCELLABLE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFailure0(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.isDone()) {
                return false;
            }
            this.result = new CauseHolder(cause);
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSuccess0(V result) {
        if (this.isDone()) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.isDone()) {
                return false;
            }
            this.result = result == null ? SUCCESS : result;
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    @Override
    public V getNow() {
        Object result = this.result;
        if (result instanceof CauseHolder || result == SUCCESS) {
            return null;
        }
        return (V)result;
    }

    private boolean hasWaiters() {
        return this.waiters > 0;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Integer stackDepth;
        Object listeners = this.listeners;
        if (listeners == null) {
            return;
        }
        this.listeners = null;
        EventExecutor executor = this.executor();
        if (executor.inEventLoop() && (stackDepth = LISTENER_STACK_DEPTH.get()) < 8) {
            LISTENER_STACK_DEPTH.set(stackDepth + 1);
            try {
                if (listeners instanceof DefaultFutureListeners) {
                    DefaultPromise.notifyListeners0(this, (DefaultFutureListeners)listeners);
                } else {
                    GenericFutureListener l = (GenericFutureListener)listeners;
                    DefaultPromise.notifyListener0(this, l);
                }
                Object var6_6 = null;
                LISTENER_STACK_DEPTH.set(stackDepth);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                LISTENER_STACK_DEPTH.set(stackDepth);
                throw throwable;
            }
            return;
        }
        try {
            if (listeners instanceof DefaultFutureListeners) {
                final DefaultFutureListeners dfl = (DefaultFutureListeners)listeners;
                executor.execute(new Runnable(){

                    public void run() {
                        DefaultPromise.notifyListeners0(DefaultPromise.this, dfl);
                    }
                });
            } else {
                final GenericFutureListener l = (GenericFutureListener)listeners;
                executor.execute(new Runnable(){

                    public void run() {
                        DefaultPromise.notifyListener0(DefaultPromise.this, l);
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.error("Failed to notify listener(s). Event loop shut down?", t);
        }
    }

    private static void notifyListeners0(Future<?> future, DefaultFutureListeners listeners) {
        GenericFutureListener<? extends Future<?>>[] a = listeners.listeners();
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            DefaultPromise.notifyListener0(future, a[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyListener(EventExecutor eventExecutor, final Future<?> future, final GenericFutureListener<?> l) {
        Integer stackDepth;
        if (eventExecutor.inEventLoop() && (stackDepth = LISTENER_STACK_DEPTH.get()) < 8) {
            LISTENER_STACK_DEPTH.set(stackDepth + 1);
            try {
                DefaultPromise.notifyListener0(future, l);
                Object var5_5 = null;
                LISTENER_STACK_DEPTH.set(stackDepth);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                LISTENER_STACK_DEPTH.set(stackDepth);
                throw throwable;
            }
            return;
        }
        try {
            eventExecutor.execute(new Runnable(){

                public void run() {
                    DefaultPromise.notifyListener0(future, l);
                }
            });
        }
        catch (Throwable t) {
            logger.error("Failed to notify a listener. Event loop shut down?", t);
        }
    }

    static void notifyListener0(Future future, GenericFutureListener l) {
        block2: {
            try {
                l.operationComplete(future);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + l.getClass().getName() + ".operationComplete()", t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object progressiveListeners() {
        Object listeners = this.listeners;
        if (listeners == null) {
            return null;
        }
        if (listeners instanceof DefaultFutureListeners) {
            void var7_12;
            DefaultFutureListeners dfl = (DefaultFutureListeners)listeners;
            int progressiveSize = dfl.progressiveSize();
            switch (progressiveSize) {
                case 0: {
                    return null;
                }
                case 1: {
                    for (GenericFutureListener<Future<?>> genericFutureListener : dfl.listeners()) {
                        if (!(genericFutureListener instanceof GenericProgressiveFutureListener)) continue;
                        return genericFutureListener;
                    }
                    return null;
                }
            }
            GenericFutureListener<? extends Future<?>>[] array = dfl.listeners();
            GenericProgressiveFutureListener[] copy = new GenericProgressiveFutureListener[progressiveSize];
            int i = 0;
            boolean bl = false;
            while (var7_12 < progressiveSize) {
                GenericFutureListener<Future<?>> l = array[i];
                if (l instanceof GenericProgressiveFutureListener) {
                    copy[++var7_12] = (GenericProgressiveFutureListener)l;
                }
                ++i;
            }
            return copy;
        }
        if (listeners instanceof GenericProgressiveFutureListener) {
            return listeners;
        }
        return null;
    }

    void notifyProgressiveListeners(final long progress, final long total) {
        Object listeners = this.progressiveListeners();
        if (listeners == null) {
            return;
        }
        final ProgressiveFuture self = (ProgressiveFuture)((Object)this);
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            if (listeners instanceof GenericProgressiveFutureListener[]) {
                DefaultPromise.notifyProgressiveListeners0(self, (GenericProgressiveFutureListener[])listeners, progress, total);
            } else {
                DefaultPromise.notifyProgressiveListener0(self, (GenericProgressiveFutureListener)listeners, progress, total);
            }
        } else {
            try {
                if (listeners instanceof GenericProgressiveFutureListener[]) {
                    final GenericProgressiveFutureListener[] array = (GenericProgressiveFutureListener[])listeners;
                    executor.execute(new Runnable(){

                        public void run() {
                            DefaultPromise.notifyProgressiveListeners0(self, array, progress, total);
                        }
                    });
                } else {
                    final GenericProgressiveFutureListener l = (GenericProgressiveFutureListener)listeners;
                    executor.execute(new Runnable(){

                        public void run() {
                            DefaultPromise.notifyProgressiveListener0(self, l, progress, total);
                        }
                    });
                }
            }
            catch (Throwable t) {
                logger.error("Failed to notify listener(s). Event loop shut down?", t);
            }
        }
    }

    private static void notifyProgressiveListeners0(ProgressiveFuture<?> future, GenericProgressiveFutureListener<?>[] listeners, long progress, long total) {
        for (GenericProgressiveFutureListener<?> l : listeners) {
            if (l == null) break;
            DefaultPromise.notifyProgressiveListener0(future, l, progress, total);
        }
    }

    private static void notifyProgressiveListener0(ProgressiveFuture future, GenericProgressiveFutureListener l, long progress, long total) {
        block2: {
            try {
                l.operationProgressed(future, progress, total);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + l.getClass().getName() + ".operationProgressed()", t);
            }
        }
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(StringUtil.simpleClassName(this));
        buf.append('@');
        buf.append(Integer.toHexString(this.hashCode()));
        Object result = this.result;
        if (result == SUCCESS) {
            buf.append("(success)");
        } else if (result == UNCANCELLABLE) {
            buf.append("(uncancellable)");
        } else if (result instanceof CauseHolder) {
            buf.append("(failure(");
            buf.append(((CauseHolder)result).cause);
            buf.append(')');
        } else {
            buf.append("(incomplete)");
        }
        return buf;
    }

    private static final class CauseHolder {
        final Throwable cause;

        private CauseHolder(Throwable cause) {
            this.cause = cause;
        }
    }
}

