#import "NTMBWindow.h"

@implementation NTMBWindow

- (void)setSticky: (BOOL)flag {
	CGSConnectionID cid;
	CGSWindowID wid;
	
	wid = [self windowNumber];
	cid = _CGSDefaultConnection();
	int tags[2] = { 0, 0 };
	
	if (!CGSGetWindowTags(cid, wid, tags, 32)) {
		if (flag) {
			tags[0] = tags[0] | 0x00000800;
		} else {
			tags[0] = tags[0] & ~0x00000800;
		}
		CGSSetWindowTags(cid, wid, tags, 32);
	}
}

- (BOOL)canBecomeKeyWindow {
	return NO;
}

- (BOOL)canBecomeMainWindow {
	return NO;
}

- (BOOL)ignoresMouseEvents {
	return YES;
}

@end
