#import <appkit/appkit.h>
#import "Brush.h"

@implementation Brush


// required methods:

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
          fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
          return nil;
     }
     else
          return self;
}

// This is method, all is about:
// It operates on the image data coming from CIC.
// Do your specific processing here, it is only method you need to modify.
// The supplied source sets all activated channels of the selection to zero.

- (float)processImage:(IMAGE_INFO *)imageInfo selectionMode:(int)selMode percentBar:percentBar
{
     BOOL		ignore = (selMode >= SEL_ALL_COL ? NO : YES);
     register int	i,j;
     unsigned int	v1,v2,v3,v4,v5;
     float		upper[5],lower[5];
     float		weight;
     register unsigned char color1,color2,color3,color4,color5;
	id		processor;


     switch(imageInfo->colorSpace){
     case NX_RGBColorSpace:
          NXConvertColorToRGBA([upperColorWell color],&upper[0],&upper[1],&upper[2],&upper[3]);
          NXConvertColorToRGBA([lowerColorWell color],&lower[0],&lower[1],&lower[2],&lower[3]);
          break;
     case NX_CMYKColorSpace:
          NXConvertColorToCMYKA([upperColorWell color],&upper[0],&upper[1],&upper[2],&upper[3],&upper[4]);
          NXConvertColorToCMYKA([lowerColorWell color],&lower[0],&lower[1],&lower[2],&lower[3],&lower[4]);
          break;
     default:
          NXConvertColorToGrayAlpha([upperColorWell color],&upper[0],&upper[1]);
          NXConvertColorToGrayAlpha([lowerColorWell color],&lower[0],&lower[1]);
          break;
     }

	if([PressureButton state])
		weight = pencilPressure/255.0;
	else
     	weight = (maxShots > 1 ? (float)(currentShot+1)/(float)maxShots : 0.0);
     color1 = weight*lower[0]*255.0+(1-weight)*upper[0]*255.0+.5;
     color2 = weight*lower[1]*255.0+(1-weight)*upper[1]*255.0+.5;
     color3 = weight*lower[2]*255.0+(1-weight)*upper[2]*255.0+.5;
     color4 = weight*lower[3]*255.0+(1-weight)*upper[3]*255.0+.5;
     color5 = weight*lower[4]*255.0+(1-weight)*upper[4]*255.0+.5;

	if(processor = [[NXApp delegate] fasterProcessorFor:self]){
		int	arg1 = color1;
		int	arg2 = color2;
		int	arg3 = color3;
		int	arg4 = color4;
		return([processor run:self onImage:imageInfo selMode:selMode percentBar:percentBar args:self,&arg1,&arg2,&arg3,&arg4,NULL]);
	}

     switch(imageInfo->info.image.samplesPerPixel){
     case 1:
          for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
               if(ignore)
                    for(i=start;i<end;i+=step)
                         *(channel1+i)  = color1;
               else
                    for(i=start;i<end;i+=step)
                         if((v1 = *(channel1+i)) >= select1 && v1 <= range1){
                              *(channel1+i)     = color1;
                              ++match;
                         }
               start    = end;
          }
          break;
     case 2:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= color1;
					     if(f_c2) *(channel2+i)= color2;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2)){
						   if(f_c1) *(channel1+i)= color1;
						   if(f_c2) *(channel2+i)= color2;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 3:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= color1;
					     if(f_c2) *(channel2+i)= color2;
					     if(f_c3) *(channel3+i)= color3;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3)){
						   if(f_c1) *(channel1+i)= color1;
						   if(f_c2) *(channel2+i)= color2;
						   if(f_c3) *(channel3+i)= color3;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 4:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= color1;
					     if(f_c2) *(channel2+i)= color2;
					     if(f_c3) *(channel3+i)= color3;
					     if(f_c4) *(channel4+i)= color4;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(channel4+i)) >= select4 && v4 <= range4)){
						   if(f_c1) *(channel1+i)= color1;
						   if(f_c2) *(channel2+i)= color2;
						   if(f_c3) *(channel3+i)= color3;
						   if(f_c4) *(channel4+i)= color4;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 5:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= color1;
					     if(f_c2) *(channel2+i)= color2;
					     if(f_c3) *(channel3+i)= color3;
					     if(f_c4) *(channel4+i)= color4;
					     if(f_c5) *(channel5+i)= color5;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(channel4+i)) >= select4 && v4 <= range4) &&\
						     ((v5=*(channel5+i)) >= select5 && v5 <= range5)){
						   if(f_c1) *(channel1+i)= color1;
						   if(f_c2) *(channel2+i)= color2;
						   if(f_c3) *(channel3+i)= color3;
						   if(f_c4) *(channel4+i)= color4;
						   if(f_c5) *(channel5+i)= color5;
						         ++match;
					      }
			start= end;
		   }
	    break;
     }

     if(ignore)
	    return(1.0);
     else
	    return((float)match/(float)bytesPerChannel);
}

- actionView
{
     return actionView;
}


// optional methods:

- channelMatrix
{
     return channelMatrix;
}

- (const char *)moduleName
{
     return [stringTable valueForStringKey:"moduleName"];
}

@end
