#import <appkit/appkit.h>
#import "CIC_Defines.h"
#import "TesterView.h"
#import MODULE_H_FILE

@implementation TesterView

- drawSelf:(NXRect *)rects :(int)count
{
     [image draw];
     return self;
}

- openTIFF:sender
{
     char               file[MAXPATHLEN];
     const char         *const *files;
     static const char  *const imageType[4] = {"tiff"};
     id                 openpanel = [[OpenPanel new] allowMultipleFiles:NO];


     if([openpanel runModalForTypes:imageType])
	  if((files = [openpanel filenames]) && *files){
               (void)strcat(strcat(strcpy(file,[openpanel directory]),"/"),*files);
	       if(image)
		    [image free];
	       if(image = [[NXBitmapImageRep alloc] initFromFile:file]){
		    [image getSize:&imageSize];
		    [self sizeTo:imageSize.width:imageSize.height];
		    [[[self display] window] makeKeyAndOrderFront:self];
		    [[self setUpImageInfo] computeGlobals];
	       }
	       else
		    NXRunAlertPanel("Open Image","Error loading image!","Cancel",NULL,NULL);
	       if([image bitsPerSample] != 8)
		    NXRunAlertPanel("Open Image","8 bit wide data channels required!","Cancel",NULL,NULL);
          }
     
     return self;
}

- setUpImageInfo
{
     data = imageInfo.data             = [(NXBitmapImageRep *)image data];
     imageInfo.angle                   = 0.0;
     imageInfo.dpi                     = [image pixelsWide]*DEFAULT_DPI/imageSize.width;
     imageInfo.cmykUcr                 = 0;
     imageInfo.extractionFactor        = 1;
     imageInfo.imageRect.origin.x      = imageInfo.imageRect.origin.y    = 0.0;
     imageInfo.imageRect.size.width    = imageInfo.info.image.width   = [image pixelsWide];
     imageInfo.imageRect.size.height   = imageInfo.info.image.height  = [image pixelsHigh];
     imageInfo.contentRect             = imageInfo.imageRect;
     imageInfo.info.image.samplesPerPixel = [image samplesPerPixel];
     imageInfo.info.image.planarConfig = ([image isPlanar] ? NX_PLANAR : NX_MESHED);
     imageInfo.info.image.bitsPerSample= 8;
     imageInfo.hasAlpha                = [image hasAlpha];
     imageInfo.colorSpace              = [image colorSpace];
     imageInfo.cmykUcr                 = 0;
     imageInfo.bytesPerPlane           = [image bytesPerPlane];
     imageInfo.bytesInImage            = ([image isPlanar] ? [image bytesPerPlane]*[image samplesPerPixel] : [image bytesPerPlane]);

     undoSize = imageInfo.bytesInImage;
     if(backup_data)
	  backup_data = (unsigned char *)realloc(backup_data,undoSize);
     else{
	  NXRect Rect;
	  myModule = [[MODULE_CLASS alloc] initFromPath:DEFAULT_PATH];
	  [actionView getFrame:&Rect];
	  [[myModule actionView] setFrame:&Rect];
	  [[actionPanel contentView] replaceSubview:actionView with:[myModule actionView]];
	  [[actionPanel makeKeyAndOrderFront:self] display];
	  backup_data = (unsigned char *)malloc(undoSize);
     }
     
     return self;
}

- computeGlobals
{
     bytesPerPlane = imageInfo.bytesPerPlane;
     if(imageInfo.info.image.planarConfig == NX_PLANAR){
          channel1 = data;                      channel2 = data+bytesPerPlane;
          channel3 = data+bytesPerPlane*2;      channel4 = data+bytesPerPlane*3;
          channel5 = data+bytesPerPlane*4;
          backup_channel1 = backup_data;                backup_channel2 = backup_data+bytesPerPlane;
          backup_channel3 = backup_data+bytesPerPlane*2;backup_channel4 = backup_data+bytesPerPlane*3;
          backup_channel5 = backup_data+bytesPerPlane*4;
          step          = 1;
     }
     else{
          channel1      = data;                 channel2        = data+1;
          channel3      = data+2;               channel4        = data+3;
          channel5      = data+4;
          backup_channel1       = backup_data;  backup_channel2 = backup_data+1;
          backup_channel3       = backup_data+2;backup_channel4 = backup_data+3;
          backup_channel5       = backup_data+4;
          step          = imageInfo.info.image.samplesPerPixel;
     }
     bytesPerChannel    = bytesPerPlane/step;
	select1 = select2 = select3 = select4 = select5 = 0;
	range1 = range2 = range3 = range4 = range5 = 255;

     percent_step = bytesPerPlane/(N_PERCENTSTEPS+1);
     while(percent_step%step)
          --percent_step;

     return self;
}

- (int)colorChannels:matrix ssp:(int)ssp
{
     int        row,col,channels = 0;

     if([[matrix cellAt:1:2] state] == NO){
          for(row=0;row<2;row++)
               for(col=0;col<3;col++)
                    if([[matrix cellAt:row:col] state] == YES)
                         channels |= 1<<(row*3+col);
     }
     else
          channels = (1<<ssp)-1;

     return(channels);
}

- computeDynamicGlobals
{
     int activeChannels = ([[myModule class] instancesRespondTo:@selector(channelMatrix)] ? [self colorChannels:[myModule channelMatrix] ssp:imageInfo.info.image.samplesPerPixel] : 31);

     f_c1 = activeChannels & 1;
     f_c2 = activeChannels & 2;
     f_c3 = activeChannels & 4;
     f_c4 = activeChannels & 8;
     f_c5 = 0;
     if(activeChannels & 16)
          switch(imageInfo.colorSpace){
          case NX_RGBColorSpace: f_c4 = 1;break;
          case NX_CMYKColorSpace: f_c5 = 1;break;
          default: f_c2 = 1;
          }
     start = end = 0;

     return self;
}

- do:sender
{
     [self computeDynamicGlobals];
     bcopy(imageInfo.data,backup_data,undoSize);
     [myModule processImage:&imageInfo selectionMode:SEL_ALL percentBar:self];

     return [self display];
}

- undo:sender
{
     if(undoSize == imageInfo.bytesInImage){
	  bcopy(backup_data,imageInfo.data,undoSize);
	  [self display];
     }

     return self;
}

- showPercentage:(int)percent
{
     if(percent < 0 || percent > 100)
	  NXRunAlertPanel("Process Image","Percent value exceeded valid range!",NULL,NULL,NULL);
     return self;
}

- fasterProcessorFor:module
{
	return nil;
}

- (float)run:module onImage:(IMAGE_INFO *)imageInfo selMode:(int)selMode percentBar:percentBar args:(void *)args, ...
{
	  NXRunAlertPanel("Process Image","Execution on faster processor. Really want this?",NULL,NULL,NULL);
	return(0.0);
}

@end
