#import <appkit/appkit.h>
#import "CIC_Module.h"		// Replace "CIC_Module" with your module's name

@implementation CIC_Module	// Again, put your module name here

// required methods:

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
          fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
          return nil;
     }
     else
          return self;
}

// This is method, all is about:
// It operates on the image data coming from CIC.
// Do your specific processing here, it is only method you need to modify.

- (float)processImage:(IMAGE_INFO *)imageInfo selectionMode:(int)selMode percentBar:percentBar
{
     BOOL			ignore = (selMode >= SEL_ALL_COL ? NO : YES);
     int			x,y,offset;
     int			resx = imageInfo->info.image.width,resy = imageInfo->info.image.height;
     register unsigned char     v1,v2,v3,v4,v5;
     int			j;


     percent_step = resy/(N_PERCENTSTEPS+1);
     start	= end = 0;
     resx	*= step;

     match	= 0;
     switch(imageInfo->info.image.samplesPerPixel){
     case 1:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    offset = y*resx;
		    for(x=0;x<resx;x++){
			 if(ignore || ((v1 = *(backup_channel1+offset)) >= select1 && v1 <= range1)){
			      // your code goes here...
			      ++match;
			 }
			 ++offset;
		    }
	       }
	       start	= end;
	  }
	  break;
     case 2:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(backup_channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(backup_channel2+offset)) >= select2 && v2 <= range2)){
			      // your code goes here...
			      ++match;
			 }
			 offset += step;
		    }
	       }
	       start	= end;
	  }
	  break;
     case 3:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(backup_channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(backup_channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(backup_channel3+offset)) >= select3 && v3 <= range3)){
			      // your code goes here...
			      ++match;
			 }
			 offset += step;
		    }
	       }
	       start	= end;
	  }
	  break;
     case 4:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(backup_channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(backup_channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(backup_channel3+offset)) >= select3 && v3 <= range3 &&\
				      (v4 = *(backup_channel4+offset)) >= select4 && v4 <= range4)){
			      // your code goes here...
			      ++match;
			 }
			 offset += step;
		    }
	       }
	       start	= end;
	  }
	  break;
     case 5:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
	       [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
	       end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(backup_channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(backup_channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(backup_channel3+offset)) >= select3 && v3 <= range3 &&\
				      (v4 = *(backup_channel4+offset)) >= select4 && v4 <= range4 &&\
				      (v5 = *(backup_channel5+offset)) >= select5 && v5 <= range5)){
			      // your code goes here...
			      ++match;
			 }
			 offset += step;
		    }
	       }
	       start	= end;
	  }
	  break;
     }

     if(ignore)
	  return(1.0);
     else
	  return((float)match/(float)bytesPerChannel);
}

- actionView
{
     return actionView;
}


// optional methods:

- channelMatrix
{
     return channelMatrix;
}

- (const char *)moduleName
{
     return [stringTable valueForStringKey:"moduleName"];
}

- readData:(float *)data
{
     return self;
}

- writeData:(float *)data
{
     return self;
}

- willBeDisplayed:(IMAGE_INFO *)imageInfo;
{
     return self;
}

@end
