#import <appkit/appkit.h>
#import "RandomImage.h"

@implementation RandomImage

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
          fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
          return nil;
     }
     else
          return self;
}

- (BOOL)getImage:(IMAGE_INFO *)imageInfo
{
     NXTIFFInfo	*info = &imageInfo->info;
	int			i,dataSize;
	unsigned char *data;
	  int		imageTypeTag,dpi,widthUnit,heightUnit,width,height;


	  [NXApp runModalFor:actionWindow];
	  [actionWindow orderOut:self];

	  imageTypeTag = [typeMatrix selectedTag];
	  dpi = [dpiFormCell intValue];
	  widthUnit = [[widthUnitPopUp target] indexOfItem:[widthUnitPopUp title]];
	  heightUnit = [[heightUnitPopUp target] indexOfItem:[heightUnitPopUp title]];

	  if(!(width = [widthFormCell intValue]) || !(height = [heightFormCell intValue]))
	       return(NO);

	  if(dpi <= 0)
	       dpi = DEFAULT_DPI;
	     imageInfo->dpi		= dpi;
     	imageInfo->extractionFactor = 1;
	  info->imageNumber		= 0;
	  info->numImages		= 0;
	  info->compression		= NX_TIFF_COMPRESSION_NONE;
	  info->image.width		= (widthUnit == UNITS_NONE ? width : (widthUnit == UNITS_CENTIMETERS ? width*dpi/25.4 : width*dpi));
	  info->image.height	= (heightUnit == UNITS_NONE ? height : (heightUnit == UNITS_CENTIMETERS ? height*dpi/25.4 : height*dpi));
	  info->image.bitsPerSample 	= 8;
	  info->image.planarConfig	= NX_MESHED;
	  info->image.samplesPerPixel 	= (!imageTypeTag ? 3 : (imageTypeTag == 1) ? 4 : 1);
	  imageInfo->hasAlpha	= [alphaButton intValue];
	  if(imageInfo->hasAlpha)
	       ++info->image.samplesPerPixel;
	  info->image.photoInterp	= (!imageTypeTag ? NX_COLORMASK : (imageTypeTag == 1 ? NX_CMYKColorSpace : NX_MONOTONICMASK)) | (imageInfo->hasAlpha ? NX_ALPHAMASK : 0);
	  imageInfo->colorSpace	= (!imageTypeTag ? NX_RGBColorSpace : (imageTypeTag == 1 ? NX_CMYKColorSpace : NX_OneIsWhiteColorSpace));
	  dataSize = info->image.width*info->image.height*info->image.samplesPerPixel;

	  if((data = imageInfo->data = (unsigned char *)malloc((size_t)dataSize)) == NULL)
	  	return(NO);

	for(i=0;i<dataSize;i++)
		data[i] = random();

	strcpy(imageInfo->fname,[stringTable valueForStringKey:"filename"]);

	return(YES);
}

- stopModal:sender
{
     return [NXApp stopModal];
}

- (const char *)moduleName
{
     return [stringTable valueForStringKey:"moduleName"];
}

@end
