/* -*-C-*-
*******************************************************************************
*
* File:         Info.m
* RCS:          /usr/local/sources/CVS/EnhanceMail/Info.m,v 1.5 1997/11/07 02:23:07 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Fri Oct 13 11:48:05 1995
* Modified:      7-Nov-97 (Tom Hageman)
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "EnhanceMail.h"
#import "Info.h"

static id mod=nil;

@implementation EnhanceInfo

+ finishLoading:(struct mach_header *)header
{
   [self poseAs:[self superclass]];
   return self;
}

- (View *)_enhanceLogo
{
   /* create a(n almost) ready-to-insert button containing our enhance logo.
      Caller should still set frame origin. */
   char path[MAXPATHLEN+1];
   Button *button = nil;

   if ([EnhanceBundle getPath:path forResource:"e" ofType:"tiff"])
   {
      NXImage *image = [[NXImage allocFromZone:[self zone]] initFromFile:path];
      NXRect frame = {0};

      [image getSize:&frame.size];
      if (NX_WIDTH(&frame) && NX_HEIGHT(&frame))
      {
	 button = [[Button allocFromZone:[self zone]] init];
	 [button setBordered:NO];
	 [button setEnabled:NO];
	 [button setIconPosition:NX_ICONONLY];
	 [button setImage:image];
	 [button sizeToFit];
      }
   }
   return button;
}

- (View *)_enhanceFindTitleView
{
   /* Heuristically find Mail title field: assume it's a subview of
      infoPanel's contentview with -icon named "Mail". */
   List *views = [[infoPanel contentView] subviews];
   int i = [views count];

   while (--i >= 0)
   {
      id view = [views objectAt:i];

      if ([view respondsTo:@selector(icon)])
      {
	 const char *icon = [view icon];

	 if (icon && strcmp(icon, "Mail")==0) return view;
      }
   }
   return nil;
}

- (void)enhanceInsinuateVersion
{
   const char *old;
   char *new;
   NXRect or,nr;

   old=[versionField stringValue];
   [versionField getFrame:&or];
   new=alloca(strlen(old)+3+strlen(EnhanceVersion)+1+1);
   sprintf(new, "%s (e%s)", old, EnhanceVersion);
   [versionField setStringValue:new];
   [versionField sizeToFit];
   [versionField getFrame:&nr];
   [versionField moveBy:(NX_MAXX(&or) - NX_MAXX(&nr)):0];
}

- (void)enhanceInsinuateLogo
{
   /* release field may be before or after Mail title, depending on
      localization.  Insert our logo after the rightmost one. */
   NXRect logoFrame, releaseFrame, titleFrame = {0};
   View *logo = [self _enhanceLogo];

   [logo getFrame:&logoFrame];

   [releaseField getFrame:&releaseFrame];
   [[self _enhanceFindTitleView] getFrame:&titleFrame];

   if (NX_X(&releaseFrame) > NX_X(&titleFrame))
   {
      // XXX quick-n-dirty hard constants here.
      logoFrame.origin.x = NX_X(&releaseFrame) + 63;
      logoFrame.origin.y = NX_Y(&releaseFrame) + 11;
   }
   else
   {
      logoFrame.origin.x = NX_MAXX(&titleFrame) - 3;
      logoFrame.origin.y = NX_Y(&titleFrame) + 7;
   }
   [logo setFrame:&logoFrame];
   [[infoPanel contentView] addSubview:logo];
}

- enhance
{
   [self enhanceInsinuateVersion];
   [self enhanceInsinuateLogo];
   return self;
}

+ new
{
   id ret=[super new];
   if (mod!=ret) mod=[ret enhance];
   return ret;
}

@end // EnhanceInfo
