/* -*-C-*-
*******************************************************************************
*
* File:         PGP.h
* RCS:          /usr/local/sources/CVS/EnhanceMail/PGP.h,v 1.4 1997/11/09 01:57:58 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Fri Oct 13 11:48:24 1995
* Modified:     Sat Jun 29 18:58:23 1996 (Carl Edman) cedman@capitalist.princeton.edu
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import <appkit/appkit.h>

/*
 * The following error values were extracted from pgp.c of the PGP 2.6.3
 * distribution.
 */

#define EXIT_OK				0
#define INVALID_FILE_ERROR		1
#define FILE_NOT_FOUND_ERROR		2
#define UNKNOWN_FILE_ERROR		3
#define NO_BATCH			4
#define BAD_ARG_ERROR			5
#define INTERRUPT			6
#define OUT_OF_MEM			7

/* Keyring errors: Base value = 10 */
#define KEYGEN_ERROR			10
#define NONEXIST_KEY_ERROR		11
#define KEYRING_ADD_ERROR		12
#define KEYRING_EXTRACT_ERROR		13
#define KEYRING_EDIT_ERROR		14
#define KEYRING_VIEW_ERROR		15
#define KEYRING_REMOVE_ERROR		16
#define KEYRING_CHECK_ERROR		17
#define KEY_SIGNATURE_ERROR		18
#define KEYSIG_REMOVE_ERROR		19

/* Encode errors: Base value = 20 */
#define SIGNATURE_ERROR			20
#define RSA_ENCR_ERROR			21
#define ENCR_ERROR			22
#define COMPRESS_ERROR			23

/* Decode errors: Base value = 30 */
#define SIGNATURE_CHECK_ERROR		30
#define RSA_DECR_ERROR			31
#define DECR_ERROR			32
#define DECOMPRESS_ERROR		33

@interface EnhancePGP : Object
{
   id passPanel;
   id userField;
   id passField;
   
   id errPanel;
   id errText;
   id errDefaultButton;
   id errNonDefaultButton;

   time_t passTime;
   BOOL prevPassAsk;
}

+ new;

- (int)handleError:(const char *)err ok:(BOOL)defok;

- getUser:(const char **)user pass:(const char **)pass forEncoding:(BOOL)encode;
- clobberPass;

- reenter:sender;
- ok:sender;
- cancel:sender;

- (int)runPGP:(SimpleString *)In to:(SimpleString *)Out error:(SimpleString *)Err args:(const char **)argv;
- (BOOL)grabKey:(const char *)keyid;
- (BOOL)encodePGP:(MailMessage *)mes to:(StringList *)rcpt sign:(BOOL)sign encrypt:(BOOL)encrypt;
- (BOOL)decodePGP:(MailMessage *)mes;
@end
