/* -*-ObjC-*-
*******************************************************************************
*
* File:         TransferPanel.m
* RCS:          TransferPanel.m,v 1.8 1997/11/01 00:19:34 tom Exp
* Description:  
* Author:       Tom Hageman <tom@basil.icce.rug.nl>
* Created:      October 1996
* Modified:     
* Language:     Objective-C
* Package:      EnhanceMail
* Status:       Experimental
*
* Copyright (C) 1996, 1997 Tom Hageman, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/
#import "EnhanceMail.h"
#import "TransferPanel.h"
#import "Preferences.h"
#import "mailtoc.h"

static const char *fullmboxname(const char *name);

@implementation EnhanceTransferPanel

+ finishLoading:(struct mach_header *)header
{
   [self poseAs:[self superclass]];
   [[TransferPanel new] changeClassTo:[self class]];

   return self;
}

#if 0
+ new
{
   self = [super new];
   //printf("new: class = %s\n",[[self class] name]);

   return self;
}
#endif

static BOOL forceLoad=YES;

- (void)_updateBrowser:(BOOL)force

{
   Window *w = [browser window];

   forceLoad=force;
   //printf("updating Browser (force=%d)\n", force);
   [w disableDisplay];
   [browser validateVisibleColumns];
   [w reenableDisplay];
   [browser displayIfNeeded];
   [w flushWindow];
   forceLoad=YES;
}

- (void)updateBrowser
{
   [self _updateBrowser:YES];
}

- (void)updateBrowserForMailBoxNamed:(const char *)mailboxName
{
#if NOTYET
   EnhanceMailboxSummary *summary = [EnhanceMailboxSummary summaryForName:mailboxName];
   char path[MAXPATHLEN+1];
   int len = mailboxdir(path);

   mailboxName = [summary name];
   if (strncmp(path, mailboxName, len) == 0 && mailboxName[len] == '/')
   {
      strcpy(path, &mailboxName[len]);
      len = strlen(path);
      if (len > 5 && strcmp(&path[len-5], ".mbox")==0) path[len-5] = '\0';

      // XXX how to get cell at path without visual artefacts?

      long nUnread = [summary numNewMessages] + [summary numUnreadMessages];

      
   }
#endif
   [self _updateBrowser:NO];
}


- (BOOL)browser:sender columnIsValid:(int)column
	// delegate method, invoked by [browser validateVisibleColumns].
{
   if (![win isVisible]) return YES;
   //printf("validating column %d\n",column);
   return NO; // make this smarter, but it's usually fast enough for now
}

- windowDidBecomeKey:sender
{
///   [browser validateVisibleColumns];
///   [browser update];
   [self updateBrowser];
   return [super windowDidBecomeKey:sender];
}

- (int)browser:sender fillMatrix:matrix inColumn:(int)column
{
   [[matrix setPrototype:[[EnhanceMailboxBrowserCell allocFromZone:[matrix zone]] init]] free];
   return [super browser:sender fillMatrix:matrix inColumn:column];
}

// Do potentially time-consuming stuff in lazy browser delegate method.
- browser:sender loadCell:(EnhanceMailboxBrowserCell *)cell atRow:(int)row inColumn:(int)column
{
   if ([cell isLeaf])
   {
      unsigned long newUnread = EMS_LOADSUPPRESSED;

      if (EnhanceMaxTocCheckSize != 0)
      {
	 char path[MAXPATHLEN+1];
	 int pathlen;
	 EnhanceMailboxSummary *summary;

	 [sender getPath:path toColumn:column];
	 pathlen = strlen(path);
	 sprintf(&path[pathlen], "/%s", [cell stringValue]);
	 // (path+1) to skip leading '/'.
	 summary = [EnhanceMailboxSummary summaryForName:path+1];
	 if (forceLoad) [summary load];
	 if ((newUnread = [summary loadStatus]) == EMS_LOADED)
	 {
	    newUnread = [summary numNewMessages] + [summary numUnreadMessages];
	 }
      }
      [cell setUnread:newUnread];
   }
   return self;
}

#if 0 /* (What is this supposed to be doing, yoda ?-) */
- loadForm:sender
{
   id ret = [super loadForm:sender];
   const char *name = [form stringValueAt:0];
   printf("selected mailbox:%s\n",name);

   if (*name)
   {
      //puts("doing something");
      printf("unread:%d\n",(int)[[[EnhanceMailboxSummary alloc] initName:name] numUnreadMessages]);
   }
   return ret;
}
#endif

- (void)updateMessageCount:(unsigned)newMessageCount old:(unsigned)oldMessageCount
   forMailBoxNamed:(const char *)mailBoxName isNew:(BOOL)isNew
{
   EnhanceMailboxSummary *summary = [EnhanceMailboxSummary summaryForName:mailBoxName];
   long summaryUnread = [summary numUnreadMessages];
   long summaryNew = [summary numNewMessages];

///if ([summary load] != EMS_LOADED) return;
   if ([summary loadStatus] != EMS_LOADED) return;

   summaryUnread = [summary numUnreadMessages];
   summaryNew = [summary numNewMessages];

   // MailReader's messageCounts are totals of summary's (new + unread) counts.
   // Try to compensate for this.
   if (oldMessageCount != summaryUnread + summaryNew)
   {
      oldMessageCount = summaryUnread + summaryNew;
   }
   if (newMessageCount > oldMessageCount)
   {
      if (isNew)
      {
	 [summary setNewMessages:summaryNew + newMessageCount - oldMessageCount];
      }
      else
      {
	 [summary setUnreadMessages:summaryUnread + newMessageCount - oldMessageCount];
      }
   }
   else if (newMessageCount < oldMessageCount)
   {
      // We don't know really at this point if it's a marked-unread or a new message that has been read.  So guess.
      if (oldMessageCount - newMessageCount <= summaryNew)
      {
	 [summary setNewMessages:summaryNew + newMessageCount - oldMessageCount];
      }
      else
      {
	 [summary setNewMessages:0];
	 [summary setUnreadMessages:summaryUnread + newMessageCount - oldMessageCount + summaryNew];
      }
   }
   [self updateBrowserForMailBoxNamed:mailBoxName];
}

@end // EnhanceTransferPanel


#define STAT_EQ_FILE(s1, s2)	((s1)->st_ino == (s2)->st_ino && \
				 (s1)->st_dev == (s2)->st_dev)

#define STAT_EQ(s1, s2)		(STAT_EQ_FILE((s1), (s2)) && \
				 (s1)->st_mtime == (s2)->st_mtime && \
				 (s1)->st_size == (s2)->st_size)


@implementation EnhanceMailboxSummary

static HashTable *uniquehash = nil;

+ summaryForName:(const char *)name
{
   const char *fullname;
   id sum;
   if (!uniquehash) uniquehash = [[HashTable alloc] initKeyDesc:"*"];
	
   fullname = fullmboxname(name);
   if (!fullname) return nil;
	
   sum=[uniquehash valueForKey:fullname];
   //printf("found %s\n",sum?fullname:"(none)");
   if (!sum)
   {
      //printf("creating %s\n",fullname);
      sum = [[self alloc] initName:fullname];
   }
   return sum;
}

- initName:(const char *)name
{
   if (self = [super init])
   {
      loadStatus = EMS_UNLOADED;
      //printf("initName:%s\n",name);
      name = fullmboxname(name);
      if (name == NULL)
      {
	 [self free];
	 return nil;
      }
      myfullname = NXCopyStringBufferFromZone(name, [self zone]);
      //printf("myfullname:%s\n", myfullname);
      [uniquehash insertKey:myfullname value:self];
   }
   return self;
}

// Support methods

- (const char *)getPath:(char *)buf forFile:(const char *)file
{
   sprintf(buf, "%s/%s", myfullname, file);
#if DEBUG & 2
   fprintf(stderr, "%s: file=\"%s\" path=\"%s\"\n", isa->name, file, buf);
#endif
   return buf;
}

- (const char *)name { return myfullname; }

- (void)_reset
{
   int tag = NUMTAGS;

   while (--tag >= 0)
   {
      counts[tag]=0; ///sizes[tag]=0; attachCounts[tag]=0; attachSizes[tag]=0;
   }
}

- (enum EMSLoadStatus)load
{
   char path[MAXPATHLEN+1];
   FILE *tocf;
   struct stat oldstat = stats[STAT_TOC];    // XXX Ugh!
   BOOL shouldLoad = [self shouldLoad];	     // XXX Knows this reloads stats[].
   // Optimization: start reading at previous EOF if TOC grew.
   BOOL seekToEnd = (loadStatus == EMS_LOADED && accurate &&
		     STAT_EQ_FILE(&oldstat, &stats[STAT_TOC]) &&
		     oldstat.st_mtime <= stats[STAT_TOC].st_mtime &&
		     oldstat.st_size < stats[STAT_TOC].st_size &&
		     oldstat.st_size > sizeof(struct table_of_contents_header));
   // XXX Ugh galore!  This is getting very messy indeed...

   if ([self suppressLoad])
   {
      //puts("load suppressed".);
      loadStatus = EMS_LOADSUPPRESSED;
      accurate = NO;
      return loadStatus;
   }
   // Should also load if suppression status has changed.
   if (!(shouldLoad || loadStatus == EMS_LOADSUPPRESSED))
   {
      //puts("using cache");
      return loadStatus;
   }

   //puts("NOT using cache, loading...");
   loadStatus = EMS_UNLOADED;
   accurate = NO;

   if (!seekToEnd) [self _reset];
///else [self logNote:"DEBUG: %s: loading cache incrementally...", [self name]]; 

   if ((tocf = fopen([self getPath:path forFile:FILE_TOC], "rb")) != NULL)
   {
      struct table_of_contents_header *th;
#if 0 /* Does not work since setvbuf is not in Mail.app's symbol table :~( */
      // Enlarge stdio buffer size to read toc in one fell swoop.
#   define MAX_BUFSIZ   (((128 * 1024) + BUFSIZ - 1) / BUFSIZ * BUFSIZ)

      size_t bufsiz = (stats[STAT_TOC].st_size + BUFSIZ - 1) / BUFSIZ * BUFSIZ;

      if (bufsiz == 0) bufsiz = BUFSIZ;
      else if (bufsiz > MAX_BUFSIZ) bufsiz = MAX_BUFSIZ;

      setvbuf(tocf, NULL, _IOFBF, bufsiz);
#endif

  restart:

      if ((th = get_table_of_contents_header(tocf, NO)) != NULL)
      {
	 int msgCount = th->num_msgs;

	 free(th);

	 // Assume success.
	 loadStatus = EMS_LOADED;
	 accurate = YES;

	 if (seekToEnd)
	 {
	    msgCount -= counts[TAG_TOTAL];
	    fseek(tocf, oldstat.st_size, SEEK_SET);
	 }

	 // Tally read, new and deleted messages.
	 while (--msgCount >= 0)
	 {
	    struct message_index *mi;
	    ///long size, attachSize;
	    int tag;

	    if ((mi = get_message_index(tocf)) == NULL)
	    {
	       if (seekToEnd && !ferror(tocf))
	       {
		  // Non-fatal error: retry reading toc from the start.
		  [self logNote:"DEBUG: %s: incremental load failed, reloading...", [self name]]; 
		  seekToEnd = FALSE;
		  fseek(tocf, 0, SEEK_SET);
		  loadStatus = EMS_UNLOADED;
		  accurate = NO;
		  [self _reset];
		  goto restart;	// See?  I told you it was getting messy...
	       }
	       loadStatus = EMS_UNLOADED;
	       accurate = NO;
	       break;
	    }
	    switch (mi->status)
	    {
	    case '*':
	       tag = TAG_NEW;
	       break;
	    case 'd': case 'D':
	       tag = TAG_DELETED;
	       break;
	    case 'u': case 'U':
	       tag = TAG_UNREAD;
	       break;
	    case '+':
	       tag = TAG_FLAGGED;
	       break;
	    default:
	       tag = TAG_READ;
	       break;
	    }
#if 0
	    size = mi->mes_length;
	    if ((attachSize = message_attachsize(mi)) > 0)
	    {
	       attachCounts[tag]++;
	       attachSizes[tag] += attachSize;
	       attachCounts[TAG_TOTAL]++;
	       attachSizes[TAG_TOTAL] += attachSize;

	       size += attachSize;
	    }
#endif
	    counts[tag]++;
	    ///sizes[tag] += size;
	    counts[TAG_TOTAL]++;
	    ///sizes[TAG_TOTAL] += size;

	    free(mi);
	 }
      }
      fclose(tocf);
   }
   return loadStatus;
}

- (enum EMSLoadStatus)loadStatus { return loadStatus; }

- (BOOL)isLoaded { return loadStatus != EMS_UNLOADED; }

- (BOOL)shouldLoad
{
   char path[MAXPATHLEN+1];
   struct stat newstats[NUMSTATS];
   static const char * const filesToStat[NUMSTATS] = { FILESTOSTAT };
   BOOL result = NO;
   int i;

   for (i = 0;  i < NUMSTATS;  i++)
   {
      memset(&newstats[i], 0, sizeof(struct stat));
      stat([self getPath:path forFile:filesToStat[i]], &newstats[i]);
      if (!STAT_EQ(&newstats[i], &stats[i]))
      {
	 result = YES;
	 ///break; // NOT!!! must stat all for accurate cache.
      }
      stats[i] = newstats[i];
   }
   return result;
}

- (BOOL)suppressLoad
{
   return (stats[STAT_TOC].st_size / 1024 >= (unsigned)EnhanceMaxTocCheckSize);
}

- (long)numUnreadMessages  { return counts[TAG_UNREAD]; }
- (long)numNewMessages	   { return counts[TAG_NEW]; }
- (void)setUnreadMessages:(long)m   { counts[TAG_UNREAD]=m; accurate=NO; }
- (void)setNewMessages:(long)m	    { counts[TAG_NEW]=m; accurate=NO; }

@end // EnhanceMailboxSummary


// ripped off/adapted from mailapp-utilities/mailutil.c:

static int mailboxdir(char *buf)
{
   int len;
   const char *str;

   if (str=[[Defaults new] mailDir])
   {
      strcpy(buf,str);
   }
   else
   {
      strcpy(buf,"~/Mailboxes");
   }

   if ((buf[0]=='~') && (buf[1]=='/'))
   {
      char temp[MAXPATHLEN];
      if (!(str=NXHomeDirectory()) && !(str=getenv("HOME"))) return -1;
      strcpy(temp,buf+1);
      strcpy(buf,str);
      strcat(buf,temp);
   }

   len=strlen(buf);

   if (buf[len-1]=='/')
   {
      len--;
      buf[len]='\0';
   }
   
   return len;
}

static const char *fullmboxname(const char *name)
{
   static char mbox[MAXPATHLEN];
   int len;


   if (*name=='/')
   {
      strcpy(mbox,name);
   }
   else
   {
      if ((len=mailboxdir(mbox))<0) return NULL;
      mbox[len++]='/';
      strcpy(mbox+len,name);
   }

   len=strlen(mbox);
   if ((len<5)||(strcmp(mbox+len-5,".mbox"))) strcat(mbox,".mbox");
   
   return mbox;
}


@implementation EnhanceMailboxBrowserCell : NXBrowserCell

static NXImage *loadTiff(const char *fileName, const char *imageName)
{
   char path[MAXPATHLEN+1];
   NXImage *image=nil;

   if ([EnhanceBundle getPath:path forResource:fileName ofType:"tiff"])
   {
      image=[[NXImage alloc] initFromFile:path];
      if (imageName) [image setName:imageName];
   }
   return image;
}

+ finishLoading:(struct mach_header *)header
{
   EnhanceBundleInit();
   loadTiff("disabled", "EnhanceDisabled");
   loadTiff("disabledh", "EnhanceDisabledH");
   loadTiff("dots", "EnhanceDots");
   loadTiff("dotsh", "EnhanceDotsH");
   return self;
}

- (long)unread			{ return unread; }
- setUnread:(long)nUnread	{ unread = nUnread; return self; }

- drawInside:(const NXRect *)cellFrame inView:controlView
{
   [super drawInside:cellFrame inView:controlView];
   if ([self isLeaf] && unread!=0)
   {
      // draw number of unread messages plus bullet to the right
      static const int DOT_XOFFSET = 2;
      static id sharedTextCell = nil;
      NXRect rect;
      char numstr[20];
      BOOL hilite=(cFlags1.state || cFlags1.highlighted);
      NXImage *dot = [NXImage findImageNamed:
		      (unread > 0) ? (hilite ? "unread" : "unreadh") :
		      (unread==EMS_LOADSUPPRESSED) ? (hilite ? "EnhanceDisabled" : "EnhanceDisabledH") :
		      (hilite ? "EnhanceDots" : "EnhanceDotsH")];
      NXSize dotSize;
      NXPoint dotOrigin;

      [dot getSize:&dotSize];
      if (unread > 0)
      {
	 sprintf(numstr, "%lu", unread);

	 // make cell
	 if (!sharedTextCell)
	 {
	    sharedTextCell = [[TextFieldCell alloc] init];
	    [sharedTextCell setWrap:NO];
	    [sharedTextCell setFont:[self font]];
	    [sharedTextCell setTextGray:NX_DKGRAY];
	 }

	 // draw #unread, right-aligned (but leave room for dot).
	 [sharedTextCell setStringValueNoCopy:numstr];
	 [sharedTextCell calcCellSize:&rect.size];
	 NX_HEIGHT(&rect) = NX_HEIGHT(cellFrame);
	 NX_X(&rect) = NX_X(cellFrame) + NX_WIDTH(cellFrame) - NX_WIDTH(&rect) - dotSize.width;
	 NX_Y(&rect) = NX_Y(cellFrame);
	 [sharedTextCell setBackgroundGray:(cFlags1.state || cFlags1.highlighted) ? NX_WHITE : NX_LTGRAY];
	 [sharedTextCell drawInside:&rect inView:controlView];
      }
      // draw dot -- fudge to line it up with arrow icon.
      dotOrigin.x = NX_MAXX(cellFrame) - dotSize.width - DOT_XOFFSET;
      dotOrigin.y = (NX_Y(cellFrame) + NX_HEIGHT(cellFrame) -
		     (NX_HEIGHT(cellFrame) - dotSize.height) / 2);
      [dot composite:NX_SOVER toPoint:&dotOrigin];
   }
   return self;
}

@end // EnhanceMailboxBrowserCell
