/* Copyright (c) 1992, Scott Hess.  No rights reserved.  No
 * warranty is provided for this software, neither explicit nor
 * implied.  The source and object code for this file may be used
 * and modified as the user sees fit.
 */
#import <stdio.h>
#import <libc.h>
#import <sys/param.h>
#import <strings.h>
#import <sys/types.h>
#import <sys/uio.h>

#define USAGE \
"Usage: osc [directory] [-title aTitle] [-mini aTitle] [-window aTitle]\n" \
"\n" \
"osc sends Stuart OSC sequences to its standard output.  If the\n" \
"directory parameter is present, it is sent as part of the\n" \
"Directory-setting OSC sequence.  With no parameters, the current\n" \
"working directory is used as the directory.  -title causes the next\n" \
"string in the parameter list to be sent as part of a title-setting\n" \
"sequence.  -mini is similar except that it only sets the miniwindow\n" \
"title, and -window only sets the main window title.\n"

static inline void sendOSC( int which, const char *string)
{
    /* Use an iovec because that _has_ to be about 400 times faster
     * than a printf. No?
     *
     * Well, yes, it is a slight bit faster (around 15%), but it's
     * still no match for a shell's built-in echo.
     */
#ifdef USEIOVEC
    struct iovec output[]={
	{ "\033] ;", 4},
	{ (char *)string, strlen( string)},
	{ "\007", 1},
    };
    output->iov_base[ 2]=which+'0';
    writev( 0, output, 3);
#else
    printf( "\033]%d;%s\007", which, string);
#endif
}
void main( int argc, char *argv[])
{
    const char *dir=NULL;
    char buf[ MAXPATHLEN+1];
    const char *names[]={ "Title", "Mini", "Window"};
    if( argc==1) {
	dir=getwd( buf);
    }
    for( argv++; *argv; argv++) {
	if( **argv=='-') {
	    int which;
	    for( which=0; which<3; which++) {
		if( !strcasecmp( *argv+1, names[ which])) {
		    break;
		}
	    }
	    if( which==3) {
		fprintf( stderr, "%s", USAGE);
		exit( 0);
	    }
	    argv++;
	    sendOSC( which, *argv);
	    if( !*argv) {
		break;
	    }
	} else {
	    dir=*argv;
	}
    }
    if( dir) {
	sendOSC( 3, dir);
    }
}
