#import "InstallManager.h"

@implementation InstallManager

- (id)init
{
    [super init];
    command = [@"/usr/bin/installer.sh" retain];
    argAutomatic = [@"--automatic" retain];
    argInstall = [@"--install" retain];
    argDelete = [@"--delete" retain];
    argList = [@"--list" retain];
    argInfo = [@"--info" retain];
    [command retain];
    return self;
}

- (void)dealloc
{
    [command release];
    [argAutomatic release];
    [argInstall release];
    [argDelete release];
    [argList release];
    [argInfo release];
    [package release];
    return [super dealloc];
}

- (void)delete:(id)sender
{
    NSMutableArray *args;
    NSTask *aTask;

    aTask = [[NSTask alloc] init];
    [aTask setCurrentDirectoryPath:NSHomeDirectory()];
    [aTask setLaunchPath:command];
    args = [NSArray arrayWithObjects:
        argAutomatic,
        argDelete,
        package,
        nil];
    [aTask setArguments:args];
    [aTask launch];
    [aTask waitUntilExit];
}

- (void)install:(id)sender
{
    NSMutableArray *args;
    NSTask *aTask;

    aTask = [[NSTask alloc] init];
    [aTask setCurrentDirectoryPath:NSHomeDirectory()];
    [aTask setLaunchPath:command];
    args = [NSArray arrayWithObjects:
        argAutomatic,
        argInstall,
        package,
        [installDir stringValue],
        nil];
    [aTask setArguments:args];
    [aTask launch];
    [aTask waitUntilExit];
}

- (void)list:(id)sender
{
    NSMutableArray *args;
    NSTask *aTask;
    NSPipe *newPipe;
    NSFileHandle *readHandle;
    NSString *input = nil;

    aTask = [[NSTask alloc] init];
    newPipe = [NSPipe pipe];
    readHandle = [newPipe fileHandleForReading];
    [aTask setStandardOutput:newPipe];
    [aTask setCurrentDirectoryPath:NSHomeDirectory()];
    [aTask setLaunchPath:command];
    args = [NSArray arrayWithObjects:
        argList,
        package,
        nil];
    [aTask setArguments:args];
    [aTask launch];

    input = [[NSString alloc] initWithData:[readHandle readDataToEndOfFile]
                                  encoding:NSASCIIStringEncoding];
    [list setString:input];

    [readHandle closeFile];
}

- (void)select:(id)sender
{
    int result;
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];

    [oPanel setAllowsMultipleSelection:NO];
    [oPanel setCanChooseFiles:NO];
    [oPanel setCanChooseDirectories:YES];
    result = [oPanel runModalForDirectory:[installDir stringValue]
                                     file:nil
                                    types:nil];
    if (result == NSOKButton) {
        [installDir setStringValue:[oPanel filename]];
    }
}

- (BOOL)open:(NSString *)path
{
    NSMutableArray *args;
    NSTask *aTask;
    NSPipe *newPipe;
    NSFileHandle *readHandle;
    NSString *input = nil;
    NSRange r = {0, 0};
    NSRange t;

    if ([path hasSuffix:@"pkg"]) {
        package = [path retain];
        [window setTitle:[path lastPathComponent]];
    } else {
        return NO;
    }
    aTask = [[NSTask alloc] init];
    newPipe = [NSPipe pipe];
    readHandle = [newPipe fileHandleForReading];
    [aTask setStandardOutput:newPipe];
    [aTask setCurrentDirectoryPath:NSHomeDirectory()];
    [aTask setLaunchPath:command];
    args = [NSArray arrayWithObjects:
        argInfo,
        package,
        nil];
    [aTask setArguments:args];
    [aTask launch];

    input = [[NSString alloc] initWithData:[readHandle readDataToEndOfFile]
                                  encoding:NSASCIIStringEncoding];
    r = [input lineRangeForRange:r];
    r.length -= 1;
    [title setStringValue:[input substringWithRange:r]];
    r = [input lineRangeForRange:[input rangeOfString:@"Version: "]];
    r.location += 9;
    r.length -= 10;
    [version setStringValue:[input substringWithRange:r]];
    r = [input lineRangeForRange:[input rangeOfString:@"Description: "]];
    r.location += 13;
    r.length -= 14;
    [description setString:[input substringWithRange:r]];
    r = [input lineRangeForRange:[input rangeOfString:@"Status: "]];
    r.location += 8;
    r.length -= 9;
    t = [input rangeOfString:@"Not installed" options:NSLiteralSearch range:r];
    if (t.length == 0) {
        [installButton setEnabled:NO];
        [selectButton setEnabled:NO];
    } else {
        [deleteButton setEnabled:NO];
    }
    t = [input rangeOfString:@"/" options:NSLiteralSearch range:r];
    r.length -= (t.location  - r.location);
    r.location = t.location;
    t = [input rangeOfString:@" " options:NSLiteralSearch range:r];
    if (t.length == 0)
        t = [input rangeOfString:@")" options:NSLiteralSearch range:r];
    r.length = (t.location - r.location);
    [installDir setStringValue:[input substringWithRange:r]];

    [readHandle closeFile];
    [window makeKeyAndOrderFront:nil];
    return YES;
}

@end
