// Copyright (c) 1995-1996, Information Technology Solutions. 
//  All rights reserved.

#import "FBNPage.h"

@implementation FBNPage
	
	/*" This subclass of WWPage automatically appends a footer (see #footer)
	to every html string containing a named anchor matching FBN_FOOTER_ANCHOR
	passed to #initWithString:.  All initialization	methods call
	#initWithString:.
	"*/

+ (WWHtmlString *)footer
	/*" Returns the html string which will be inserted as a footer in html 
	doc's containing the FBN_FOOTER_ANCHOR. "*/
{
	static 	WWHtmlString	*footer		= nil;
	
	if (!footer) {
		footer = [[WWHtmlString alloc] initWithString:@"<hr> <a href=\"index.html\"><img src=\"FBN_home.gif\" height=64 width=90 alt=\"Fly By Night Shipping, Inc.\"></a>	<a href=\"/WRDemoMenu.bundle/info.html\"><img src=\"FBN_info.gif\" height=64 width=90 alt=\"WebRex (TM) Demo Information\"></a>	<p>Please send comments and questions to <a href=\"mailto:webmaster@its.com\">webmaster@its.com</a><br> Copyright &#169; 1995, <a href=\"http://www.its.com/index.html\"><FONT SIZE=\"-3\">Information Technology Solutions, Inc.</A>  All Rights Reserved.</FONT></p>"];
	}
	
	return footer;
}

+ (WWHtmlString *)header
	/*" Returns the html string which will be inserted as a header in html 
	doc's containing the FBN_HEADER_ANCHOR. "*/
{
	static 	WWHtmlString	*header		= nil;
	
	if (!header) {
		header = [[WWHtmlString alloc] initWithString:@"<img src=\"FBN_header.gif\" width=300 height=64>"];
	}
	
	return header;
}

- initWithString:(NSString *)html
{
	NSString 	*foot		= nil;
	NSString 	*head		= nil;
	[super initWithString:html];
	
	if ((foot = [[self class] footer]))
		[self bindValue:foot forAnchorWithName:FBN_FOOTER_ANCHOR];
	if ((head = [[self class] header]))
		[self bindValue:head forAnchorWithName:FBN_HEADER_ANCHOR];
	return self;
}

@end
