/*
         Unpublished Confidential Information of
  Information Technology Solutions, Inc. Do not disclose.
Copyright (c) Information Technology Solutions, Inc., 1994.
                  All Rights Reserved.

     500 West Madison, Suite 2210, Chicago, IL 60661
      312-474-7700  312-474-9361 (Fax)  info@its.com

Filename: ITSUniqueId.m
Author:   drew trieger

*/
#import "UniqueId.h"

// eos
#import "ITSUniqueID.h"


/*
 * Attributes key values
 */
 
#define ENTITY			@"ITSUniqueID"


@implementation UniqueId
	/*"
	This class was taken originally from drew davidson's itsfoundation stuff.
	I munged it so it would work in a better less dependent way for us. the
	basic idea is 
	"*/

/*-----------------------------< CLASS METHODS >-----------------------------*/

/*---------------------------< INIT/FREE METHODS >---------------------------*/
- initWithEntityNamed:(NSString *)ename sharedChannel:(ITSSharedChannel *)theSC
	/*"
	given the name of an entity in the database this program is connected
	to, assume there is already an entity named ENTITY with NAME_ATT and
	COUNT_ATT fields.  look for a row in this table where entityname is ename.
	if we dont find one, error.
	if we do, then we're ok.
	"*/
{
	EOQualifier			*q				= nil;
	NSArray				*resultSet		= nil;
	ITSUniqueID			*row			= nil;
	
	

	[super init];
	_theSC = [theSC retain];
	_entityName = [ename retain];
	[[theSC context] beginTransaction];
	_ds = [[EODatabaseDataSource alloc] initWithDatabaseChannel:[_theSC channel] 
				entityNamed:ENTITY];
	_en = [[[_theSC model] entityNamed:ENTITY] retain];

	q = [[[EOQualifier alloc] initWithEntity:_en
			qualifierFormat:@"%A = '%@'", @"entityName", _entityName] autorelease];
	[_ds setQualifier:q];
	resultSet = [_ds fetchObjects];
	if ((resultSet == nil) || ([resultSet count] == 0)) {
		// row for this entity doesn't exist, make one.
		row = [_ds createObject];
		[row setEntityName:ename];
		[row setIdCount:1];
		[row setMaxId:999999]; //ignored anyway.
		[_ds insertObject:row];
	}
	[[_theSC context] commitTransaction];

	return self;
}

/*-----------------------------< OTHER METHODS >-----------------------------*/


- (int)nextId
	/*"
	Get the next id.  there are locking issues here.  with any serious database,
	we should be ok, but quickbase has some holes in it so this code is slightly
	tuned to work with it.  this may be a fairly high performance method, possibly
	used in logging to the db how a user traverses the system.  in this case, there
	may be many processes executing this code simultaneously, so we must make
	sure our update to the db has integrity.
	"*/
{
	int					i				= 0;
	EOQualifier			*q				= nil;
	NSArray				*resultSet		= nil;
	ITSUniqueID			*row			= nil;
	BOOL				yn				= NO;
	//NSNumber			*test			= nil;

	[[_theSC context] beginTransaction];
	// quickbase specific way to lock the table.
	//yn = [[[_theSC channel] adaptorChannel] evaluateExpression:
			//[NSString stringWithFormat:@"WRITE TABLE %@",ENTITY]];
	yn = NO;
	q = [[[EOQualifier alloc] initWithEntity:_en
			qualifierFormat:@"%A = '%@'", @"entityName", _entityName] autorelease];
	[_ds setQualifier:q];
	resultSet = [_ds fetchObjects];
	if ((resultSet == nil) || ([resultSet count] != 1)) {
		[[_theSC context] commitTransaction];
		return (-1);
	}	
	row = [resultSet objectAtIndex:0];
	i = [row idCount];
	i++;
	[row setIdCount:i];
	[_ds updateObject:row];
	yn = [[_theSC context] commitTransaction];
	if (yn == YES) return (i);
		else return(-1);
}

@end
