// Copyright (c) 1995-6, Information Technology Solutions, inc. 
//	All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

#import <stdio.h>
#import <libc.h>

#define WW_BUFFER_LENGTH 256
#define WW_CR '\r'
#define WW_LF '\n'

typedef struct {
    unsigned char *buf;
    unsigned char *ptr;
    int len;
    int fd;
} WWBufferedFd;

WWBufferedFd *WWAllocBufferedFd (int fd);
    // Makes a buffer for an fd.  Does not "take ownership" of the fd.

void WWFreeBufferedFd (WWBufferedFd *bfd);
    // Frees the buffer, but does not close the fd.

int WWReadLine (WWBufferedFd *bfd, unsigned char *line, int length);
    // Reads a line of input, up to LF (all CRs are dropped) or length bytes
    // whichever comes first.  Returns the length of bytes read, or -1 on
    // error.

BOOL WWReadBytes (WWBufferedFd *bfd, unsigned char *bytes, int length);
    // Reads length bytes from the fd.  Returns NO on error.

BOOL WWReadLineIntoData (WWBufferedFd *bfd, NSMutableData *data);
BOOL WWReadBytesIntoData (WWBufferedFd *bfd, NSMutableData *data, int length);
    // These are the same as above, except they append to an NSMutableData.

#if 0
// Returns the next character or EOF (from stdio.h) on end-of-file.
static inline int WWNextChar (WWBufferedFd *bfd)
{
    // If the data is already in the buffer, then just return it.
    if (bfd->count > 0) {
	bfd->count--;
	return *bfd->ptr++;
    }
    
    // Ask for enough data to fill the buffer.
    bfd->count = read (bfd->fd, bfd->buf, WW_BUFFER_LENGTH);
    
    if (bfd->count <= 0)
	return EOF;
    
    bfd->count--;
    bfd->ptr = bfd->buf;
    
    return *bfd->ptr++;
}
#endif

