// WWRequest.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import "WWBufferedFd.h"

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

@class WWServer;
@class WWRequestHeader;

// This class along with WWServer may want to be forked into an abstract class
// and multiple concrete subclasses to handle the different kinds of data
// WWRequests can be generated from: HTTP requests straight from a socket, or
// from a CGI-bin interface.  Alternatively there can be a really simple data
// holding class, and the parsing, etc.  are on top of it so the initializers
// just build up the common request.

@interface WWRequest:NSObject
{
    WWServer		*_server;
    WWBufferedFd	*_bfd;
    NSMutableData	*_requestLine;
    NSString		*_method;
    NSString		*_urlPath;
    NSDictionary	*_urlQuery;
    int			_majorVersion;
    int			_minorVersion;
    NSString		*_ipAddress;
    int			_x;
    int			_y;
    
    WWRequestHeader *_header;
}

- initWithServer:(WWServer *)server;
    // This is the designated initializer for WWRequests.  It will get the
    // socket from the server.

- (WWServer *)server;
    // Returns the server which is responsible for this request.

- (NSString *)method;
    // returns the http method selector (GET, HEAD, PUT, POST, DELETE, LINK, 
    // UNLINK).

- (int)majorVersion;
- (int)minorVersion;
    // These return the version of the HTTP request.

- (NSString *)urlPath;
- (NSDictionary *)urlQuery;
    // These return the various bits of the url.
- (void)setUrlQuery:(NSDictionary *)aDict;

	// the ip address of the requestor.
- (NSString *)remoteIPAddress;

    // the X and Y coordinates of a possible imagemap query
- (int) x;
- (int) y;
@end


@interface WWRequest (WWRequestHeaderStuff)

- (NSString *)basicUserAuthorization;
- (NSString *)basicPasswordAuthorization;

@end

