// WWResponse.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

@class WWServer;
@class WWPage;

@interface WWResponse:NSObject
{
    int _statusCode;
    NSString *_statusReason;
    
    NSData *_data;
    
    // This is a temporary structure.  There probably needs to be a MIME
    // header class which is also used in the WWRequest class.
    
    NSMutableArray *_headers;
    NSMutableArray *_values;
}

+ (NSString *)contentTypeForExtension:(NSString *)extension;
    // This is a global mapping from file extension to content type.

+ (WWResponse *)responseWithPage:(WWPage *)page;
+ (WWResponse *)responseWithFile:(NSString *)file;
+ (WWResponse *)responseWithRedirectToURL:(NSString *)url;
+ (WWResponse *)responseWithServerError;
    // probably want to take some kind of arg here...
+ (WWResponse *)responseWithNotFoundError;
    // an arg?
    // Convenience methods to send the common responses.
+ (WWResponse *)responseWithImageMapError:(char *)msg;

- (void)setData:(NSData *)data contentType:(NSString *)type;
    // This is the meat of the response.  It automatically sets the
    // Content-Type: header and Content-Length: headers.

- (void)setExpireNow;
    // I haven't yet seen a browser which pays attention to the Expires:
    // header.

- (void)setStatusCode:(int)code reason:(NSString *)reason;
    // This allows clients to set the status line of the response.  Should
    // probably have an enum with the different codes and reasons.

// Should probably have explicit API for all the official headers.

- (void)setValue:(NSString *)value forHeader:(NSString *)header;
    // This doesn't act like a dictionary.  You can have multiple headers with
    // the same name.  Maybe it should act like a dictionary for headers where
    // it is invalid to have more than one.

- (void)send;
    // Make it so.  This is not something you typically call yourself, but is 
    // called by the WWServer.

@end


// These are non-primitive convenience methods on WWResponse.  Some methods
// above belong here.

@interface WWResponse (WWResposeExtras)

+ (WWResponse *)responseWithUnauthorizedForRealm:(NSString *)realm;

@end

