// WWServer.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>
#import <foundation/NSBundle.h>
#import <sys/time.h>

@class WWRequest;
@class WWResponse;
@class WWApplet;

@interface WWServer:NSObject
{
    int					_masterSocket;
    int					_slaveSocket;
    int					_queueLength;
    
    NSString			*_serviceName;
    NSString			*_documentRoot;
    NSString			*_logDirectory;
    NSDictionary		*_configuration;
    
    WWRequest			*_currentRequest;
    NSMutableDictionary *_appletBundlesByBaseLocator;
    NSMutableDictionary *_appletClassNameByBaseLocator;
    NSMutableDictionary *_appletMethodMappingByBaseLocator;
    NSMutableDictionary *_cachedResourcesByBaseLocator;
    
    NSString			*_cachedUrlPath;
    NSString			*_cachedBaseLocator;
    NSString			*_cachedRelativeLocator;
    BOOL				_cachedNeedsTrailingSlash;
    
    int					_pid;
    int					_processCount;
    BOOL				_debug;
    
    // for Timing category.
    struct timeval		_tpStart,_tpFinish;
    struct timeval		_tpAppStart,_tpAppFinish;
    struct timezone		_tzpStart,_tzpFinish;
    struct timezone		_tzpAppStart,_tzpAppFinish;
	double				_appletExecutionTime;
}

+ (WWServer *)sharedServer;
    // There is only one instance of the WWServer class per process.

- init;
    // This is the primitive init method.  It gives you a basic, unconfigured
    // server.

- initWithArgc:(int)argc argv:(const char **)argv;
    // Initialize the server with the command line.  This reads the standard
    // options and sets the server up to be run.

- (void)setServiceName:(NSString *)service;
- (NSString *)serviceName;
    // the service name the tcp socket will be bound to -- by default this is
    // "http".  this can be a service name or a port number.  it can only be
    // set before running the server.

- (NSString *)documentRootDirectory;
    // This is the path of the root directory of the documents which are
    // being served.
- (NSString *)logDirectory;


- (void)setConfiguration:(NSDictionary *)configuration;
- (NSDictionary *)configuration;
    // sets and gets the configuration property list for the server.  this
    // should not be set after the server is running.

- (NSString *)baseLocatorForUrlPath:(NSString *)urlPath;
- (NSString *)relativeLocatorForUrlPath:(NSString *)urlPath;
- (BOOL)trailingSlashNeededForUrlPath:(NSString *)urlPath;
    // These are the methods for mapping Urls onto custom applications.

- (NSString *)appletClassNameForBaseLocator:(NSString *)baseLocator;
- (NSDictionary *)appletMethodMappingForBaseLocator:(NSString *)baseLocator;
- (NSBundle *)bundleForBaseLocator:(NSString *)baseLocator;
- (NSMutableDictionary *)cachedResourcesForKey:(NSString *)key;
    // These methods return some resources for a particular applet referenced
    // by base locator or whatever key you want (perhaps applet wide)

- (WWApplet *)appletForBaseLocator:(NSString *)baseLocator;
    // This allocs and inits a new instance of the applet for the baseLocator.
    // Returns nil if there is no applet class name for that baseLocator.

- (WWRequest *)currentRequest;
- (void)setCurrentRequest:(WWRequest *)request;
    // returns the request currently being processed.  returns nil if no
    // request is being processed.

- (BOOL)isRunning;
    // tests to see whether the server is running.

- (BOOL)_fork;
	// convience internal private method.
- (void)run;
    // begins accepting connections.  never returns.

- (void)terminate:sender;
    // closes all open resources, frees the WWServer, and exits the process.

- (void)dispatchRequest:(WWRequest *)request;
    // forks, sends DO messages, or whatever to set things up, then sets
    // _currentRequest and the sockets, locates a receiver for the request,
    // and invokes responseForRequest:... on the receiver.

- (void)_checkForExpiredLicense;

- (int)_masterSocket;
- (int)_slaveSocket;
    // you should never touch these.  things will get out of wack.

	// private method. encapsulates things that are different on 
	// different PDO machines.
- (int)_getFileDescriptorTableSize;
- (int)_waitForChildren;
- _detachAndSetPGrp;
- (NSString *)pidStr;
- (int)pid;

@end

