// WWTable.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

@class WWHtmlString;

@interface WWTable:NSObject
{
    NSMutableArray	*_columnNames;
    NSMutableArray	*_columnKeys;
    NSMutableArray	*_columnWidths;
	NSMutableArray	*_columnUrls;
	NSMutableArray	*_columnUrlKeys;
    
    NSString		*_urlLink;
    NSString		*_urlLinkKey;
    
    NSArray			*_dataObjects;
	
	BOOL			_globalURL;
}

- init;
- (void)addColumn:(NSString *)columnName key:(NSString *)key width:(int)width;
- (void)addColumn:(NSString *)columnName key:(NSString *)key urlKey:(NSString *)url width:(int)width;
- (void)addColumn:(NSString *)columnName key:(NSString *)key url:(NSString *)url urlKey:(NSString *)urlKey width:(int)width;
- (void)linkToURL:(NSString *)url key:(NSString *)key;
- (void)setObjects:(NSArray *)objects;
- (WWHtmlString *)htmlDescription;

@end

